/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.DecoratorPanel;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableIconFactory;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangeManager;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangePluginEvent;
import ghidra.app.plugin.core.byteviewer.ByteViewerActionContext;
import ghidra.app.plugin.core.byteviewer.ByteViewerClipboardProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerLocationMemento;
import ghidra.app.plugin.core.byteviewer.ByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteViewerProgramLocation;
import ghidra.app.plugin.core.byteviewer.ByteViewerState;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteEditInfo;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.ProgramDataFormatModel;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.HighlightProvider;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Tool;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.ResourceManager;

public class ProgramByteViewerComponentProvider
extends ByteViewerComponentProvider
implements DomainObjectListener,
Navigatable {
    private ImageIcon navigatableIcon;
    protected DecoratorPanel decorationComponent;
    private WeakSet<NavigatableRemovalListener> navigationListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private CloneByteViewerAction cloneByteViewerAction;
    protected Program program;
    protected ProgramSelection currentSelection;
    protected ProgramSelection currentHighlight;
    protected ProgramLocation currentLocation;
    private ClipboardService clipboardService;
    private ByteViewerClipboardProvider clipboardProvider;
    private final boolean isConnected;
    private boolean disposed;

    public ProgramByteViewerComponentProvider(PluginTool tool, ByteViewerPlugin plugin, boolean isConnected) {
        super(tool, plugin, "Bytes", ByteViewerActionContext.class);
        this.isConnected = isConnected;
        this.decorationComponent = new DecoratorPanel((JComponent)this.panel, isConnected);
        this.clipboardProvider = new ByteViewerClipboardProvider(this, tool);
        this.addToTool();
        this.createProgramActions();
        this.updateTitle();
        this.registerNavigatable();
    }

    public void createProgramActions() {
        this.cloneByteViewerAction = new CloneByteViewerAction();
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.cloneByteViewerAction);
    }

    @Override
    public JComponent getComponent() {
        return this.decorationComponent;
    }

    public String getWindowGroup() {
        if (this.isConnected()) {
            return "";
        }
        return "disconnected";
    }

    public void componentShown() {
        this.panel.refreshView();
        if (this.currentLocation != null) {
            this.setLocation(this.currentLocation);
        }
        if (this.currentSelection != null) {
            this.setSelection(this.currentSelection, false);
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        return this.getByteViewerActionContext();
    }

    ByteViewerActionContext getByteViewerActionContext() {
        ByteBlockInfo info = this.panel.getCursorLocation();
        if (info == null) {
            return null;
        }
        return new ByteViewerActionContext(this);
    }

    public void closeComponent() {
        this.plugin.closeProvider(this);
    }

    public boolean isTransient() {
        return false;
    }

    public void setSelection(ProgramSelection selection) {
        this.setSelection(selection, true);
    }

    public ProgramSelection getSelection() {
        return this.currentSelection;
    }

    public ProgramSelection getHighlight() {
        return this.currentHighlight;
    }

    private void setSelection(ProgramSelection selection, boolean notify) {
        this.currentSelection = selection;
        if (selection == null) {
            return;
        }
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        ByteBlockSelection blockSelection = this.blockSet.getBlockSelection(selection);
        this.clipboardProvider.setSelection(this.currentSelection);
        this.panel.setViewerSelection(blockSelection);
        if (notify) {
            ProgramSelectionPluginEvent selectionEvent = this.blockSet.getPluginEvent(this.getName(), blockSelection);
            this.plugin.updateSelection(this, selectionEvent, this.program);
        }
        this.contextChanged();
    }

    public boolean supportsHighlight() {
        return true;
    }

    public void setHighlight(ProgramSelection newHighlight) {
        this.currentHighlight = newHighlight;
        if (newHighlight == null) {
            return;
        }
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        ByteBlockSelection highlight = this.blockSet.getBlockSelection(this.currentHighlight);
        this.panel.setViewerHighlight(highlight);
        this.contextChanged();
        this.plugin.highlightChanged(this, newHighlight);
    }

    void enablePaste(boolean enabled) {
        this.clipboardProvider.setPasteEnabled(enabled);
    }

    void doSetProgram(Program newProgram) {
        this.setOptionsAction.setEnabled(newProgram != null);
        this.cloneByteViewerAction.setEnabled(newProgram != null);
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = newProgram;
        this.clipboardProvider.setProgram(newProgram);
        for (ByteViewerComponent byteViewerComponent : this.viewMap.values()) {
            DataFormatModel dataModel = byteViewerComponent.getDataModel();
            if (!(dataModel instanceof ProgramDataFormatModel)) continue;
            ((ProgramDataFormatModel)dataModel).setProgram(newProgram);
        }
        if (newProgram != null) {
            newProgram.addListener((DomainObjectListener)this);
        }
        this.setByteBlocks(null);
        this.updateTitle();
    }

    private void updateTitle() {
        String title = "Bytes: " + (this.program == null ? "No Program" : this.program.getDomainFile().getName());
        if (!this.isConnected()) {
            title = "[" + title + "]";
        }
        this.setTitle(title);
    }

    public ProgramLocation getLocation() {
        return this.currentLocation;
    }

    public Program getProgram() {
        return this.program;
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        if (gotoProgram != this.program) {
            if (!this.isConnected()) {
                this.tool.setStatusInfo("Program location not applicable for this provider!");
                return false;
            }
            ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
            if (programManagerService != null) {
                programManagerService.setCurrentProgram(gotoProgram);
            }
        }
        this.setLocation(location, false);
        return true;
    }

    public LocationMemento getMemento() {
        ByteBlockInfo info = this.panel.getCursorLocation();
        int blockNumber = -1;
        BigInteger blockOffset = null;
        int column = 0;
        if (info != null) {
            blockNumber = this.getBlockNumber(info);
            blockOffset = info.getOffset();
            column = info.getColumn();
        }
        ViewerPosition vp = this.panel.getViewerPosition();
        return new ByteViewerLocationMemento(this.program, this.currentLocation, blockNumber, blockOffset, column, vp);
    }

    public void setMemento(LocationMemento memento) {
        ByteViewerLocationMemento bvMemento = (ByteViewerLocationMemento)memento;
        int blockNumber = bvMemento.getBlockNum();
        BigInteger blockOffset = bvMemento.getBlockOffset();
        ViewerPosition vp = bvMemento.getViewerPosition();
        int column = bvMemento.getColumn();
        ByteBlock[] blocks = this.getByteBlocks();
        if (blocks != null && blockNumber >= 0 && blockNumber < blocks.length) {
            ByteViewerState view = new ByteViewerState(this.blockSet, new ByteBlockInfo(blocks[blockNumber], blockOffset, column), vp);
            this.panel.returnToView(view);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean supportsMarkers() {
        return this.isConnected;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Icon getIcon() {
        if (this.isConnected()) {
            return super.getIcon();
        }
        if (this.navigatableIcon == null) {
            Icon primaryIcon = super.getIcon();
            this.navigatableIcon = NavigatableIconFactory.createSnapshotOverlayIcon((Icon)primaryIcon);
        }
        return this.navigatableIcon;
    }

    public Icon getNavigatableIcon() {
        return this.getIcon();
    }

    public boolean isVisible() {
        return this.tool.isVisible((ComponentProvider)this);
    }

    public void requestFocus() {
        this.panel.getCurrentComponent().requestFocus();
        this.tool.toFront((ComponentProvider)this);
    }

    private void setLocation(ProgramLocation location, boolean fireEvent) {
        CodeUnit cu;
        this.currentLocation = location;
        if (location == null) {
            return;
        }
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        this.clipboardProvider.setLocation(location);
        Address address = location.getByteAddress();
        if (!this.program.getMemory().contains(address) && (cu = this.program.getListing().getCodeUnitAfter(address)) != null) {
            address = cu.getMinAddress();
        }
        if (address == null) {
            return;
        }
        ByteBlockInfo byteBlockInfo = this.blockSet.getByteBlockInfo(address);
        if (byteBlockInfo == null) {
            return;
        }
        ByteBlock block = byteBlockInfo.getBlock();
        BigInteger blockOffset = byteBlockInfo.getOffset();
        int column = 0;
        if (location instanceof ByteViewerProgramLocation) {
            column = location.getCharOffset();
        }
        this.panel.setCursorLocation(block, blockOffset, column);
        Address blockSetAddress = this.blockSet.getAddress(block, blockOffset);
        if (blockSetAddress == null) {
            return;
        }
        this.currentLocation = this.getLocation(block, blockOffset, column);
        if (fireEvent && this.tool.isVisible((ComponentProvider)this)) {
            this.updateLocation(block, blockOffset, column, false);
            this.plugin.fireProgramLocationPluginEvent(this, this.blockSet.getPluginEvent(this.getName(), block, blockOffset, column));
        } else {
            this.contextChanged();
        }
    }

    ProgramLocation getLocation(ByteBlock block, BigInteger offset, int column) {
        Address address = this.blockSet.getAddress(block, offset);
        int characterOffset = column;
        ByteViewerProgramLocation loc = new ByteViewerProgramLocation(this.program, address, characterOffset);
        return loc;
    }

    void setLocation(ProgramLocation location) {
        this.setLocation(location, false);
    }

    void memoryConfigurationChanged() {
        ProgramLocation location = this.currentLocation;
        ProgramSelection selection = this.currentSelection;
        ByteBlockChangeManager bbcm = null;
        if (this.blockSet != null) {
            bbcm = this.blockSet.getByteBlockChangeManager();
        }
        this.setByteBlocks(bbcm);
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        this.setLocation(location, true);
        this.setSelection(selection, true);
    }

    void doHandleEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program newProgram = ev.getActiveProgram();
            this.doSetProgram(newProgram);
            this.setLocation(null);
            this.setSelection(null, false);
            return;
        }
        ByteBlock[] blocks = this.getByteBlocks();
        if (blocks == null) {
            return;
        }
        if (event instanceof ByteBlockChangePluginEvent) {
            this.blockSet.processByteBlockChangeEvent((ByteBlockChangePluginEvent)event);
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.processLocationEvent(ev);
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            this.processSelectionEvent(ev);
        } else if (event instanceof ProgramHighlightPluginEvent) {
            this.processHighlightEvent((ProgramHighlightPluginEvent)event);
        }
    }

    private void processHighlightEvent(ProgramHighlightPluginEvent event) {
        ProgramSelection programSelection = event.getHighlight();
        this.setHighlight(programSelection);
    }

    private void processSelectionEvent(ProgramSelectionPluginEvent event) {
        ProgramSelection programSelection = event.getSelection();
        this.setSelection(programSelection);
    }

    private void processLocationEvent(ProgramLocationPluginEvent event) {
        ProgramLocation loc = event.getLocation();
        this.setLocation(loc);
    }

    public void notifyEdit(ByteEditInfo edit) {
        if (this.tool.isVisible((ComponentProvider)this)) {
            this.plugin.firePluginEvent(new ByteBlockChangePluginEvent(this.plugin.getName(), edit, this.program));
        }
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    ProgramSelection getCurrentSelection() {
        return this.currentSelection;
    }

    String getCurrentTextSelection() {
        return this.panel.getCurrentComponent().getTextForSelection();
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (this.blockSet != null && (event.containsEvent(1) || event.containsEvent(2))) {
            this.blockSet.setByteBlockChangeManager(new ByteBlockChangeManager(this.blockSet));
            this.updateManager.update();
        }
        if (event.containsEvent(4) || event.containsEvent(22) || event.containsEvent(20) || event.containsEvent(23) || event.containsEvent(21) || event.containsEvent(25) || event.containsEvent(24)) {
            this.memoryConfigurationChanged();
            return;
        }
        if (event.containsEvent(26) || event.containsEvent(30) || event.containsEvent(60)) {
            this.updateManager.update();
        }
    }

    private ProgramByteBlockSet getByteBlockSet(ByteBlockChangeManager changeManager) {
        if (this.program == null) {
            return null;
        }
        return new ProgramByteBlockSet(this, this.program, changeManager);
    }

    protected void setByteBlocks(ByteBlockChangeManager changeManager) {
        if (this.blockSet != null) {
            this.blockSet.dispose();
        }
        this.blockSet = this.getByteBlockSet(changeManager);
        this.panel.setByteBlocks(this.blockSet);
    }

    @Override
    void updateSelection(ByteBlockSelection selection) {
        ProgramSelectionPluginEvent event = this.blockSet.getPluginEvent(this.plugin.getName(), selection);
        this.currentSelection = event.getSelection();
        this.plugin.updateSelection(this, event, this.program);
        this.clipboardProvider.setSelection(this.currentSelection);
        this.contextChanged();
    }

    @Override
    void updateLocation(ByteBlock block, BigInteger blockOffset, int column, boolean export) {
        ProgramLocationPluginEvent event = this.blockSet.getPluginEvent(this.plugin.getName(), block, blockOffset, column);
        this.currentLocation = event.getLocation();
        this.plugin.updateLocation(this, event, export);
        this.clipboardProvider.setLocation(this.currentLocation);
        this.contextChanged();
    }

    void readDataState(SaveState saveState) {
        this.unRegisterNavigatable();
        this.initializeInstanceID(saveState.getLong("NAV_ID", this.getInstanceID()));
        this.registerNavigatable();
        this.restoreLocation(saveState);
    }

    void restoreLocation(SaveState saveState) {
        int blockNumber = saveState.getInt("Block Num", 0);
        BigInteger blockOffset = new BigInteger(saveState.getString("Block Offset", "0"));
        int column = saveState.getInt("Block Column", 0);
        int index = saveState.getInt("Index", 0);
        int xOffset = saveState.getInt("X Offset", 0);
        int yOffset = saveState.getInt("Y Offset", 0);
        ViewerPosition vp = new ViewerPosition(index, xOffset, yOffset);
        ByteBlock[] blocks = this.getByteBlocks();
        if (blocks != null && blockNumber >= 0 && blockNumber < blocks.length) {
            ByteViewerState view = new ByteViewerState(this.blockSet, new ByteBlockInfo(blocks[blockNumber], blockOffset, column), vp);
            this.panel.returnToView(view);
        }
    }

    Object getUndoRedoState(DomainObject domainObject) {
        if (this.program != domainObject || this.blockSet == null) {
            return null;
        }
        return this.blockSet.getUndoRedoState();
    }

    void restoreUndoRedoState(DomainObject domainObject, Object state) {
        if (this.program != domainObject || this.blockSet == null) {
            return;
        }
        SaveState saveState = (SaveState)state;
        this.blockSet.restoreUndoReoState(saveState);
    }

    void writeDataState(SaveState saveState) {
        saveState.putLong("NAV_ID", this.getInstanceID());
        ByteBlockInfo info = this.panel.getCursorLocation();
        int blockNumber = -1;
        String blockOffset = "0";
        int column = 0;
        if (info != null) {
            blockNumber = this.getBlockNumber(info);
            blockOffset = info.getOffset().toString();
            column = info.getColumn();
        }
        saveState.putInt("Block Num", blockNumber);
        saveState.putString("Block Offset", blockOffset);
        saveState.putInt("Block Column", column);
        ViewerPosition vp = this.panel.getViewerPosition();
        saveState.putInt("Index", vp.getIndexAsInt());
        saveState.putInt("X Offset", vp.getXOffset());
        saveState.putInt("Y Offset", vp.getYOffset());
    }

    private int getBlockNumber(ByteBlockInfo info) {
        ByteBlock[] blocks = this.getByteBlocks();
        ByteBlock b = info.getBlock();
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] != b) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataFormatModel getDataFormatModel(String formatName) {
        DataFormatModel dataFormatModel = super.getDataFormatModel(formatName);
        if (dataFormatModel instanceof ProgramDataFormatModel) {
            ((ProgramDataFormatModel)dataFormatModel).setProgram(this.program);
        }
        return dataFormatModel;
    }

    @Override
    void setEditMode(boolean isEditable) {
        super.setEditMode(isEditable);
        this.enablePaste(isEditable);
    }

    @Override
    void dispose() {
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = null;
        this.setByteBlocks(null);
        if (this.clipboardService != null) {
            this.clipboardService.deRegisterClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
        this.disposed = true;
        this.unRegisterNavigatable();
        super.dispose();
    }

    @Override
    protected Set<DataFormatModel> getDataFormatModels() {
        Set<DataFormatModel> dataFormatModels = super.getDataFormatModels();
        Set instances = ClassSearcher.getInstances(ProgramDataFormatModel.class);
        dataFormatModels.addAll(instances);
        return dataFormatModels;
    }

    public void addNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    void registerNavigatable() {
        NavigatableRegistry.registerNavigatable((Tool)this.tool, (Navigatable)this);
    }

    void unRegisterNavigatable() {
        NavigatableRegistry.unregisterNavigatable((Tool)this.tool, (Navigatable)this);
        for (NavigatableRemovalListener listener : this.navigationListeners) {
            listener.navigatableRemoved((Navigatable)this);
        }
    }

    void setClipboardService(ClipboardService service) {
        this.clipboardService = service;
        if (this.clipboardService != null) {
            this.clipboardService.registerClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
    }

    public void removeHighlightProvider(HighlightProvider highlightProvider, Program p) {
    }

    public void setHighlightProvider(HighlightProvider highlightProvider, Program p) {
    }

    private class CloneByteViewerAction
    extends DockingAction {
        public CloneByteViewerAction() {
            super("ByteViewer Clone", ProgramByteViewerComponentProvider.this.plugin.getName());
            ImageIcon image = ResourceManager.loadImage((String)"images/camera-photo.png");
            this.setToolBarData(new ToolBarData((Icon)image, "ZZZ"));
            this.setDescription("Create a snapshot (disconnected) copy of this Bytes window ");
            this.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
            this.setKeyBindingData(new KeyBindingData(84, 192));
        }

        public void actionPerformed(ActionContext context) {
            ProgramByteViewerComponentProvider newProvider = new ProgramByteViewerComponentProvider(ProgramByteViewerComponentProvider.this.tool, ProgramByteViewerComponentProvider.this.plugin, false);
            ProgramByteViewerComponentProvider.this.plugin.addProvider(newProvider);
            SaveState saveState = new SaveState();
            ProgramByteViewerComponentProvider.this.writeConfigState(saveState);
            newProvider.readConfigState(saveState);
            ProgramByteViewerComponentProvider.this.tool.showComponentProvider((ComponentProvider)newProvider, true);
            newProvider.doSetProgram(ProgramByteViewerComponentProvider.this.program);
            newProvider.setLocation(ProgramByteViewerComponentProvider.this.currentLocation);
            newProvider.setSelection(ProgramByteViewerComponentProvider.this.currentSelection, false);
            newProvider.setHighlight(ProgramByteViewerComponentProvider.this.currentHighlight);
            ViewerPosition viewerPosition = ProgramByteViewerComponentProvider.this.panel.getViewerPosition();
            newProvider.panel.setViewerPosition(viewerPosition);
        }
    }
}

