/*
 * Decompiled with CFR 0.152.
 */
package help.screenshot;

import help.GHelpBuilder;
import help.HelpBuildUtils;
import help.validator.UnusedHelpImageFileFinder;
import help.validator.location.DirectoryHelpModuleLocation;
import help.validator.location.HelpModuleLocation;
import help.validator.model.HelpTopic;
import help.validator.model.IMG;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;

public class HelpMissingScreenShotReportGenerator {
    private static boolean debugEnabled;
    private static final String DEBUG_OPTION = "-debug";
    private static final String SCREEN_SHOTS = "ScreenShots";
    private static final String PNG_EXT = ".png";
    private static final String JAVA_DIR = "java";
    private static final String TEST = "test";
    private static final String CAPTURE = "Capture";
    private static final String CUSTOM_NAME = "Custom";
    private Set<HelpModuleLocation> helpDirectories = new HashSet<HelpModuleLocation>();
    private Map<String, HelpTopic> topicNameToTopic = new HashMap<String, HelpTopic>();
    private Set<HelpTestCase> testCases = new HashSet<HelpTestCase>();
    private Map<String, HelpTestCase> imageNameToTestCase = new HashMap<String, HelpTestCase>();
    private SortedSet<String> badlyNamedTestFiles = new TreeSet<String>();
    private SortedSet<HelpTestCase> badlyNamedTestCases = new TreeSet<HelpTestCase>();
    private Map<HelpTopic, Set<IMG>> untestedImages = new TreeMap<HelpTopic, Set<IMG>>();
    private Set<Path> examinedImageFiles = new HashSet<Path>();
    private File outputFile;

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            throw new Exception("Expecting at least 3 args: <output file path> <help modules> <screen shot tests> [-debug]");
        }
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(DEBUG_OPTION)) continue;
            debugEnabled = true;
        }
        HelpMissingScreenShotReportGenerator generator = new HelpMissingScreenShotReportGenerator(args[0], args[1], args[2]);
        generator.generateReport();
    }

    HelpMissingScreenShotReportGenerator(String outputFilePath, String helpModulePaths, String screenShotPaths) {
        this.outputFile = new File(outputFilePath);
        this.parseHelpDirectories(helpModulePaths);
        this.parseScreenShots(screenShotPaths);
        this.validateScreenShotTests();
        this.validateHelpImages();
    }

    void generateReport() {
        this.outputFile.getParentFile().mkdirs();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.outputFile));
            this.doGenerateReport(writer);
            System.out.println("Report written to " + this.outputFile);
        }
        catch (Exception e) {
            HelpMissingScreenShotReportGenerator.errorMessage("FAILED!", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doGenerateReport(BufferedWriter writer) throws IOException {
        this.writeHeader(writer);
        writer.write("<P>\n");
        int untestedCount = 0;
        Collection<Set<IMG>> values = this.untestedImages.values();
        for (Set<IMG> set : values) {
            untestedCount += set.size();
        }
        int totalImageCount = this.imageNameToTestCase.size() + untestedCount;
        writer.write("<H3>\n");
        writer.write("Total Image Count: " + totalImageCount + "\n");
        writer.write("</H3>\n");
        writer.write("<H3>\n");
        writer.write("Total Tested Images: " + this.imageNameToTestCase.size() + "\n");
        writer.write("</H3>\n");
        writer.write("<H3>\n");
        writer.write("Improperly Named Test Files: " + this.badlyNamedTestFiles.size() + "\n");
        writer.write("</H3>\n");
        writer.write("<P>\n");
        writer.write("<TABLE BORDER=\"1\">\n");
        for (String string : this.badlyNamedTestFiles) {
            writer.write("    <TR>\n");
            writer.write("        <TD>\n");
            writer.write("            ");
            writer.write(string);
            writer.write(10);
            writer.write("        </TD>\n");
            writer.write("    </TR>\n");
        }
        writer.write("</TABLE>\n");
        writer.write("</P>\n");
        writer.write("<H3>\n");
        writer.write("Improperly Named Test Cases: " + this.badlyNamedTestCases.size() + "\n");
        writer.write("</H3>\n");
        writer.write("<P>\n");
        writer.write("<TABLE BORDER=\"1\">\n");
        writer.write("    <TH>\n");
        writer.write("        Test Case\n");
        writer.write("    </TH>\n");
        writer.write("    <TH>\n");
        writer.write("        Image Name\n");
        writer.write("    </TH>\n");
        Object var5_8 = null;
        for (HelpTestCase testCase : this.badlyNamedTestCases) {
            void var5_9;
            writer.write("    <TR>\n");
            writer.write("        <TD>\n");
            writer.write("            ");
            String topicName = testCase.getHelpTopic().getName();
            if (!topicName.equals(var5_9)) {
                String string = topicName;
                writer.write(topicName);
                writer.write(10);
            } else {
                writer.write("&nbsp;\n");
            }
            writer.write("        </TD>\n");
            writer.write("        <TD>\n");
            writer.write("            ");
            writer.write(testCase.getTestName());
            writer.write("()\n");
            writer.write("        </TD>\n");
            writer.write("    </TR>\n");
        }
        writer.write("</TABLE>\n");
        writer.write("</P>\n");
        File file = new File(this.outputFile.getParentFile(), "_untested.images.html");
        writer.write("<H3>\n");
        writer.write("<A HREF=\"" + file.getName() + "\">Total Untested Images: " + untestedCount + "</A>\n");
        writer.write("</H3>\n");
        this.generateUntestedImagesFile(file);
        Set<Path> unusedImages = this.getUnusedImages();
        writer.write("<H3>\n");
        writer.write("Total Unused Images: " + unusedImages.size() + "\n");
        writer.write("</H3>\n");
        writer.write("<P>\n");
        writer.write("<TABLE BORDER=\"1\">\n");
        writer.write("    <TH>\n");
        writer.write("        Help Topic\n");
        writer.write("    </TH>\n");
        writer.write("    <TH>\n");
        writer.write("        Image Name\n");
        writer.write("    </TH>\n");
        for (Path imageFile : unusedImages) {
            void var5_11;
            Path helpTopicDir = HelpBuildUtils.getHelpTopicDir(imageFile);
            writer.write("    <TR>\n");
            writer.write("        <TD>\n");
            writer.write("            ");
            String topicName = helpTopicDir.getFileName().toString();
            if (!topicName.equals(var5_11)) {
                String string = topicName;
                writer.write(topicName);
                writer.write(10);
            } else {
                writer.write("&nbsp;\n");
            }
            writer.write("        </TD>\n");
            writer.write("        <TD>\n");
            writer.write("            ");
            writer.write(imageFile.getParent() + File.separator);
            writer.write("<font size=\"5\">");
            writer.write(imageFile.getFileName().toString());
            writer.write("</font>");
            writer.write(10);
            writer.write("        </TD>\n");
            writer.write("    </TR>\n");
        }
        writer.write("</TABLE>\n");
        writer.write("</P>");
        this.writeFooter(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUntestedImagesFile(File untestedOutputFile) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(untestedOutputFile));
            this.doGenerateUntestedImagesFile(writer);
        }
        catch (Exception e) {
            HelpMissingScreenShotReportGenerator.errorMessage("FAILED! writing untested images file", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doGenerateUntestedImagesFile(BufferedWriter writer) throws IOException {
        this.writeHeader(writer);
        writer.write("<P>\n");
        writer.write("<TABLE BORDER=\"1\">\n");
        writer.write("    <TH>\n");
        writer.write("        Help Topic\n");
        writer.write("    </TH>\n");
        writer.write("    <TH>\n");
        writer.write("        Image Name\n");
        writer.write("    </TH>\n");
        Set<Map.Entry<HelpTopic, Set<IMG>>> entrySet = this.untestedImages.entrySet();
        for (Map.Entry<HelpTopic, Set<IMG>> entry : entrySet) {
            boolean printTopic = true;
            Set<IMG> set = entry.getValue();
            for (IMG img : set) {
                writer.write("    <TR>\n");
                writer.write("        <TD>\n");
                writer.write("            ");
                if (printTopic) {
                    printTopic = false;
                    writer.write(entry.getKey().getName());
                } else {
                    writer.write("&nbsp;");
                }
                writer.write(10);
                writer.write("        </TD>\n");
                writer.write("        <TD>\n");
                writer.write("            ");
                Path imageFile = img.getImageFile();
                writer.write(imageFile.getParent() + File.separator);
                writer.write("<font size=\"5\">");
                writer.write(imageFile.getFileName().toString());
                writer.write("</font>");
                writer.write(10);
                writer.write("        </TD>\n");
                writer.write("    </TR>\n");
            }
        }
        writer.write("</TABLE>\n");
        writer.write("</P>\n");
        this.writeFooter(writer);
    }

    private Set<Path> getUnusedImages() {
        UnusedHelpImageFileFinder finder = new UnusedHelpImageFileFinder(this.helpDirectories, debugEnabled);
        return finder.getUnusedImages();
    }

    private void validateHelpImages() {
        this.debug("validating help images...");
        for (HelpModuleLocation helpDir : this.helpDirectories) {
            Collection<HelpTopic> topics = helpDir.getHelpTopics();
            for (HelpTopic topic : topics) {
                Collection<IMG> IMGs = topic.getAllIMGs();
                for (IMG img : IMGs) {
                    Path imageFile = img.getImageFile();
                    String imageName = imageFile.getFileName().toString();
                    HelpTestCase testCase = this.imageNameToTestCase.get(imageName);
                    if (testCase != null) continue;
                    this.filterUntestedImage(topic, img);
                }
            }
        }
        this.debug("Total untested images: " + this.untestedImages.size());
    }

    private void filterUntestedImage(HelpTopic topic, IMG img) {
        Path imageFile = img.getImageFile();
        if (this.examinedImageFiles.contains(imageFile)) {
            return;
        }
        this.examinedImageFiles.add(imageFile);
        try {
            URL url = imageFile.toUri().toURL();
            BufferedImage bufferedImage = ImageIO.read(url);
            int width = bufferedImage.getWidth();
            if (width <= 32) {
                return;
            }
            int height = bufferedImage.getHeight();
            if (height <= 32) {
                return;
            }
        }
        catch (MalformedURLException e) {
            HelpMissingScreenShotReportGenerator.errorMessage("Unable to read image: " + img, e);
        }
        catch (IndexOutOfBoundsException ioobe) {
            HelpMissingScreenShotReportGenerator.errorMessage("Problem reading image (bad data?): " + img, ioobe);
            return;
        }
        catch (IOException e) {
            HelpMissingScreenShotReportGenerator.errorMessage("Unable to load image: " + img, e);
        }
        Set<IMG> set = this.untestedImages.get(topic);
        if (set == null) {
            set = new TreeSet<IMG>();
            this.untestedImages.put(topic, set);
        }
        set.add(img);
    }

    private void validateScreenShotTests() {
        this.debug("validating screen shots...");
        for (HelpTestCase testCase : this.testCases) {
            String imageName = testCase.getImageName();
            HelpTopic helpTopic = testCase.getHelpTopic();
            Collection<IMG> imgs = helpTopic.getAllIMGs();
            boolean foundImage = false;
            for (IMG img : imgs) {
                String imgName;
                if (img.getImageFile().toAbsolutePath().toString().contains("shared")) continue;
                Path imageFile = img.getImageFile();
                if (imageFile == null) {
                    HelpMissingScreenShotReportGenerator.errorMessage("\n\nNo image file found for IMG tag: " + img + " in topic: " + helpTopic, null);
                }
                if (!testCase.matches(imgName = imageFile.getFileName().toString())) continue;
                foundImage = true;
                imageName = imgName;
                break;
            }
            if (!foundImage) {
                this.badlyNamedTestCases.add(testCase);
                continue;
            }
            this.imageNameToTestCase.put(imageName, testCase);
        }
    }

    private void parseScreenShots(String screenShotPaths) {
        this.debug("parsing help screenshots...");
        StringTokenizer tokenizer = new StringTokenizer(screenShotPaths, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            this.debug("\tparsing path entry: " + path);
            Path screenshotFile = Paths.get(path, new String[0]);
            String testName = screenshotFile.getFileName().toString();
            HelpTopic helpTopic = this.getHelpTopic(testName, screenshotFile);
            if (helpTopic == null) continue;
            HelpModuleLocation helpDir = helpTopic.getHelpDirectory();
            HelpTestFile testFile = new HelpTestFile(helpDir, helpTopic, screenshotFile, testName);
            Class<?> clazz = this.loadClass(screenshotFile);
            this.parseScreenShotTests(testFile, clazz);
        }
        this.debug("\tscreenshot test count: " + this.testCases.size());
    }

    private HelpTopic getHelpTopic(String testName, Path screenshotFile) {
        int index = testName.indexOf(SCREEN_SHOTS);
        String topicName = testName.substring(0, index);
        HelpTopic helpTopic = this.topicNameToTopic.get(topicName);
        if (helpTopic != null) {
            return helpTopic;
        }
        this.debug("Found file without a proper help topic name: " + topicName);
        int custom = testName.indexOf(CUSTOM_NAME);
        if (custom < 0) {
            this.badlyNamedTestFiles.add(testName);
            return null;
        }
        topicName = testName.substring(0, custom);
        helpTopic = this.topicNameToTopic.get(topicName);
        if (helpTopic != null) {
            this.debug("\tit IS a custom screenshot; it is valid");
            return helpTopic;
        }
        this.badlyNamedTestFiles.add(testName);
        return null;
    }

    private void parseScreenShotTests(HelpTestFile testFile, Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            String name;
            boolean isPublic;
            int modifiers = method.getModifiers();
            boolean bl = isPublic = (1 & modifiers) == 1;
            if (!isPublic || !(name = method.getName()).startsWith(TEST)) continue;
            this.debug("\tfound test method: " + name);
            HelpTestCase helpTestCase = new HelpTestCase(testFile, name);
            this.testCases.add(helpTestCase);
        }
    }

    private Class<?> loadClass(Path testFile) {
        Path parent = testFile.getParent();
        String pathString = parent.toAbsolutePath().toString();
        int javaIndex = pathString.lastIndexOf(JAVA_DIR);
        String absolutePath = testFile.toAbsolutePath().toString();
        String packageAndClassName = absolutePath.substring(javaIndex + JAVA_DIR.length() + 1);
        packageAndClassName = packageAndClassName.replaceAll("\\", ".");
        packageAndClassName = packageAndClassName.replaceAll("/", ".");
        String className = packageAndClassName.replace(".java", "");
        this.debug("Loading class: " + className);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            HelpMissingScreenShotReportGenerator.errorMessage("Couldn't load class: " + className, e);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private void parseHelpDirectories(String helpModulePaths) {
        this.debug("parsing help directories...");
        StringTokenizer tokenizer = new StringTokenizer(helpModulePaths, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String helpFilePath = tokenizer.nextToken();
            File directoryFile = new File(helpFilePath);
            if (!directoryFile.exists()) {
                this.debug("Help directory does not exist: " + directoryFile);
                continue;
            }
            DirectoryHelpModuleLocation helpDir = new DirectoryHelpModuleLocation(directoryFile);
            this.helpDirectories.add(helpDir);
            Collection<HelpTopic> topics = helpDir.getHelpTopics();
            for (HelpTopic topic : topics) {
                this.topicNameToTopic.put(topic.getName(), topic);
            }
        }
    }

    private void debug(String string) {
        if (debugEnabled) {
            System.err.println("[" + HelpMissingScreenShotReportGenerator.class.getSimpleName() + "] " + string);
        }
    }

    private static void errorMessage(String message, Throwable t) {
        System.err.println("[" + GHelpBuilder.class.getSimpleName() + "] " + message);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private void writeHeader(BufferedWriter writer) throws IOException {
        writer.write("<HTML>\n");
        writer.write("<HEAD>\n");
        this.createStyleSheet(writer);
        writer.write("</HEAD>\n");
        writer.write("<BODY>\n");
        writer.write("<H1>\n");
        writer.write("Ghidra Help Screen Shots Report");
        writer.write("</H1>\n");
    }

    private void writeFooter(BufferedWriter writer) throws IOException {
        writer.write("<BR>\n");
        writer.write("<BR>\n");
        writer.write("</BODY>\n");
        writer.write("</HTML>\n");
    }

    private void createStyleSheet(BufferedWriter writer) throws IOException {
        writer.write("<style>\n");
        writer.write("<!--\n");
        writer.write("body { font-family:arial; font-size:22pt }\n");
        writer.write("h1 { color:#000080; font-family:times new roman; font-size:28pt; font-weight:bold; text-align:center; }\n");
        writer.write("h2 { color:#984c4c; font-family:times new roman; font-size:28pt; font-weight:bold; }\n");
        writer.write("h2.title { color:#000080; font-family:times new roman; font-size:14pt; font-weight:bold; text-align:center;}\n");
        writer.write("h3 { color:#0000ff; font-family:times new roman; font-size:14pt; font-weight:bold; margin-left:.5in }\n");
        writer.write("table { margin-left:1in; margin-right:1in; min-width:20em; width:90%; background-color:#EEEEFF }\n");
        writer.write("th { text-align:center;  }\n");
        writer.write("td { text-align:left; padding: 20px }\n");
        writer.write("-->\n");
        writer.write("</style>\n");
    }

    private class HelpTestCase
    implements Comparable<HelpTestCase> {
        private HelpTestFile file;
        private String name;
        private String testMethodName;
        private String imageName;

        HelpTestCase(HelpTestFile file, String name) {
            this.file = file;
            this.name = name;
            if (!name.startsWith(HelpMissingScreenShotReportGenerator.TEST)) {
                throw new RuntimeException("Expecting test method name");
            }
            this.testMethodName = name;
            this.imageName = name.substring(HelpMissingScreenShotReportGenerator.TEST.length());
            if (this.imageName.startsWith(HelpMissingScreenShotReportGenerator.CAPTURE)) {
                this.imageName = this.imageName.substring(HelpMissingScreenShotReportGenerator.CAPTURE.length());
            }
            this.imageName = this.imageName + HelpMissingScreenShotReportGenerator.PNG_EXT;
        }

        boolean matches(String imgName) {
            if (this.imageName.equals(imgName)) {
                return true;
            }
            return this.imageName.toLowerCase().equals(imgName.toLowerCase());
        }

        String getImageName() {
            return this.imageName;
        }

        String getTestName() {
            return this.testMethodName;
        }

        HelpTopic getHelpTopic() {
            return this.file.getHelpTopic();
        }

        @Override
        public int compareTo(HelpTestCase o) {
            int result = this.file.filename.compareTo(o.file.filename);
            if (result != 0) {
                return result;
            }
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.file + " " + this.name + "()";
        }
    }

    private class HelpTestFile
    implements Comparable<HelpTestFile> {
        private String filename;
        private HelpModuleLocation helpDir;
        private Path filePath;
        private HelpTopic helpTopic;

        HelpTestFile(HelpModuleLocation helpDir, HelpTopic helpTopic, Path filePath, String filename) {
            this.helpDir = helpDir;
            this.helpTopic = helpTopic;
            this.filePath = filePath;
            this.filename = filename;
        }

        HelpTopic getHelpTopic() {
            return this.helpTopic;
        }

        @Override
        public int compareTo(HelpTestFile o) {
            int result = this.helpDir.getHelpLocation().compareTo(o.helpDir.getHelpLocation());
            if (result != 0) {
                return result;
            }
            return this.filename.compareTo(o.filename);
        }

        public String toString() {
            return this.helpDir.getHelpLocation().getFileName() + " -> " + this.filename;
        }
    }
}

