/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.FactoryLanguageTranslator;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.LanguageTranslatorAdapter;
import ghidra.program.util.LanguageTranslatorFactoryMinion;
import ghidra.program.util.OldLanguage;
import ghidra.program.util.SimpleLanguageTranslator;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class LanguageTranslatorFactory {
    public static final String LANGUAGE_TRANSLATOR_FILE_EXT = ".trans";
    private static LanguageTranslatorFactory languageTranslatorFactory;
    private Comparator<Object> TRANSLATOR_VERSION_COMPARATOR = (o1, o2) -> ((LanguageTranslator)o1).getOldVersion() - (Integer)o2;
    private HashMap<LanguageID, List<LanguageTranslator>> translatorMap = new HashMap();
    private HashMap<LanguageID, List<LanguageTranslator>> translatorVersionMap = new HashMap();
    private int badFileCount = 0;
    private static List<LanguageTranslatorFactoryMinion> minionList;

    public static synchronized void registerLanguageTranslatorFactoryMinion(LanguageTranslatorFactoryMinion minion) {
        if (minionList == null) {
            minionList = new ArrayList<LanguageTranslatorFactoryMinion>();
        }
        minionList.add(minion);
        if (languageTranslatorFactory != null) {
            languageTranslatorFactory.processMinion(minion);
        }
    }

    public static LanguageTranslatorFactory getLanguageTranslatorFactory() {
        if (languageTranslatorFactory == null) {
            languageTranslatorFactory = new LanguageTranslatorFactory();
        }
        return languageTranslatorFactory;
    }

    private LanguageTranslatorFactory() {
        this.initTranslatorMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTranslatorMaps() {
        ArrayList<LanguageTranslator> translators = new ArrayList<LanguageTranslator>();
        this.getSimpleTranslators(translators);
        this.getExplicitTranslators(translators);
        for (LanguageTranslator translator : translators) {
            this.addTranslator(translator);
        }
        Class<LanguageTranslatorFactory> clazz = LanguageTranslatorFactory.class;
        synchronized (LanguageTranslatorFactory.class) {
            if (minionList != null) {
                for (LanguageTranslatorFactoryMinion minion : minionList) {
                    this.processMinion(minion);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void addTranslator(LanguageTranslator translator) {
        if (translator.getOldLanguageID().equals(translator.getNewLanguageID())) {
            if (translator.getOldVersion() + 1 != translator.getNewVersion()) {
                Msg.error((Object)this, (Object)("Language version translator to_version same as from_version+1:\n  --> " + translator));
            }
            this.addToMap(this.translatorVersionMap, translator, true);
        } else {
            this.addToMap(this.translatorMap, translator, false);
        }
    }

    private void processMinion(LanguageTranslatorFactoryMinion minion) {
        for (LanguageTranslator translator : minion.getLanguageTranslators()) {
            this.addTranslator(translator);
        }
    }

    private void addToMap(HashMap<LanguageID, List<LanguageTranslator>> map, LanguageTranslator translator, boolean sorted) {
        LanguageID fromLanguageID = translator.getOldLanguageID();
        List<LanguageTranslator> list = map.get(fromLanguageID);
        if (list == null) {
            list = new ArrayList<LanguageTranslator>();
            map.put(fromLanguageID, list);
        }
        int index = list.size();
        if (sorted) {
            index = Collections.binarySearch(list, translator.getOldVersion(), this.TRANSLATOR_VERSION_COMPARATOR);
            if (index >= 0) {
                Msg.error((Object)this, (Object)("Language translator conflict:\n  --> " + translator + "\n  --> " + list.get(index)));
                return;
            }
            index = -index - 1;
        }
        list.add(index, translator);
    }

    private void getExplicitTranslators(List<LanguageTranslator> translators) {
        for (Class translatorClass : ClassSearcher.getClasses(LanguageTranslator.class)) {
            int modifiers = translatorClass.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers)) continue;
            try {
                translators.add((LanguageTranslator)translatorClass.newInstance());
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Failed to instatiate language translator: " + translatorClass.getName()), (Throwable)e);
                ++this.badFileCount;
            }
        }
    }

    private void getSimpleTranslators(List<LanguageTranslator> list) {
        List files = Application.findFilesByExtensionInApplication((String)LANGUAGE_TRANSLATOR_FILE_EXT);
        for (ResourceFile file : files) {
            try {
                list.add(SimpleLanguageTranslator.getSimpleLanguageTranslator(file));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Failed to parse: " + file), (Throwable)e);
                ++this.badFileCount;
            }
        }
    }

    int badFileCount() {
        return this.badFileCount;
    }

    int validateAllTranslators() {
        int errorCnt = 0;
        for (List<LanguageTranslator> list : this.translatorMap.values()) {
            for (LanguageTranslator translator : list) {
                if (translator.isValid()) continue;
                ++errorCnt;
            }
        }
        for (List<LanguageTranslator> list : this.translatorVersionMap.values()) {
            for (LanguageTranslator translator : list) {
                if (translator.isValid()) continue;
                ++errorCnt;
            }
        }
        return errorCnt;
    }

    List<LanguageTranslator> getAllTranslators() {
        ArrayList<LanguageTranslator> list = new ArrayList<LanguageTranslator>();
        for (List<LanguageTranslator> tlist : this.translatorMap.values()) {
            list.addAll(tlist);
        }
        for (List<LanguageTranslator> tlist : this.translatorVersionMap.values()) {
            list.addAll(tlist);
        }
        return list;
    }

    public LanguageTranslator getLanguageTranslator(Language fromLanguage, Language toLanguage) {
        if (toLanguage instanceof OldLanguage) {
            throw new IllegalArgumentException("toLanguage instanceof OldLanguage");
        }
        int fromVersion = fromLanguage.getVersion();
        int toVersion = toLanguage.getVersion();
        if (fromLanguage.getLanguageID().equals(toLanguage.getLanguageID())) {
            if (fromVersion >= toVersion) {
                throw new IllegalArgumentException("language from-version >= to-version");
            }
            return this.getLanguageVersionTranslator(fromLanguage.getLanguageID(), fromVersion, toVersion);
        }
        List<LanguageTranslator> languageTranslatorList = this.translatorMap.get(fromLanguage.getLanguageID());
        if (languageTranslatorList != null) {
            for (LanguageTranslator translator : languageTranslatorList) {
                if (translator.getOldVersion() < fromVersion || !toLanguage.getLanguageID().equals(translator.getNewLanguageID()) || (translator = this.expandTranslator(translator, fromVersion)) == null) continue;
                return translator;
            }
        }
        return LanguageTranslatorAdapter.getDefaultLanguageTranslator(fromLanguage, toLanguage);
    }

    public LanguageTranslator getLanguageTranslator(LanguageID languageName, int majorVersion) {
        List<LanguageTranslator> languageTranslatorList = this.translatorMap.get(languageName);
        if (languageTranslatorList == null) {
            return null;
        }
        for (LanguageTranslator translator : languageTranslatorList) {
            if (translator.getOldVersion() < majorVersion || (translator = this.expandTranslator(translator, majorVersion)) == null) continue;
            return translator;
        }
        return null;
    }

    private LanguageTranslator expandTranslator(LanguageTranslator translator, int fromVersion) {
        LanguageTranslator expandedFromTranslator;
        Language toLanguage;
        try {
            LanguageID languageId = translator.getNewLanguageID();
            toLanguage = DefaultLanguageService.getLanguageService().getLanguage(languageId);
        }
        catch (LanguageNotFoundException e) {
            Msg.error((Object)this, (Object)("Invalid translator - language not found: " + translator));
            return null;
        }
        int toVersion = toLanguage.getVersion();
        if (translator.getOldVersion() != fromVersion) {
            expandedFromTranslator = this.getLanguageVersionTranslator(translator.getOldLanguageID(), fromVersion, translator.getOldVersion());
            if (expandedFromTranslator == null) {
                return null;
            }
            translator = new FactoryLanguageTranslator(expandedFromTranslator, translator);
        }
        if (translator.getNewVersion() != toVersion) {
            expandedFromTranslator = this.getLanguageVersionTranslator(translator.getNewLanguageID(), translator.getNewVersion(), toVersion);
            if (expandedFromTranslator == null) {
                return null;
            }
            translator = new FactoryLanguageTranslator(translator, expandedFromTranslator);
        }
        if (translator != null && !translator.isValid()) {
            translator = null;
        }
        return translator;
    }

    private LanguageTranslator getLanguageVersionTranslator(LanguageID languageID, int fromVersion, int toVersion) {
        List<LanguageTranslator> list = this.translatorVersionMap.get(languageID);
        if (list == null) {
            return null;
        }
        LanguageTranslator translator = null;
        int version = fromVersion;
        while (version < toVersion) {
            LanguageTranslator nextTranslator = this.getNextTranslator(list, version);
            if ((nextTranslator == null || nextTranslator.getNewVersion() > toVersion) && (nextTranslator = LanguageTranslatorAdapter.getDefaultLanguageTranslator(languageID, version, toVersion)) == null) {
                return null;
            }
            if (version == nextTranslator.getNewVersion()) {
                Msg.error((Object)this, (Object)("Invalid language translator: " + nextTranslator));
                return null;
            }
            if (version != nextTranslator.getOldVersion()) {
                LanguageTranslator gapTranslator = LanguageTranslatorAdapter.getDefaultLanguageTranslator(languageID, version, nextTranslator.getOldVersion());
                if (gapTranslator == null) {
                    return null;
                }
                nextTranslator = new FactoryLanguageTranslator(gapTranslator, nextTranslator);
            }
            translator = translator != null ? new FactoryLanguageTranslator(translator, nextTranslator) : nextTranslator;
            version = nextTranslator.getNewVersion();
        }
        if (translator != null && !translator.isValid()) {
            translator = null;
        }
        return translator;
    }

    private LanguageTranslator getNextTranslator(List<LanguageTranslator> versionTranslatorList, int version) {
        int index = Collections.binarySearch(versionTranslatorList, version, this.TRANSLATOR_VERSION_COMPARATOR);
        if (index < 0) {
            index = -index - 1;
        }
        if (index < versionTranslatorList.size()) {
            return versionTranslatorList.get(index);
        }
        return null;
    }
}

