/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.BuiltInDataTypeClassExclusionFilter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.classfinder.ClassFilter;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class SymbolUtilities {
    public static final int MAX_SYMBOL_NAME_LENGTH = 2000;
    private static final String DEFAULT_SUBROUTINE_PREFIX = "SUB_";
    private static final String DEFAULT_SYMBOL_PREFIX = "LAB_";
    private static final String DEFAULT_DATA_PREFIX = "DAT_";
    private static final String DEFAULT_UNKNOWN_PREFIX = "UNK_";
    private static final String DEFAULT_EXTERNAL_ENTRY_PREFIX = "EXT_";
    private static final String DEFAULT_FUNCTION_PREFIX = "FUN_";
    private static final String DEFAULT_INTERNAL_REF_PREFIX = "OFF_";
    private static final String UNDERSCORE = "_";
    private static final String PLUS = "+";
    public static final int UNK_LEVEL = 0;
    public static final int DAT_LEVEL = 1;
    public static final int LAB_LEVEL = 2;
    public static final int SUB_LEVEL = 3;
    public static final int EXT_LEVEL = 5;
    public static final int FUN_LEVEL = 6;
    private static final String[] DYNAMIC_PREFIX_ARRAY = new String[]{"UNK_", "DAT_", "LAB_", "SUB_", "UNK_", "EXT_", "FUN_"};
    private static List<String> DYNAMIC_DATA_TYPE_PREFIXES = SymbolUtilities.getDynamicDataTypePrefixes();
    private static final int MIN_LABEL_ADDRESS_DIGITS = 4;
    public static final String ORDINAL_PREFIX = "Ordinal_";
    public static final char[] INVALIDCHARS = new char[]{' '};
    private static final Comparator<Symbol> CASE_INSENSITIVE_SYMBOL_NAME_COMPARATOR = (s1, s2) -> s1.getName().compareToIgnoreCase(s2.getName());

    private static List<String> getDynamicDataTypePrefixes() {
        ArrayList<String> list = new ArrayList<String>();
        BuiltInDataTypeClassExclusionFilter filter = new BuiltInDataTypeClassExclusionFilter();
        Set instances = ClassSearcher.getInstances(BuiltInDataType.class, (ClassFilter)filter);
        for (BuiltInDataType builtIn : instances) {
            String prefix = builtIn.getDefaultAbbreviatedLabelPrefix();
            if (prefix == null) continue;
            list.add(prefix + UNDERSCORE);
            list.add(prefix.toUpperCase() + UNDERSCORE);
        }
        return list;
    }

    public static int getOrdinalValue(String symbolName) {
        if (symbolName != null && symbolName.startsWith(ORDINAL_PREFIX)) {
            String ordinalStr = symbolName.substring(ORDINAL_PREFIX.length());
            try {
                return Integer.parseInt(ordinalStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean containsInvalidChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!SymbolUtilities.isInvalidChar(c)) continue;
            return true;
        }
        return false;
    }

    public static String getDefaultFunctionName(Address addr) {
        return DEFAULT_FUNCTION_PREFIX + SymbolUtilities.getAddressString(addr);
    }

    public static boolean isReservedExternalDefaultName(String name, AddressFactory addrFactory) {
        return name.startsWith(DEFAULT_EXTERNAL_ENTRY_PREFIX) && SymbolUtilities.parseDynamicName(addrFactory, name) != null;
    }

    public static String getDefaultExternalFunctionName(Address addr) {
        return "EXT_FUN_" + SymbolUtilities.getAddressString(addr);
    }

    public static String getDefaultExternalName(Address addr, DataType dt) {
        String prefix;
        if (dt != null && (prefix = dt.getDefaultLabelPrefix()) != null) {
            return DEFAULT_EXTERNAL_ENTRY_PREFIX + prefix + UNDERSCORE + SymbolUtilities.getAddressString(addr);
        }
        return DEFAULT_EXTERNAL_ENTRY_PREFIX + SymbolUtilities.getAddressString(addr);
    }

    public static boolean isReservedDynamicLabelName(String name, AddressFactory addrFactory) {
        String prefix = SymbolUtilities.findDynamicPrefix(name);
        if (prefix == null) {
            return false;
        }
        int len = prefix.length();
        if (name.length() < len + 1) {
            return false;
        }
        return SymbolUtilities.parseDynamicName(addrFactory, name) != null;
    }

    public static void validateName(String name, Address address, SymbolType symbolType, AddressFactory addrFactory) throws InvalidInputException {
        if (name == null) {
            throw new InvalidInputException("Symbol name can't be null");
        }
        if (name.length() == 0) {
            throw new InvalidInputException("Symbol name can't be empty string");
        }
        if (name.length() > 2000) {
            throw new InvalidInputException("Symbol name exceeds maximum length of 2000, length=" + name.length());
        }
        if (SymbolUtilities.containsInvalidChars(name)) {
            throw new InvalidInputException("Symbol name contains invalid characters: " + name);
        }
        if (address.isMemoryAddress() && SymbolUtilities.isReservedDynamicLabelName(name, addrFactory)) {
            if (symbolType == SymbolType.FUNCTION && SymbolUtilities.getDefaultFunctionName(address).equals(name)) {
                return;
            }
            throw new InvalidInputException("Symbol name matches possible default symbol name: " + name);
        }
    }

    public static boolean startsWithDefaultDynamicPrefix(String name) {
        for (String element : DYNAMIC_PREFIX_ARRAY) {
            if (!name.startsWith(element)) continue;
            return true;
        }
        for (String prefix : DYNAMIC_DATA_TYPE_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static String findDynamicPrefix(String name) {
        for (String element : DYNAMIC_PREFIX_ARRAY) {
            if (!name.startsWith(element)) continue;
            return element;
        }
        for (String prefix : DYNAMIC_DATA_TYPE_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    public static boolean isDynamicSymbolPattern(String name, boolean caseSensitive) {
        String string = name = caseSensitive ? name : name.toUpperCase();
        if (SymbolUtilities.startsWithDefaultDynamicPrefix(name)) {
            return true;
        }
        int lastIndex = name.lastIndexOf(95);
        if (lastIndex <= 0) {
            return false;
        }
        String suffix = name.substring(lastIndex + 1);
        if (suffix.length() < 3 || suffix.length() > 16) {
            return false;
        }
        return SymbolUtilities.isHexDigits(suffix);
    }

    private static boolean isHexDigits(String suffix) {
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (SymbolUtilities.isHexDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'a' && c <= 'f') {
            return true;
        }
        return c >= 'A' && c <= 'F';
    }

    public static boolean isInvalidChar(char c) {
        if (c < ' ') {
            return true;
        }
        for (char element : INVALIDCHARS) {
            if (c != element) continue;
            return true;
        }
        return false;
    }

    public static String replaceInvalidChars(String str, boolean replaceWithUnderscore) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (SymbolUtilities.isInvalidChar(c)) {
                if (!replaceWithUnderscore) continue;
                buf.append(UNDERSCORE);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String getDynamicOffcutName(Address addr) {
        if (addr != null) {
            return DEFAULT_INTERNAL_REF_PREFIX + SymbolUtilities.getAddressString(addr);
        }
        return null;
    }

    public static String getDynamicName(int referenceLevel, Address addr) {
        if (addr != null) {
            return DYNAMIC_PREFIX_ARRAY[referenceLevel] + SymbolUtilities.getAddressString(addr);
        }
        return null;
    }

    public static String getDynamicName(Program program, Address addr) {
        if (addr == null || !addr.isMemoryAddress()) {
            return null;
        }
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(addr);
        byte refLevel = program.getReferenceManager().getReferenceLevel(addr);
        if (codeUnit == null) {
            return SymbolUtilities.getDynamicName(refLevel, addr);
        }
        if (codeUnit instanceof Instruction) {
            return SymbolUtilities.getDynamicInstructionName(program, (Instruction)codeUnit, addr, refLevel);
        }
        return SymbolUtilities.getDynamicDataName((Data)codeUnit, addr, refLevel);
    }

    private static String getDynamicDataName(Data data, Address address, int refLevel) {
        int n;
        Address codeUnitAddress = data.getMinAddress();
        long diff = address.subtract(codeUnitAddress);
        boolean isString = data.hasStringValue();
        if (!isString && (n = data.getNumComponents()) > 0 && diff > 0L) {
            long datOffset;
            Data data2 = data.getPrimitiveAt((int)diff);
            if (data2 == null) {
                data2 = data;
            }
            return (datOffset = address.subtract(data2.getMinAddress())) == 0L ? data2.getPathName() : data2.getPathName() + PLUS + datOffset;
        }
        Address normalizedAddress = SymbolUtilities.normalizeSegmentedAddress(data, address);
        if (diff != 0L) {
            return SymbolUtilities.generateOffcutDataName(data, normalizedAddress, (int)diff, refLevel, isString);
        }
        String prefix = data.getDefaultLabelPrefix(DataTypeDisplayOptions.DEFAULT);
        if (prefix != null) {
            return prefix + UNDERSCORE + SymbolUtilities.getAddressString(normalizedAddress);
        }
        return SymbolUtilities.getDynamicName(refLevel, normalizedAddress);
    }

    private static String generateOffcutDataName(Data data, Address address, int offcutOffset, int refLevel, boolean isString) {
        DataType dataType = data.getDataType();
        String prefix = dataType.getDefaultOffcutLabelPrefix(data, data, data.getLength(), DataTypeDisplayOptions.DEFAULT, offcutOffset);
        if (isString) {
            return prefix + UNDERSCORE + SymbolUtilities.getAddressString(address);
        }
        String offcutText = PLUS + Integer.toString(offcutOffset);
        Symbol symbol = data.getPrimarySymbol();
        if (symbol != null && !symbol.isDynamic()) {
            return symbol.getName() + offcutText;
        }
        Address minAddress = address.subtract(offcutOffset);
        if (prefix != null) {
            return prefix + UNDERSCORE + SymbolUtilities.getAddressString(minAddress) + offcutText;
        }
        return SymbolUtilities.getDynamicName(refLevel, minAddress) + offcutText;
    }

    private static String getDynamicInstructionName(Program program, Instruction instruction, Address address, int refLevel) {
        Address codeUnitAddress = instruction.getMinAddress();
        long diff = address.subtract(codeUnitAddress);
        if (diff != 0L) {
            return SymbolUtilities.getDyanmicOffcutInstructionName(instruction, codeUnitAddress, diff);
        }
        Function function = program.getFunctionManager().getFunctionAt(codeUnitAddress);
        if (function != null) {
            return DEFAULT_FUNCTION_PREFIX + SymbolUtilities.getAddressString(codeUnitAddress);
        }
        if (refLevel == 3) {
            return DEFAULT_SUBROUTINE_PREFIX + SymbolUtilities.getAddressString(codeUnitAddress);
        }
        if (refLevel == 5) {
            return DEFAULT_EXTERNAL_ENTRY_PREFIX + SymbolUtilities.getAddressString(codeUnitAddress);
        }
        return DEFAULT_SYMBOL_PREFIX + SymbolUtilities.getAddressString(codeUnitAddress);
    }

    private static String getDyanmicOffcutInstructionName(Instruction instruction, Address codeUnitAddress, long diff) {
        String offcutText = PLUS + Long.toString(diff);
        Symbol symbol = instruction.getPrimarySymbol();
        if (symbol != null && !symbol.isDynamic()) {
            return symbol.getName() + offcutText;
        }
        return DEFAULT_SYMBOL_PREFIX + SymbolUtilities.getAddressString(codeUnitAddress) + offcutText;
    }

    private static Address normalizeSegmentedAddress(CodeUnit codeUnit, Address address) {
        if (!(address instanceof SegmentedAddress)) {
            return address;
        }
        SegmentedAddress segmentedAddress = (SegmentedAddress)address;
        SegmentedAddress codeUnitAddress = (SegmentedAddress)codeUnit.getAddress();
        return segmentedAddress.normalize(codeUnitAddress.getSegment());
    }

    public static Address parseDynamicName(AddressFactory factory, String name) {
        String[] pieces = name.split(UNDERSCORE);
        if (pieces.length < 2) {
            return null;
        }
        Object addressOffsetString = pieces[pieces.length - 1];
        AddressSpace space = SymbolUtilities.findAddressSpace(factory, pieces);
        if (space == null) {
            space = factory.getDefaultAddressSpace();
        }
        if (((String)addressOffsetString).length() < 4) {
            return null;
        }
        if (space instanceof SegmentedAddressSpace) {
            addressOffsetString = pieces[pieces.length - 2] + ":" + (String)addressOffsetString;
        }
        try {
            return space.getAddress((String)addressOffsetString);
        }
        catch (AddressFormatException addressFormatException) {
            return null;
        }
    }

    private static AddressSpace findAddressSpace(AddressFactory factory, String[] pieces) {
        int start = 1;
        int end = pieces.length - 2;
        if (pieces[end].length() == 0) {
            --end;
        }
        while (start <= end) {
            String addrSpaceName = SymbolUtilities.buildSpaceName(pieces, start, end);
            AddressSpace space = factory.getAddressSpace(addrSpaceName);
            if (space != null) {
                return space;
            }
            ++start;
        }
        return factory.getDefaultAddressSpace();
    }

    private static String buildSpaceName(String[] pieces, int start, int end) {
        StringBuffer buf = new StringBuffer();
        buf.append(pieces[start]);
        for (int i = start + 1; i <= end; ++i) {
            buf.append(UNDERSCORE);
            buf.append(pieces[i]);
        }
        return buf.toString();
    }

    public static String getAddressString(Address addr) {
        String addrString = addr.toString();
        addrString = addrString.replace(':', '_');
        return addrString;
    }

    public static String getDefaultParamName(int ordinal) {
        return "param_" + (ordinal + 1);
    }

    public static boolean isDefaultParameterName(String name) {
        if (name == null || name.length() == 0) {
            return true;
        }
        if (name.startsWith("param_")) {
            String tail = name.substring("param_".length());
            try {
                Integer.parseInt(tail);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getDefaultLocalName(Program program, int stackOffset, int firstUseOffset) {
        boolean stackGrowsNegative = program.getCompilerSpec().stackGrowsNegative();
        boolean reservedArea = stackGrowsNegative ? stackOffset >= 0 : stackOffset < 0;
        stackOffset = Math.abs(stackOffset);
        String name = (reservedArea ? "local_res" : "local_") + Integer.toHexString(stackOffset);
        if (firstUseOffset != 0) {
            name = name + UNDERSCORE + Integer.toString(firstUseOffset);
        }
        return name;
    }

    public static String getDefaultLocalName(Program program, VariableStorage storage, int firstUseOffset) {
        if (storage.isHashStorage()) {
            Object name = "temp_";
            long hash = storage.getFirstVarnode().getOffset();
            name = hash != 0L ? (String)name + Long.toHexString(hash) : (String)name + UNDERSCORE + Integer.toString(firstUseOffset);
            return name;
        }
        if (storage.isStackStorage()) {
            return SymbolUtilities.getDefaultLocalName(program, storage.getStackOffset(), firstUseOffset);
        }
        StringBuilder buffy = new StringBuilder("local_");
        boolean first = true;
        for (Varnode v : storage.getVarnodes()) {
            Address addr;
            if (!first) {
                buffy.append('_');
            }
            if ((addr = v.getAddress()).isStackAddress()) {
                int absStackOffset = Math.abs((int)addr.getOffset());
                buffy.append(Integer.toHexString(absStackOffset));
                continue;
            }
            Register reg = program.getRegister(v);
            if (reg != null) {
                buffy.append(reg.getName());
                continue;
            }
            buffy.append(SymbolUtilities.getVariableAddressString(addr));
        }
        if (firstUseOffset != 0) {
            buffy.append('_');
            buffy.append(Integer.toString(firstUseOffset));
        }
        return buffy.toString();
    }

    public static boolean isDefaultLocalName(Program program, String name, VariableStorage storage) {
        if (name == null || name.length() == 0) {
            return true;
        }
        if (storage == VariableStorage.BAD_STORAGE) {
            return false;
        }
        if (storage.isStackStorage()) {
            return SymbolUtilities.isDefaultLocalStackName(name);
        }
        String defaultName = SymbolUtilities.getDefaultLocalName(program, storage, 0);
        return name.startsWith(defaultName);
    }

    private static String getVariableAddressString(Address addr) {
        return addr.getAddressSpace().getName() + Long.toHexString(addr.getOffset());
    }

    public static boolean isDefaultLocalStackName(String name) {
        if (name == null || name.length() == 0) {
            return true;
        }
        if (name.startsWith("local_")) {
            String tail = name.substring("local_".length());
            tail = SymbolUtilities.removeFirstUseOffset(tail);
            try {
                Integer.parseInt(tail, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.startsWith("local_res")) {
            String tail = name.substring("local_res".length());
            tail = SymbolUtilities.removeFirstUseOffset(tail);
            try {
                Integer.parseInt(tail, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String removeFirstUseOffset(String str) {
        int index = str.lastIndexOf(95);
        if (index < 0) {
            return str;
        }
        try {
            Integer.parseInt(str.substring(index + 1));
            return str.substring(0, index);
        }
        catch (NumberFormatException numberFormatException) {
            return str;
        }
    }

    public static String getAddressAppendedName(String name, Address address) {
        return SymbolUtilities.getAddressAppendedName(name, address, "@");
    }

    private static String getAddressAppendedName(String name, Address address, String suffixSeparator) {
        return name + suffixSeparator + SymbolUtilities.getAddressString(address);
    }

    public static String getCleanSymbolName(Symbol symbol) {
        return SymbolUtilities.getCleanSymbolName(symbol.getName(), symbol.getAddress());
    }

    public static String getCleanSymbolName(String symbolName, Address address) {
        int indexOfAt = symbolName.lastIndexOf("@");
        int indexOfUnderscore = symbolName.lastIndexOf(UNDERSCORE);
        if (indexOfAt < 1 && indexOfUnderscore < 1) {
            return symbolName;
        }
        if (indexOfAt > indexOfUnderscore) {
            String potentialBaseName = symbolName.substring(0, indexOfAt);
            if (symbolName.equals(SymbolUtilities.getAddressAppendedName(potentialBaseName, address, "@"))) {
                return potentialBaseName;
            }
            return symbolName;
        }
        String potentialBaseName = symbolName.substring(0, indexOfUnderscore);
        if (symbolName.equals(SymbolUtilities.getAddressAppendedName(potentialBaseName, address, UNDERSCORE))) {
            return potentialBaseName;
        }
        return symbolName;
    }

    public static String getSymbolTypeDisplayName(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        SymbolType symType = symbol.getSymbolType();
        if (symType == SymbolType.CODE) {
            Program program;
            Symbol primary;
            if (symbol.isExternal()) {
                return "External Data";
            }
            if (!symbol.isPrimary() && (primary = (program = symbol.getProgram()).getSymbolTable().getPrimarySymbol(symbol.getAddress())) != null && primary.getSymbolType() == SymbolType.FUNCTION) {
                return "Function";
            }
            Object obj = symbol.getObject();
            if (obj instanceof Instruction) {
                return "Instruction Label";
            }
            if (obj != null) {
                return "Data Label";
            }
        } else if (symType == SymbolType.FUNCTION) {
            if (symbol.isExternal()) {
                return "External Function";
            }
            Function func = (Function)symbol.getObject();
            if (func.isThunk()) {
                return "Thunk Function";
            }
            return "Function";
        }
        if (symbol.isExternal()) {
            return "External " + symType;
        }
        return symType.toString();
    }

    public static Symbol getExpectedLabelOrFunctionSymbol(Program program, String symbolName, Consumer<String> errorConsumer) {
        List<Symbol> symbols = program.getSymbolTable().getLabelOrFunctionSymbols(symbolName, null);
        if (symbols.size() == 1) {
            return symbols.get(0);
        }
        if (symbols.isEmpty()) {
            errorConsumer.accept(symbolName + " symbol not found!");
        } else {
            errorConsumer.accept("Multiple " + symbolName + " symbols found!");
        }
        return null;
    }

    public static Symbol getLabelOrFunctionSymbol(Program program, String symbolName, Consumer<String> errorConsumer) {
        List<Symbol> symbols = program.getSymbolTable().getLabelOrFunctionSymbols(symbolName, null);
        if (symbols.size() == 1) {
            return symbols.get(0);
        }
        if (symbols.size() > 1) {
            errorConsumer.accept("Multiple " + symbolName + " symbols found!");
        }
        return null;
    }

    public static Symbol createPreferredLabelOrFunctionSymbol(Program program, Address address, Namespace namespace, String name, SourceType source) throws InvalidInputException {
        try {
            SymbolTable symbolTable;
            Symbol symbol;
            if (!address.isMemoryAddress()) {
                throw new IllegalArgumentException("expected memory address");
            }
            if (namespace == null) {
                namespace = program.getGlobalNamespace();
            }
            if ((symbol = (symbolTable = program.getSymbolTable()).getSymbol(name, address, namespace)) != null) {
                return symbol;
            }
            if (namespace.isGlobal()) {
                for (Symbol s : program.getSymbolTable().getSymbols(address)) {
                    if (!name.equals(s.getName())) continue;
                    return null;
                }
            } else {
                symbol = symbolTable.getGlobalSymbol(name, address);
                if (symbol != null) {
                    symbol.setNamespace(namespace);
                    return symbol;
                }
            }
            return symbolTable.createLabel(address, name, namespace, source);
        }
        catch (CircularDependencyException | DuplicateNameException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public static Comparator<Symbol> getSymbolNameComparator() {
        return CASE_INSENSITIVE_SYMBOL_NAME_COMPARATOR;
    }
}

