/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class RegisterTranslator {
    private static Comparator<Register> registerSizeComparator = new Comparator<Register>(){

        @Override
        public int compare(Register r1, Register r2) {
            return r2.getBitLength() - r1.getBitLength();
        }
    };
    private Register[] oldRegs;
    private Register[] newRegs;
    private HashMap<Integer, List<Register>> oldRegisterMap;
    private HashMap<Integer, List<Register>> newRegisterMap;
    private HashMap<String, Register> oldRegisterNameMap;
    private HashMap<String, Register> newRegisterNameMap;

    public RegisterTranslator(Language oldLang, Language newLang) {
        this.oldRegs = oldLang.getRegisters();
        this.newRegs = newLang.getRegisters();
        this.oldRegisterMap = this.buildOffsetMap(this.oldRegs);
        this.newRegisterMap = this.buildOffsetMap(this.newRegs);
        this.oldRegisterNameMap = this.buildNameMap(this.oldRegs);
        this.newRegisterNameMap = this.buildNameMap(this.newRegs);
    }

    private HashMap<Integer, List<Register>> buildOffsetMap(Register[] registers) {
        HashMap<Integer, List<Register>> offsetMap = new HashMap<Integer, List<Register>>();
        for (Register register : registers) {
            Address addr = register.getAddress();
            if (!addr.isRegisterAddress() || !register.getAddressSpace().getName().equalsIgnoreCase("register")) continue;
            Integer offset = (int)addr.getOffset();
            List<Register> registerList = offsetMap.get(offset);
            if (registerList == null) {
                registerList = new ArrayList<Register>();
                offsetMap.put(offset, registerList);
            }
            registerList.add(register);
        }
        for (List registerList : offsetMap.values()) {
            Collections.sort(registerList, registerSizeComparator);
        }
        return offsetMap;
    }

    private HashMap<String, Register> buildNameMap(Register[] regs) {
        HashMap<String, Register> map = new HashMap<String, Register>();
        for (Register r : regs) {
            map.put(r.getName().toUpperCase(), r);
        }
        return map;
    }

    public Register getOldRegister(int offset, int size) {
        List<Register> list = this.oldRegisterMap.get(offset);
        if (list != null) {
            if (size == 0) {
                return list.get(0);
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Register reg = list.get(i);
                if (reg.getMinimumByteSize() < size) continue;
                return reg;
            }
        }
        return null;
    }

    public Register getNewRegister(int offset, int size) {
        List<Register> list = this.newRegisterMap.get(offset);
        if (list != null) {
            if (size == 0) {
                return list.get(0);
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                Register reg = list.get(i);
                if (reg.getMinimumByteSize() < size) continue;
                return reg;
            }
        }
        return null;
    }

    public Register getNewRegister(Register oldReg) {
        return this.newRegisterNameMap.get(oldReg.getName().toUpperCase());
    }

    public Register getOldRegister(Register newReg) {
        return this.oldRegisterNameMap.get(newReg.getName().toUpperCase());
    }

    public Register[] getNewRegisters() {
        return this.newRegs;
    }
}

