/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;

public class SignedDWordDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final SignedDWordDataType dataType = new SignedDWordDataType();

    public SignedDWordDataType() {
        this(null);
    }

    public SignedDWordDataType(DataTypeManager dtm) {
        super("sdword", true, dtm);
    }

    @Override
    public String getDescription() {
        return "Signed Double-Word (sddw, 4-bytes)";
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "sddw";
    }

    @Override
    public DataType getOppositeSignednessDataType() {
        return DWordDataType.dataType;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new SignedDWordDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this, true, dataOrganization, false);
    }
}

