/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class PaddingSettingsDefinition
implements EnumSettingsDefinition {
    private static final int PADDED_VALUE = 1;
    private static final int UNPADDED_VALUE = 0;
    private static final String[] choices = new String[]{"unpadded", "padded"};
    private static final String PADDED = "padded";
    public static final PaddingSettingsDefinition DEF = new PaddingSettingsDefinition();

    private PaddingSettingsDefinition() {
    }

    public boolean isPadded(Settings settings) {
        if (settings == null) {
            return false;
        }
        Long value = settings.getLong(PADDED);
        if (value == null) {
            return false;
        }
        return value != 0L;
    }

    public void setPadded(Settings settings, boolean isPadded) {
        this.setChoice(settings, isPadded ? 1 : 0);
    }

    public int getChoice(Settings settings) {
        if (this.isPadded(settings)) {
            return 1;
        }
        return 0;
    }

    public void setChoice(Settings settings, int value) {
        settings.setLong(PADDED, (long)value);
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return "Padding";
    }

    public String getDescription() {
        return "Selects if the data is padded or not";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(PADDED);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(PADDED);
        if (l == null) {
            destSettings.clearSetting(PADDED);
        } else {
            destSettings.setLong(PADDED, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(PADDED) != null;
    }
}

