/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.NotYetImplementedException;

public abstract class CompositeDataTypeImpl
extends GenericDataType
implements Composite {
    private static final long serialVersionUID = 1L;
    private String description = "";
    protected boolean aligned = false;
    protected Composite.AlignmentType currentAlignment = Composite.AlignmentType.DEFAULT_ALIGNED;
    protected int packingValue = 0;
    protected int externalAlignment = 0;

    CompositeDataTypeImpl(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path != null ? path : CategoryPath.ROOT, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
    }

    CompositeDataTypeImpl(CategoryPath path, String name, DataTypeManager dtm) {
        super(path != null ? path : CategoryPath.ROOT, name, dtm);
    }

    @Override
    public boolean isDynamicallySized() {
        return this.isInternallyAligned();
    }

    @Override
    public boolean isPartOf(DataType dataTypeOfInterest) {
        return DataTypeUtilities.isSecondPartOfFirst(this, dataTypeOfInterest);
    }

    protected void checkAncestry(DataType dataType) {
        if (this.equals(dataType)) {
            throw new IllegalArgumentException("Data type " + this.getDisplayName() + " can't contain itself.");
        }
        if (DataTypeUtilities.isSecondPartOfFirst(dataType, this)) {
            throw new IllegalArgumentException("Data type " + dataType.getDisplayName() + " has " + this.getDisplayName() + " within it.");
        }
    }

    protected void validateDataType(DataType dataType) {
        Dynamic dynamicDataType;
        if (dataType instanceof FactoryDataType) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
        if (dataType instanceof Dynamic && !(dynamicDataType = (Dynamic)dataType).canSpecifyLength()) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
    }

    @Override
    public DataTypeComponent add(DataType dataType) {
        dataType = dataType.clone(this.getDataTypeManager());
        return this.add(dataType, dataType.getLength(), null, null);
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc == null ? "" : desc;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public void setValue(MemBuffer buf, Settings settings, int length, Object value) {
        throw new NotYetImplementedException("setValue() not implemented");
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length) {
        return this.add(dataType, length, null, null);
    }

    @Override
    public DataTypeComponent add(DataType dataType, String fieldName, String comment) {
        return this.add(dataType, dataType.getLength(), fieldName, comment);
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length) {
        return this.insert(ordinal, dataType, length, null, null);
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType) {
        return this.insert(ordinal, dataType, dataType.getLength(), null, null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        this.checkValidName(name);
        this.name = name;
    }

    @Override
    public int getPackingValue() {
        return this.packingValue;
    }

    @Override
    public void setPackingValue(int packingValue) {
        this.aligned = true;
        this.packingValue = packingValue;
        this.adjustInternalAlignment();
    }

    @Override
    public int getMinimumAlignment() {
        return this.externalAlignment;
    }

    @Override
    public void setMinimumAlignment(int externalAlignment) {
        this.aligned = true;
        if (this.currentAlignment != Composite.AlignmentType.ALIGNED_BY_VALUE) {
            this.currentAlignment = Composite.AlignmentType.ALIGNED_BY_VALUE;
        }
        this.externalAlignment = externalAlignment;
        this.adjustInternalAlignment();
    }

    @Override
    public boolean isInternallyAligned() {
        return this.aligned;
    }

    @Override
    public boolean isDefaultAligned() {
        return this.currentAlignment == Composite.AlignmentType.DEFAULT_ALIGNED;
    }

    @Override
    public boolean isMachineAligned() {
        return this.currentAlignment == Composite.AlignmentType.MACHINE_ALIGNED;
    }

    @Override
    public void setInternallyAligned(boolean aligned) {
        if (this.aligned != aligned) {
            this.aligned = aligned;
            if (!aligned) {
                this.currentAlignment = Composite.AlignmentType.DEFAULT_ALIGNED;
                this.packingValue = 0;
            }
        }
        this.adjustInternalAlignment();
    }

    @Override
    public void setToDefaultAlignment() {
        this.aligned = true;
        this.currentAlignment = Composite.AlignmentType.DEFAULT_ALIGNED;
        this.adjustInternalAlignment();
    }

    @Override
    public void setToMachineAlignment() {
        this.aligned = true;
        this.currentAlignment = Composite.AlignmentType.MACHINE_ALIGNED;
        this.adjustInternalAlignment();
    }

    protected void notifyAlignmentChanged() {
        DataType[] parents;
        for (DataType dataType : parents = this.getParents()) {
            if (!(dataType instanceof Composite)) continue;
            Composite composite = (Composite)dataType;
            composite.dataTypeAlignmentChanged(this);
        }
    }

    protected abstract void adjustInternalAlignment();

    @Override
    public int getAlignment() {
        return this.getDataOrganization().getAlignment(this, this.getLength());
    }

    protected void setDataAlignmentInfo(Composite composite) {
        this.aligned = composite.isInternallyAligned();
        if (composite.isDefaultAligned()) {
            this.currentAlignment = Composite.AlignmentType.DEFAULT_ALIGNED;
        } else if (composite.isMachineAligned()) {
            this.currentAlignment = Composite.AlignmentType.MACHINE_ALIGNED;
        } else {
            if (this.currentAlignment != Composite.AlignmentType.ALIGNED_BY_VALUE) {
                this.currentAlignment = Composite.AlignmentType.ALIGNED_BY_VALUE;
            }
            this.externalAlignment = composite.getMinimumAlignment();
        }
        this.packingValue = composite.getPackingValue();
        this.adjustInternalAlignment();
    }

    protected void dumpComponents(StringBuilder buffer, String pad) {
        for (DataTypeComponent dtc : this.getComponents()) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dataType.getDisplayName());
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(this.getPathName() + "\n");
        stringBuffer.append(this.getAlignmentSettingsString() + "\n");
        stringBuffer.append(this.getTypeName() + " " + this.getDisplayName() + " {\n");
        this.dumpComponents(stringBuffer, "   ");
        stringBuffer.append("}\n");
        stringBuffer.append("Size = " + this.getLength() + "   Actual Alignment = " + this.getAlignment() + "\n");
        return stringBuffer.toString();
    }

    private String getTypeName() {
        if (this instanceof Structure) {
            return "Structure";
        }
        if (this instanceof Union) {
            return "Union";
        }
        return "";
    }

    private String getAlignmentSettingsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isInternallyAligned()) {
            stringBuffer.append("Unaligned");
        } else if (this.isDefaultAligned()) {
            stringBuffer.append("Aligned");
        } else if (this.isMachineAligned()) {
            stringBuffer.append("Machine aligned");
        } else {
            long alignment = this.getMinimumAlignment();
            stringBuffer.append("align(" + alignment + ")");
        }
        stringBuffer.append(this.getPackingString());
        return stringBuffer.toString();
    }

    private String getPackingString() {
        if (!this.isInternallyAligned()) {
            return "";
        }
        if (this.packingValue == 0) {
            return "";
        }
        return " pack(" + this.packingValue + ")";
    }
}

