/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.mem.MemBuffer;

public class BadDataType
extends BuiltIn
implements Dynamic {
    private static final long serialVersionUID = 1L;
    public static final BadDataType dataType = new BadDataType();

    public BadDataType() {
        this(null);
    }

    public BadDataType(DataTypeManager dtm) {
        super(null, "-BAD-", dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getName();
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public String getDescription() {
        return "** Bad Data Type **";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getDescription();
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        return dt instanceof BadDataType;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getDescription();
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new BadDataType(dtm);
    }

    @Override
    public boolean canSpecifyLength() {
        return true;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        return -1;
    }

    @Override
    public DataType getReplacementBaseType() {
        return null;
    }
}

