/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;

public interface ArrayStringable
extends DataType {
    public boolean hasStringValue(Settings var1);

    default public StringDataInstance getStringDataInstance(MemBuffer buf, Settings settings, int length) {
        return this.hasStringValue(settings) ? new StringDataInstance(this, settings, buf, length) : StringDataInstance.NULL_INSTANCE;
    }

    default public String getArrayString(MemBuffer buf, Settings settings, int length) {
        return this.getStringDataInstance(buf, settings, length).getStringValue();
    }

    default public String getArrayRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getStringDataInstance(buf, settings, length).getStringRepresentation();
    }

    public String getArrayDefaultLabelPrefix(MemBuffer var1, Settings var2, int var3, DataTypeDisplayOptions var4);

    public String getArrayDefaultOffcutLabelPrefix(MemBuffer var1, Settings var2, int var3, DataTypeDisplayOptions var4, int var5);

    public static ArrayStringable getArrayStringable(DataType dt) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        return dt instanceof ArrayStringable ? (ArrayStringable)dt : null;
    }

    public static String getArrayStringableLabelPrefix(Array arrayDt, MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        ArrayStringable as = ArrayStringable.getArrayStringable(arrayDt.getDataType());
        return as != null ? as.getArrayDefaultLabelPrefix(buf, settings, len, options) : null;
    }

    public static String getArrayStringableOffcutLabelPrefix(Array arrayDt, MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        ArrayStringable as = ArrayStringable.getArrayStringable(arrayDt.getDataType());
        return as != null ? as.getArrayDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength) : null;
    }
}

