/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.util.ErrorHandler;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.module.ModuleManager;
import ghidra.program.database.module.TreeDBAdapter;
import ghidra.program.database.module.TreeDBAdapterV0;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TreeManager
implements ManagerDB {
    public static final String DEFAULT_TREE_NAME = "Program Tree";
    private AddressMap addrMap;
    private Map<String, ModuleManager> treeMap;
    private TreeDBAdapter adapter;
    private ProgramDB program;
    private DBHandle handle;
    private ErrorHandler errHandler;
    private int openMode;
    private Lock lock;
    static final String TREE_TABLE_NAME = "Trees";
    static final int TREE_NAME_COL = 0;
    static final int MODIFICATION_NUM_COL = 1;
    static final String MODULE_TABLE_NAME = "Module Table";
    static final int MODULE_NAME_COL = 0;
    static final int MODULE_COMMENTS_COL = 1;
    static final String FRAGMENT_TABLE_NAME = "Fragment Table";
    static final int FRAGMENT_NAME_COL = 0;
    static final int FRAGMENT_COMMENTS_COL = 1;
    static final String PARENT_CHILD_TABLE_NAME = "Parent/Child Relationships";
    static final int PARENT_ID_COL = 0;
    static final int CHILD_ID_COL = 1;
    static final int ORDER_COL = 2;
    static final String FRAGMENT_ADDRESS_TABLE_NAME = "Fragment Addresses";
    static final Schema TREE_SCHEMA = TreeManager.createTreeSchema();
    static final Schema MODULE_SCHEMA = TreeManager.createModuleSchema();
    static final Schema FRAGMENT_SCHEMA = TreeManager.createFragmentSchema();
    static final Schema PARENT_CHILD_SCHEMA = TreeManager.createParentChildSchema();

    private static Schema createTreeSchema() {
        return new Schema(0, "Key", new Class[]{StringField.class, LongField.class}, new String[]{"Name", "Modification Number"});
    }

    private static Schema createModuleSchema() {
        return new Schema(0, "Key", new Class[]{StringField.class, StringField.class}, new String[]{"Name", "Comments"});
    }

    private static Schema createFragmentSchema() {
        return new Schema(0, "Key", new Class[]{StringField.class, StringField.class}, new String[]{"Name", "Comments"});
    }

    private static Schema createParentChildSchema() {
        return new Schema(0, "Key", new Class[]{LongField.class, LongField.class, IntField.class}, new String[]{"Parent ID", "Child ID", "Child Index"});
    }

    public TreeManager(DBHandle handle, ErrorHandler errHandler, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.handle = handle;
        this.errHandler = errHandler;
        this.addrMap = addrMap;
        this.openMode = openMode;
        this.lock = lock;
        if (openMode == 0) {
            this.createDBTables(handle);
        }
        this.findAdapters(handle);
        this.treeMap = new HashMap<String, ModuleManager>();
        if (addrMap.isUpgraded()) {
            if (openMode == 1) {
                throw new VersionException(true);
            }
            if (openMode == 3) {
                this.addressUpgrade(monitor);
            }
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        try {
            this.populateTreeMap(false);
            if (this.openMode == 0) {
                this.createDefaultTree();
                this.openMode = -1;
            }
        }
        catch (IOException e) {
            program.dbError(e);
        }
    }

    @Override
    public void programReady(int openMode1, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    private void addressUpgrade(TaskMonitor monitor) throws CancelledException, IOException {
        RecordIterator iter = this.adapter.getRecords();
        while (iter.hasNext()) {
            Record rec = iter.next();
            long key = rec.getKey();
            String treeName = rec.getString(0);
            ModuleManager.addressUpgrade(this, key, treeName, this.addrMap, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageBaseChanged(boolean commit) {
        this.lock.acquire();
        try {
            for (ModuleManager m : this.treeMap.values()) {
                m.imageBaseChanged(commit);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule createRootModule(String treeName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.treeMap.containsKey(treeName)) {
                throw new DuplicateNameException("Root module named " + treeName + " already exists");
            }
            Record record = this.adapter.createRecord(treeName);
            ModuleManager m = new ModuleManager(this, record, this.program, true);
            this.treeMap.put(treeName, m);
            this.addMemoryBlocks(m);
            if (this.openMode != 0) {
                this.program.programTreeAdded(record.getKey(), 141, null, treeName);
            }
            ProgramModule programModule = m.getRootModule();
            return programModule;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule getRootModule(String treeName) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramModule programModule = m.getRootModule();
                return programModule;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public ProgramModule getDefaultRootModule() {
        try {
            RecordIterator iter = this.adapter.getRecords();
            if (iter.hasNext()) {
                Record record = iter.next();
                String name = record.getString(0);
                return this.getRootModule(name);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    public String[] getTreeNames() {
        String[] names = new String[this.treeMap.size()];
        try {
            RecordIterator iter = this.adapter.getRecords();
            int index = 0;
            while (iter.hasNext()) {
                Record record = iter.next();
                names[index] = record.getString(0);
                ++index;
            }
            return names;
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTree(String oldName, String newName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            if (this.treeMap.containsKey(newName)) {
                throw new DuplicateNameException("Name " + newName + " already exists");
            }
            ModuleManager moduleMgr = this.treeMap.get(oldName);
            if (moduleMgr == null) {
                throw new IllegalArgumentException("Tree named " + oldName + " was not found");
            }
            moduleMgr.setName(newName);
            this.treeMap.remove(oldName);
            this.treeMap.put(newName, moduleMgr);
            this.program.programTreeChanged(moduleMgr.getTreeID(), 143, null, oldName, newName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTree(String treeName) {
        this.lock.acquire();
        try {
            if (this.treeMap.containsKey(treeName)) {
                Record rec = this.adapter.getRecord(treeName);
                this.adapter.deleteRecord(rec.getKey());
                ModuleManager mm = this.treeMap.remove(treeName);
                mm.dispose();
                this.program.programTreeChanged(rec.getKey(), 142, null, treeName, null);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule getModule(String treeName, String name) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramModule programModule = m.getModule(name);
                return programModule;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramFragment getFragment(String treeName, String name) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramFragment programFragment = m.getFragment(name);
                return programFragment;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramFragment getFragment(String treeName, Address addr) {
        this.lock.acquire();
        try {
            ModuleManager m = this.treeMap.get(treeName);
            if (m != null) {
                ProgramFragment programFragment = m.getFragment(addr);
                return programFragment;
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemoryBlock(String name, AddressRange range) {
        this.lock.acquire();
        try {
            Iterator<String> keys = this.treeMap.keySet().iterator();
            while (keys.hasNext()) {
                ModuleManager m = this.treeMap.get(keys.next());
                m.addMemoryBlock(name, range);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            Iterator<String> keys = this.treeMap.keySet().iterator();
            while (keys.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                ModuleManager m = this.treeMap.get(keys.next());
                m.removeMemoryBlock(startAddr, endAddr, monitor);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, CancelledException {
        this.lock.acquire();
        try {
            Iterator<String> keys = this.treeMap.keySet().iterator();
            monitor.setMessage("Moving folders/fragments...");
            while (keys.hasNext()) {
                monitor.checkCanceled();
                ModuleManager m = this.treeMap.get(keys.next());
                m.moveAddressRange(fromAddr, toAddr, length, monitor);
                m.invalidateCache();
            }
            this.treeMap.clear();
            this.populateTreeMap(false);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    DBHandle getDatabaseHandle() {
        return this.handle;
    }

    String getTreeName(long treeID) {
        try {
            Record record = this.adapter.getRecord(treeID);
            if (record != null) {
                return record.getString(0);
            }
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        return null;
    }

    ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    static String getModuleTableName(long treeID) {
        return MODULE_TABLE_NAME + treeID;
    }

    static String getFragmentTableName(long treeID) {
        return FRAGMENT_TABLE_NAME + treeID;
    }

    static String getParentChildTableName(long treeID) {
        return PARENT_CHILD_TABLE_NAME + treeID;
    }

    static String getFragAddressTableName(long treeID) {
        return FRAGMENT_ADDRESS_TABLE_NAME + treeID;
    }

    private void addMemoryBlocks(ModuleManager mgr) {
        MemoryBlock[] blocks;
        Memory memory = this.program.getMemory();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            AddressRangeImpl range = new AddressRangeImpl(block.getStart(), block.getEnd());
            try {
                mgr.addMemoryBlock(block.getName(), range);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
                break;
            }
        }
    }

    private void populateTreeMap(boolean ignoreModificationNumber) throws IOException {
        Map<String, ModuleManager> oldTreeMap = this.treeMap;
        this.treeMap = new HashMap<String, ModuleManager>();
        RecordIterator iter = this.adapter.getRecords();
        while (iter.hasNext()) {
            Record rec = iter.next();
            long key = rec.getKey();
            String treeName = rec.getString(0);
            long modNumber = rec.getLongValue(1);
            ModuleManager mm = oldTreeMap.get(treeName);
            if (mm != null) {
                oldTreeMap.remove(treeName);
                if (mm.getTreeID() == key) {
                    if (ignoreModificationNumber || mm.getModificationNumber() != modNumber) {
                        mm.invalidateCache();
                    }
                } else {
                    mm.invalidateCache();
                    mm = null;
                }
            }
            if (mm == null) {
                mm = new ModuleManager(this, rec, this.program, false);
            }
            this.treeMap.put(treeName, mm);
        }
        Iterator<String> it = oldTreeMap.keySet().iterator();
        while (it.hasNext()) {
            ModuleManager mm = oldTreeMap.get(it.next());
            mm.invalidateCache();
        }
    }

    private void findAdapters(DBHandle dbHandle) throws VersionException {
        this.adapter = new TreeDBAdapterV0(dbHandle);
    }

    private void createDBTables(DBHandle dbHandle) throws IOException {
        dbHandle.createTable(TREE_TABLE_NAME, TREE_SCHEMA, new int[]{0});
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.lock.acquire();
        try {
            this.populateTreeMap(all);
        }
        finally {
            this.lock.release();
        }
    }

    public void setProgramName(String oldName, String newName) {
        Iterator<String> it = this.treeMap.keySet().iterator();
        while (it.hasNext()) {
            ModuleManager mm = this.treeMap.get(it.next());
            mm.setProgramName(oldName, newName);
        }
    }

    void updateTreeRecord(Record record) {
        this.updateTreeRecord(record, true);
    }

    void updateTreeRecord(Record record, boolean updateModificationNumber) {
        try {
            if (updateModificationNumber) {
                record.setLongValue(1, record.getLongValue(1) + 1L);
            }
            this.adapter.updateRecord(record);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
    }

    Record getTreeRecord(long treeID) {
        try {
            return this.adapter.getRecord(treeID);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    private void createDefaultTree() {
        try {
            this.createRootModule(DEFAULT_TREE_NAME);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }

    public ProgramModule getRootModule(long treeID) {
        String treeName = this.getTreeName(treeID);
        return this.getRootModule(treeName);
    }

    Lock getLock() {
        return this.lock;
    }
}

