/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.external;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class ExternalLocationDB
implements ExternalLocation {
    private static final char ORIGINAL_IMPORTED_DELIMITER = ',';
    private ExternalManagerDB extMgr;
    private SymbolDB symbol;

    ExternalLocationDB(ExternalManagerDB extMgr, SymbolDB symbol) {
        this.extMgr = extMgr;
        this.symbol = symbol;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public String getLibraryName() {
        Library library = this.getLibrary();
        return library != null ? library.getName() : "<UNKNOWN>";
    }

    private Library getLibrary() {
        Namespace parent;
        for (parent = this.symbol.getParentNamespace(); parent != null && !(parent instanceof Library); parent = parent.getParentNamespace()) {
        }
        return (Library)parent;
    }

    @Override
    public Namespace getParentNameSpace() {
        return this.symbol.getParentNamespace();
    }

    @Override
    public String getParentName() {
        return this.symbol.getParentNamespace().getName();
    }

    long getExtNameID() {
        return this.symbol.getParentNamespace().getID();
    }

    @Override
    public String getLabel() {
        return this.symbol.getName();
    }

    @Override
    public String getOriginalImportedName() {
        return ExternalLocationDB.getExternalData3(this.symbol).getOriginalImportedName();
    }

    @Override
    public SourceType getSource() {
        return this.symbol.getSource();
    }

    @Override
    public Address getAddress() {
        return ExternalLocationDB.getExternalData3(this.symbol).getAddress(this.extMgr.getAddressMap().getAddressFactory());
    }

    @Override
    public Address getExternalSpaceAddress() {
        return this.symbol.getAddress();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.symbol.getName(true));
        if (this.getOriginalImportedName() != null) {
            builder.append(" (").append(this.getOriginalImportedName()).append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean isFunction() {
        return this.symbol.getSymbolType() == SymbolType.FUNCTION;
    }

    @Override
    public DataType getDataType() {
        long dataTypeID = this.symbol.getSymbolData1();
        if (dataTypeID < 0L) {
            return null;
        }
        return this.extMgr.getProgram().getDataTypeManager().getDataType(dataTypeID);
    }

    @Override
    public void setDataType(DataType dt) {
        long dataTypeID = this.extMgr.getProgram().getDataTypeManager().getResolvedID(dt);
        this.symbol.setSymbolData1(dataTypeID);
    }

    @Override
    public Function getFunction() {
        if (this.symbol.getSymbolType() == SymbolType.FUNCTION) {
            return (Function)this.symbol.getObject();
        }
        return null;
    }

    @Override
    public Function createFunction() {
        if (this.symbol.getSymbolType() == SymbolType.FUNCTION) {
            return this.getFunction();
        }
        Function function = this.extMgr.createFunction(this);
        this.symbol = (SymbolDB)function.getSymbol();
        return function;
    }

    void setLabel(String label, SourceType source) throws InvalidInputException {
        if (label == null) {
            this.setName(this.getLibrary(), null, SourceType.DEFAULT);
        } else if (label.indexOf("::") < 0) {
            this.setName(this.symbol.getParentNamespace(), label, source);
        } else {
            SymbolPath symbolPath = new SymbolPath(label);
            Namespace namespace = NamespaceUtils.createNamespaceHierarchy(symbolPath.getParentPath(), this.getLibrary(), this.extMgr.getProgram(), source);
            this.setName(namespace, symbolPath.getName(), source);
        }
    }

    @Override
    public void setLocation(String label, Address addr, SourceType source) throws InvalidInputException {
        if (label != null && label.length() == 0) {
            label = null;
        }
        if (label == null && addr == null) {
            throw new InvalidInputException("Either an external label or address is required");
        }
        if (addr != null && !addr.isMemoryAddress()) {
            throw new InvalidInputException("Invalid memory address");
        }
        this.setLabel(label, source);
        this.setAddress(addr);
    }

    @Override
    public void setAddress(Address address) throws InvalidInputException {
        String addressString;
        String string = addressString = address != null ? address.toString() : null;
        if (addressString == null && this.getSource() == SourceType.DEFAULT) {
            throw new InvalidInputException("Either an external label or address is required");
        }
        ExternalLocationDB.updateSymbolData3(this.symbol, ExternalLocationDB.getExternalData3(this.symbol).getOriginalImportedName(), addressString);
    }

    public void saveOriginalNameIfNeeded(Namespace oldNamespace, String oldName, SourceType oldSource) {
        boolean wasInLibrary = oldNamespace instanceof Library;
        String originalImportedName = this.getOriginalImportedName();
        if (this.getLabel().equals(originalImportedName)) {
            ExternalLocationDB.setOriginalImportedName(this.symbol, null);
        } else if (wasInLibrary && this.getSource() != SourceType.DEFAULT && oldSource == SourceType.IMPORTED && originalImportedName == null) {
            ExternalLocationDB.setOriginalImportedName(this.symbol, oldName);
        }
    }

    @Override
    public void setName(Namespace namespace, String newName, SourceType sourceType) throws InvalidInputException {
        try {
            if (!namespace.isExternal()) {
                throw new IllegalArgumentException("external namespace required");
            }
            if (newName == null || newName.length() == 0) {
                sourceType = SourceType.DEFAULT;
                String originalName = this.getOriginalImportedName();
                if (originalName != null) {
                    newName = originalName;
                    namespace = NamespaceUtils.getLibrary(namespace);
                    sourceType = SourceType.IMPORTED;
                } else if (this.getAddress() == null) {
                    throw new InvalidInputException("Either an external label or address is required");
                }
            } else if (namespace instanceof Library && newName.equals(this.getOriginalImportedName())) {
                sourceType = SourceType.IMPORTED;
            }
            this.symbol.setNameAndNamespace(newName, namespace, sourceType);
        }
        catch (CircularDependencyException | DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    @Override
    public void restoreOriginalName() {
        String originalName = this.getOriginalImportedName();
        if (originalName == null) {
            return;
        }
        try {
            Library library = NamespaceUtils.getLibrary(this.symbol.getParentNamespace());
            this.symbol.setNameAndNamespace(originalName, library, SourceType.IMPORTED);
            ExternalLocationDB.setOriginalImportedName(this.symbol, null);
        }
        catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
            throw new AssertException("Can't happen here", (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalLocationDB other = (ExternalLocationDB)obj;
        return this.symbol.equals(other.symbol);
    }

    @Override
    public boolean isEquivalent(ExternalLocation other) {
        if (other == null) {
            return false;
        }
        if (this.isFunction() != other.isFunction()) {
            return false;
        }
        String name = this.getLabel();
        String originalImportName = this.getOriginalImportedName();
        String otherName = other.getLabel();
        String otherOriginalImportName = other.getOriginalImportedName();
        if (originalImportName != null && originalImportName.equals(otherOriginalImportName)) {
            return true;
        }
        if (otherName.equals(originalImportName)) {
            return true;
        }
        if (name.equals(otherOriginalImportName)) {
            return true;
        }
        if (originalImportName != null || otherOriginalImportName != null) {
            return false;
        }
        if (!this.getSymbol().getName(true).equals(other.getSymbol().getName(true))) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.getAddress(), (Object)other.getAddress());
    }

    static ExternalData3 getExternalData3(SymbolDB extSymbol) {
        return new ExternalData3(extSymbol.getSymbolData3());
    }

    static void setOriginalImportedName(SymbolDB extSymbol, String name) {
        ExternalLocationDB.updateSymbolData3(extSymbol, name, ExternalLocationDB.getExternalData3(extSymbol).getAddressString());
    }

    static void updateSymbolData3(SymbolDB extSymbol, String originalImportedName, String addressString) {
        if (addressString == null && originalImportedName == null) {
            extSymbol.setSymbolData3(null);
        }
        StringBuilder buf = new StringBuilder();
        if (addressString != null) {
            buf.append(addressString);
        }
        if (originalImportedName != null) {
            buf.append(',');
            buf.append(originalImportedName);
        }
        extSymbol.setSymbolData3(buf.toString());
    }

    static class ExternalData3 {
        private String originalImportedName;
        private String addressString;

        ExternalData3(String data3) {
            if (data3 != null) {
                int indexOf = data3.indexOf(44);
                this.originalImportedName = indexOf >= 0 ? data3.substring(indexOf + 1) : null;
                this.addressString = indexOf >= 0 ? data3.substring(0, indexOf) : data3;
            }
        }

        public String getAddressString() {
            return this.addressString;
        }

        String getOriginalImportedName() {
            return this.originalImportedName;
        }

        Address getAddress(AddressFactory addrFactory) {
            if (this.addressString == null) {
                return null;
            }
            return addrFactory.getAddress(this.addressString);
        }
    }
}

