/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.mem.MemBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class UnionDB
extends CompositeDB
implements Union {
    private ArrayList<DataTypeComponentDB> components;
    private int unionLength;
    private static MemberComparator comparator = new MemberComparator();

    public UnionDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, Record record) {
        super(dataMgr, cache, compositeAdapter, componentAdapter, record);
    }

    @Override
    protected void initialize() {
        this.components = new ArrayList();
        try {
            long[] ids = this.componentAdapter.getComponentIdsInComposite(this.key);
            for (int i = 0; i < ids.length; ++i) {
                Record rec = this.componentAdapter.getRecord(ids[i]);
                this.components.add(new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec));
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        Collections.sort(this.components, comparator);
        this.unionLength = this.record.getIntValue(4);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Union>";
        }
        return "";
    }

    @Override
    public boolean isNotYetDefined() {
        return this.components.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent add(DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (length < 1) {
                throw new IllegalArgumentException("Minimum component length is 1 byte");
            }
            this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            int oldLength = this.unionLength;
            DataTypeComponent dtc = this.doAdd(dataType, length, name, comment);
            this.adjustInternalAlignment(false);
            this.updateLength(oldLength, true, true);
            DataTypeComponent dataTypeComponent = dtc;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    private DataTypeComponent doAdd(DataType resolvedDataType, int length, String name, String comment) {
        int dtLength = resolvedDataType.getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        DataTypeComponentDB dtc = this.createComponent(this.dataMgr.getResolvedID(resolvedDataType), length, this.components.size(), 0, name, comment);
        resolvedDataType.addParent(this);
        this.components.add(dtc);
        this.unionLength = Math.max(this.unionLength, length);
        return dtc;
    }

    private DataTypeComponentDB createComponent(long dtID, int length, int ordinal, int offset, String name, String comment) {
        try {
            Record rec = this.componentAdapter.createRecord(dtID, this.key, length, ordinal, offset, name, comment);
            return new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return null;
        }
    }

    private void removeComponent(long compKey) {
        try {
            this.componentAdapter.removeRecord(compKey);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (length < 1) {
                throw new IllegalArgumentException("Minimum component length is 1 byte");
            }
            this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            int dtLength = dataType.getLength();
            if (dtLength > 0 && dtLength < length) {
                length = dtLength;
            }
            int oldLength = this.unionLength;
            DataTypeComponentDB dtc = this.createComponent(this.dataMgr.getResolvedID(dataType), length, ordinal, 0, name, comment);
            dataType.addParent(this);
            this.shiftOrdinals(ordinal, 1);
            this.components.add(ordinal, dtc);
            this.adjustInternalAlignment(true);
            this.updateLength(oldLength, true, true);
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.unionLength;
            DataTypeComponentDB dtc = this.components.remove(ordinal);
            dtc.getDataType().removeParent(this);
            this.removeComponent(dtc.getKey());
            this.shiftOrdinals(ordinal, -1);
            this.adjustInternalAlignment(false);
            this.updateLength(oldLength, true, true);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            this.delete(ordinal);
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Union)) {
            throw new IllegalArgumentException();
        }
        this.doReplaceWith((Union)dataType, true);
    }

    void doReplaceWith(Union union, boolean notify) {
        this.doReplaceWith(union, notify, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReplaceWith(Union union, boolean notify, DataTypeConflictHandler handler) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.unionLength;
            long oldMinAlignment = this.getMinimumAlignment();
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponentDB dtc = this.components.get(i);
                dtc.getDataType().removeParent(this);
                this.removeComponent(dtc.getKey());
            }
            this.components.clear();
            DataTypeComponent[] otherComponents = union.getComponents();
            for (int i = 0; i < otherComponents.length; ++i) {
                DataTypeComponent dtc = otherComponents[i];
                DataType dt = dtc.getDataType();
                dt = this.resolve(dt, handler);
                this.checkAncestry(dt);
                int dtLength = dt.getLength();
                if (dtLength <= 0) {
                    dtLength = dtc.getLength();
                }
                this.doAdd(dt, dtLength, dtc.getFieldName(), dtc.getComment());
            }
            this.setDescription(union.getDescription());
            this.setAlignment(union, notify);
            this.updateLength(oldLength, notify, true);
            if (notify && oldMinAlignment != (long)this.getMinimumAlignment()) {
                this.notifyAlignmentChanged();
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponent dtc = this.components.get(i);
                DataType dt = dtc.getDataType();
                if (dt != dataType) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartOf(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.equals(dataType)) {
                boolean bl = true;
                return bl;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponent dtc = this.components.get(i);
                DataType subDt = dtc.getDataType();
                if (subDt instanceof Composite) {
                    if (!((Composite)subDt).isPartOf(dataType)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!subDt.equals(dataType)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.components.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent getComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (ordinal < 0 || ordinal >= this.components.size()) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = this.components.get(ordinal);
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] dataTypeComponentArray = this.components.toArray(new DataTypeComponent[this.components.size()]);
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.unionLength == 0) {
                int n = 1;
                return n;
            }
            int n = this.unionLength;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean changed = false;
            int oldLength = this.unionLength;
            this.unionLength = 0;
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponentDB dtc = this.components.get(i);
                DataType tmpDt = dtc.getDataType();
                int tmpLen = tmpDt.getLength();
                if (tmpDt.isEquivalent(dt) && tmpLen > 0 && tmpLen != dtc.getLength()) {
                    dtc.setLength(tmpLen, true);
                    changed = true;
                }
                this.unionLength = Math.max(this.unionLength, dtc.getLength());
            }
            if (changed) {
                this.adjustInternalAlignment(false);
                this.updateLength(oldLength, true, false);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.adjustInternalAlignment(true);
    }

    public void adjustLength() {
        this.adjustLength(true);
    }

    public void adjustLength(boolean notify) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.unionLength;
            this.unionLength = this.getLength(this.getDataOrganization(), this.isInternallyAligned());
            this.updateLength(oldLength, notify, false);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.unionLength;
            boolean didDelete = false;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                if (dtc.getDataType() != dt) continue;
                dt.removeParent(this);
                this.components.remove(i);
                this.removeComponent(dtc.getKey());
                this.shiftOrdinals(i, -1);
                didDelete = true;
            }
            if (didDelete) {
                this.adjustInternalAlignment(false);
                if (this.unionLength == 0) {
                    this.dataMgr.addDataTypeToDelete(this.key);
                } else {
                    this.updateLength(oldLength, true, false);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        DataTypeComponent[] otherComps;
        if (dt == this) {
            return true;
        }
        if (dt == null || !(dt instanceof Union)) {
            return false;
        }
        this.checkIsValid();
        if (this.resolving) {
            if (dt.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dt.getPathName());
        }
        Union union = (Union)dt;
        if (this.isInternallyAligned() != union.isInternallyAligned() || this.isDefaultAligned() != union.isDefaultAligned() || this.isMachineAligned() != union.isMachineAligned() || this.getMinimumAlignment() != union.getMinimumAlignment() || this.getPackingValue() != union.getPackingValue()) {
            return false;
        }
        DataTypeComponent[] myComps = this.getComponents();
        if (myComps.length != (otherComps = union.getComponents()).length) {
            return false;
        }
        for (int i = 0; i < myComps.length; ++i) {
            if (myComps[i].isEquivalent(otherComps[i])) continue;
            return false;
        }
        return true;
    }

    private void updateLength(int oldLength, boolean notify, boolean setLastChangeTime) {
        if (oldLength != this.unionLength) {
            this.record.setIntValue(4, this.unionLength);
            try {
                this.compositeAdapter.updateRecord(this.record, setLastChangeTime);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.notifySizeChanged();
        } else if (notify) {
            this.dataMgr.dataTypeChanged(this);
        }
    }

    private int computeUnpaddedUnionLength() {
        int unpaddedLength = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            unpaddedLength = Math.max(unpaddedLength, ((DataTypeComponent)this.components.get(i)).getLength());
        }
        return unpaddedLength;
    }

    private void shiftOrdinals(int ordinal, int deltaOrdinal) {
        for (int i = ordinal; i < this.components.size(); ++i) {
            DataTypeComponentDB dtc = this.components.get(i);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (oldDt == this) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            try {
                this.validateDataType(newDt);
                if (!(newDt instanceof DataTypeDB) || newDt.getDataTypeManager() != this.getDataTypeManager()) {
                    newDt = this.resolve(newDt);
                }
                this.checkAncestry(newDt);
            }
            catch (Exception e) {
                newDt = new ByteDataType();
            }
            boolean changed = false;
            int oldLength = this.getLength();
            for (DataTypeComponentDB comp : this.components) {
                DataType compDt = comp.getDataType();
                if (oldDt != compDt) continue;
                oldDt.removeParent(this);
                comp.setDataType(newDt);
                newDt.addParent(this);
                int len = newDt.getLength();
                if (len > 0) {
                    comp.setLength(len, true);
                }
                changed = true;
            }
            if (changed) {
                this.adjustInternalAlignment(false);
                if (oldLength != this.getLength()) {
                    this.updateLength(oldLength, true, true);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dependsOn(DataType dt) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.getNumComponents() == 1) {
                DataTypeComponent dtc = this.getComponent(0);
                boolean bl = dtc.getDataType().dependsOn(dt);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "UNION_" + this.getName();
    }

    public int getLength(DataOrganization dataOrganization, boolean padEnd) {
        int unpaddedLength;
        int newLength = unpaddedLength = this.computeUnpaddedUnionLength();
        if (padEnd) {
            newLength += this.getPaddingSize(dataOrganization, unpaddedLength);
        }
        return newLength;
    }

    private int getPaddingSize(DataOrganization dataOrganization, int unpaddedLength) {
        int alignment = dataOrganization.getAlignment(this, unpaddedLength);
        int amountFilled = unpaddedLength % alignment;
        if (amountFilled > 0) {
            return alignment - amountFilled;
        }
        return 0;
    }

    @Override
    public void setInternallyAligned(boolean aligned) {
        super.setInternallyAligned(aligned);
        this.adjustInternalAlignment(true);
    }

    @Override
    public void realign() {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment(true);
        }
    }

    @Override
    public void adjustInternalAlignment(boolean notify) {
        this.adjustLength(notify);
    }

    private static class MemberComparator
    implements Comparator<DataTypeComponent> {
        private MemberComparator() {
        }

        @Override
        public int compare(DataTypeComponent dtc1, DataTypeComponent dtc2) {
            return dtc1.getOrdinal() - dtc2.getOrdinal();
        }
    }
}

