/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class DirectoryVisitor
implements Iterable<File> {
    private final ArrayList<File> startingDirectories;
    private final FileFilter directoryFilter;
    private final FileFilter filter;
    private final boolean compareCase;

    public DirectoryVisitor(File startingDirectory, FileFilter filter) {
        this(startingDirectory, null, filter, true);
    }

    public DirectoryVisitor(File startingDirectory, FileFilter filter, boolean compareCase) {
        this(startingDirectory, null, filter, compareCase);
    }

    public DirectoryVisitor(File startingDirectory, FileFilter directoryFilter, FileFilter filter) {
        this(startingDirectory, directoryFilter, filter, true);
    }

    public DirectoryVisitor(File startingDirectory, FileFilter directoryFilter, FileFilter filter, boolean compareCase) {
        this.startingDirectories = new ArrayList();
        this.startingDirectories.add(startingDirectory);
        this.directoryFilter = directoryFilter;
        this.filter = filter;
        this.compareCase = compareCase;
    }

    public DirectoryVisitor(Collection<File> startingDirectories, FileFilter filter) {
        this(startingDirectories, null, filter, true);
    }

    public DirectoryVisitor(Collection<File> startingDirectories, FileFilter filter, boolean compareCase) {
        this(startingDirectories, null, filter, compareCase);
    }

    public DirectoryVisitor(Collection<File> startingDirectories, FileFilter directoryFilter, FileFilter filter) {
        this(startingDirectories, directoryFilter, filter, true);
    }

    public DirectoryVisitor(Collection<File> startingDirectories, FileFilter directoryFilter, FileFilter filter, boolean compareCase) {
        this.startingDirectories = new ArrayList<File>(startingDirectories);
        this.directoryFilter = directoryFilter;
        this.filter = filter;
        this.compareCase = compareCase;
    }

    @Override
    public Iterator<File> iterator() {
        return new BreadthFirstDirectoryVisitor(this.startingDirectories, this.directoryFilter, this.filter, this.compareCase);
    }

    private static class BreadthFirstDirectoryVisitor
    implements Iterator<File> {
        private final LinkedList<File> directoryQueue = new LinkedList();
        private final LinkedList<File> fileQueue = new LinkedList();
        private final FileFilter directoryFilter;
        private final FileFilter filter;
        private final Comparator<File> comparator;
        private static final Comparator<File> CASE_SENSITIVE = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        private static final Comparator<File> CASE_INSENSITIVE = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        private static final FileFilter DIRECTORIES = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };

        public BreadthFirstDirectoryVisitor(Iterable<File> startingDirectories, final FileFilter directoryFilter, FileFilter filter, boolean compareCase) {
            this.directoryFilter = directoryFilter == null ? DIRECTORIES : new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && directoryFilter.accept(pathname);
                }
            };
            this.filter = filter;
            this.comparator = compareCase ? CASE_SENSITIVE : CASE_INSENSITIVE;
            for (File directory : startingDirectories) {
                if (!directory.isDirectory()) {
                    throw new RuntimeException(directory + " is not a directory");
                }
                this.directoryQueue.addLast(directory);
            }
        }

        private void populateDirectoryQueue(File startingDirectory) {
            File[] subdirectories = startingDirectory.listFiles(this.directoryFilter);
            if (subdirectories != null) {
                Arrays.sort(subdirectories, this.comparator);
                for (File subdirectory : subdirectories) {
                    this.directoryQueue.addLast(subdirectory);
                }
            }
        }

        private void populateFileQueue(File directory) {
            File[] files = directory.listFiles(this.filter);
            if (files != null) {
                Arrays.sort(files, this.comparator);
                for (File file : files) {
                    this.fileQueue.addLast(file);
                }
            }
        }

        private void ensureNextFileIsPresentInQueue() {
            while (this.fileQueue.isEmpty() && !this.directoryQueue.isEmpty()) {
                File directory = this.directoryQueue.removeFirst();
                this.populateDirectoryQueue(directory);
                this.populateFileQueue(directory);
            }
        }

        @Override
        public boolean hasNext() {
            this.ensureNextFileIsPresentInQueue();
            return !this.fileQueue.isEmpty();
        }

        @Override
        public File next() {
            this.ensureNextFileIsPresentInQueue();
            return this.fileQueue.removeFirst();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

