/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.grammars;

import ghidra.app.plugin.assembler.sleigh.grammars.AbstractAssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AbstractAssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.map.LazyMap;

public class AssemblyGrammar
extends AbstractAssemblyGrammar<AssemblyNonTerminal, AssemblyProduction> {
    protected final Map<AssemblyProduction, Map<Constructor, AssemblyConstructorSemantic>> semantics = LazyMap.lazyMap(new TreeMap(), () -> new TreeMap());
    protected final Map<String, AssemblyProduction> pureRecursive = new TreeMap<String, AssemblyProduction>();

    @Override
    protected AssemblyProduction newProduction(AssemblyNonTerminal lhs, AssemblySentential<AssemblyNonTerminal> rhs) {
        return new AssemblyProduction(lhs, rhs);
    }

    @Override
    public void addProduction(AssemblyProduction prod) {
        if (this.isPureRecursive(prod)) {
            this.pureRecursive.put(((AssemblySymbol)prod.getLHS()).getName(), prod);
        } else {
            super.addProduction(prod);
        }
    }

    public void addProduction(AssemblyNonTerminal lhs, AssemblySentential<AssemblyNonTerminal> rhs, DisjointPattern pattern, Constructor cons, List<Integer> indices) {
        AbstractAssemblyProduction prod = this.newProduction(lhs, (AssemblySentential)rhs);
        this.addProduction((AssemblyProduction)prod);
        Map<Constructor, AssemblyConstructorSemantic> map = this.semantics.get(prod);
        AssemblyConstructorSemantic sem = map.get(cons);
        if (sem == null) {
            sem = new AssemblyConstructorSemantic(cons, indices);
            map.put(cons, sem);
        } else if (!indices.equals(sem.getOperandIndices())) {
            throw new IllegalStateException("Productions of the same constructor must have same operand indices");
        }
        sem.addPattern(pattern);
    }

    public Collection<AssemblyConstructorSemantic> getSemantics(AssemblyProduction prod) {
        return Collections.unmodifiableCollection(this.semantics.get(prod).values());
    }

    @Override
    public void combine(AbstractAssemblyGrammar<AssemblyNonTerminal, AssemblyProduction> that) {
        super.combine(that);
        if (that instanceof AssemblyGrammar) {
            AssemblyGrammar ag = (AssemblyGrammar)that;
            this.semantics.putAll(ag.semantics);
            this.pureRecursive.putAll(ag.pureRecursive);
        }
    }

    public Collection<AssemblyProduction> getPureRecursive() {
        return this.pureRecursive.values();
    }

    public AssemblyProduction getPureRecursion(AssemblyNonTerminal lhs) {
        return this.pureRecursive.get(lhs.getName());
    }
}

