/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AbstractGraphComponentPanel;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JComponent;

public abstract class AbstractFunctionGraphVertex
implements FGVertex {
    private FGController controller;
    private final Program program;
    private final AddressSetView addressSet;
    private Point2D location;
    private double emphasisLevel;
    private double alpha = 1.0;
    private FGVertexType vertexType;
    private FlowType flowType;
    private boolean isEntry;
    private boolean doHashCode = true;
    private int hashCode;
    protected Color pendingRestoreColor;
    private GroupHistoryInfo groupInfo;

    AbstractFunctionGraphVertex(FGController controller, Program program, AddressSetView addresses, FlowType flowType, boolean isEntry) {
        if (addresses == null || addresses.isEmpty()) {
            throw new IllegalArgumentException("Vertex cannot have null or empty address body");
        }
        this.controller = controller;
        this.program = program;
        this.addressSet = addresses;
        this.flowType = flowType;
        this.isEntry = isEntry;
        this.location = new Point2D.Double();
    }

    AbstractFunctionGraphVertex(FGController controller, AbstractFunctionGraphVertex vertex) {
        this.controller = controller;
        this.program = vertex.program;
        this.addressSet = vertex.addressSet;
        this.location = vertex.location;
        this.vertexType = vertex.vertexType;
        this.isEntry = vertex.isEntry;
        this.flowType = vertex.flowType;
        this.groupInfo = vertex.groupInfo;
    }

    abstract boolean hasLoadedComponent();

    abstract AbstractGraphComponentPanel doGetComponent();

    @Override
    public void writeSettings(FunctionGraphVertexAttributes settings) {
        this.controller.saveVertexColors(this, settings);
    }

    @Override
    public void readSettings(FunctionGraphVertexAttributes settings) {
        this.controller.restoreVertexColors(this, settings);
    }

    @Override
    public void updateGroupAssociationStatus(GroupHistoryInfo newGroupInfo) {
        this.groupInfo = newGroupInfo;
        this.doGetComponent().updateGroupAssociationStatus(this.groupInfo != null);
    }

    @Override
    public GroupHistoryInfo getGroupInfo() {
        return this.groupInfo;
    }

    @Override
    public boolean isUncollapsedGroupMember() {
        if (this.groupInfo == null) {
            return false;
        }
        return this.isInGraph();
    }

    private boolean isInGraph() {
        FunctionGraph functionGraph;
        FGData graphData = this.controller.getFunctionGraphData();
        FunctionGraph graph = functionGraph = graphData.getFunctionGraph();
        return graph.containsVertex(this);
    }

    public JComponent getComponent() {
        return this.doGetComponent();
    }

    FGController getController() {
        return this.controller;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public Address getVertexAddress() {
        return this.addressSet.getMinAddress();
    }

    @Override
    public AddressSetView getAddresses() {
        return this.addressSet;
    }

    @Override
    public boolean containsProgramLocation(ProgramLocation location) {
        return this.addressSet.contains(location.getAddress());
    }

    @Override
    public boolean containsAddress(Address address) {
        return this.addressSet.contains(address);
    }

    public void setEmphasis(double emphasisLevel) {
        this.emphasisLevel = emphasisLevel;
    }

    public double getEmphasis() {
        return this.emphasisLevel;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setLocation(Point2D location) {
        this.location = location;
    }

    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public FGVertexType getVertexType() {
        return this.vertexType;
    }

    @Override
    public void setVertexType(FGVertexType vertexType) {
        if (this.vertexType != null) {
            throw new AssertException("Cannot set the vertex type more than once.  Previous type was " + vertexType + " on vertex " + this);
        }
        this.vertexType = vertexType;
    }

    @Override
    public boolean isEntry() {
        return this.isEntry;
    }

    @Override
    public FlowType getFlowType() {
        return this.flowType;
    }

    public int hashCode() {
        if (this.doHashCode) {
            this.hashCode = this.addressSet.getMinAddress().hashCode();
            this.doHashCode = false;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        Address otherMinAddress;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFunctionGraphVertex other = (AbstractFunctionGraphVertex)obj;
        Address minAddress = this.addressSet.getMinAddress();
        if (!SystemUtilities.isEqual((Object)minAddress, (Object)(otherMinAddress = other.addressSet.getMinAddress()))) {
            return false;
        }
        Address maxAddress = this.addressSet.getMaxAddress();
        Address otherMaxAddress = other.addressSet.getMaxAddress();
        return SystemUtilities.isEqual((Object)maxAddress, (Object)otherMaxAddress);
    }

    @Override
    public void dispose() {
        this.controller = null;
    }

    @Override
    public void restoreColor(Color color) {
        if (this.hasLoadedComponent()) {
            this.doGetComponent().restoreColor(color);
            return;
        }
        this.pendingRestoreColor = color;
    }

    @Override
    public Color getUserDefinedColor() {
        return this.doGetComponent().getUserDefinedColor();
    }

    @Override
    public Color getDefaultBackgroundColor() {
        return this.doGetComponent().getDefaultBackgroundColor();
    }

    @Override
    public Color getBackgroundColor() {
        return this.doGetComponent().getBackgroundColor();
    }

    @Override
    public void clearColor() {
        this.doGetComponent().clearColor();
    }

    @Override
    public String getTitle() {
        return this.doGetComponent().getTitle();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.doGetComponent().getToolTipText(event);
    }

    @Override
    public JComponent getToolTipComponentForEdge(FGEdge edge) {
        return this.doGetComponent().getToolTipComponentForEdge(edge);
    }

    @Override
    public JComponent getToolTipComponentForVertex() {
        return this.doGetComponent().getToolTipComponentForVertex();
    }

    @Override
    public boolean isDefaultBackgroundColor() {
        return this.doGetComponent().isDefaultBackgroundColor();
    }

    @Override
    public Rectangle getBounds() {
        return this.doGetComponent().getBounds();
    }

    @Override
    public boolean isFullScreenMode() {
        return this.doGetComponent().isFullScreenMode();
    }

    @Override
    public void setFullScreenMode(boolean fullScreen) {
        this.doGetComponent().setFullScreenMode(fullScreen);
    }

    public boolean isSelected() {
        return this.doGetComponent().isSelected();
    }

    public void setSelected(boolean selected) {
        this.doGetComponent().setSelected(selected);
    }

    public void setHovered(boolean hovered) {
    }

    public boolean isHovered() {
        return false;
    }

    @Override
    public void editLabel(JComponent parentComponent) {
        this.doGetComponent().editLabel(parentComponent);
    }

    public void setFocused(boolean focused) {
        AbstractGraphComponentPanel component = this.doGetComponent();
        component.setSelected(focused);
        component.setFocused(focused);
    }

    public boolean isFocused() {
        AbstractGraphComponentPanel component = this.doGetComponent();
        return component.isFocused();
    }

    @Override
    public void setProgramSelection(ProgramSelection selection) {
        this.doGetComponent().setProgramSelection(selection);
    }

    @Override
    public ProgramSelection getProgramSelection() {
        return this.doGetComponent().getProgramSelection();
    }

    @Override
    public void setProgramHighlight(ProgramSelection highlight) {
        this.doGetComponent().setProgramHighlight(highlight);
    }

    @Override
    public void setProgramLocation(ProgramLocation location) {
        this.doGetComponent().setProgramLocation(location);
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return this.doGetComponent().getProgramLocation();
    }

    @Override
    public ListingModel getListingModel(Address address) {
        return this.doGetComponent().getListingModel(address);
    }

    @Override
    public Rectangle getCursorBounds() {
        return this.doGetComponent().getCursorBounds();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.doGetComponent().setBackgroundColor(color);
    }

    @Override
    public boolean isHeaderClick(Component clickedComponent) {
        return this.doGetComponent().isHeaderClick(clickedComponent);
    }

    public boolean isGrabbable(Component c) {
        if (!this.doGetComponent().isHeaderClick(c)) {
            return false;
        }
        return !(c instanceof JButton);
    }

    public String toString() {
        if (this.getController() == null || !this.hasLoadedComponent()) {
            return this.getClass().getSimpleName() + "@" + this.getVertexAddress().toString();
        }
        return this.doGetComponent().getTitle();
    }

    @Override
    public void refreshModel() {
        this.doGetComponent().refreshModel();
    }

    @Override
    public void refreshDisplay() {
        this.doGetComponent().refreshDisplay();
    }

    @Override
    public void refreshDisplayForAddress(Address address) {
        this.doGetComponent().refreshDisplayForAddress(address);
    }

    @Override
    public void setShowing(boolean isShowing) {
        this.doGetComponent().setShowing(isShowing);
    }

    @Override
    public Component getMaximizedViewComponent() {
        return this.doGetComponent().getMaximizedViewComponent();
    }
}

