/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.jung.renderer.FGEdgeRenderer;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.listing.Function;

public abstract class AbstractFGLayout
extends AbstractVisualGraphLayout<FGVertex, FGEdge>
implements FGLayout {
    protected Function function;
    protected FunctionGraphOptions options;

    protected AbstractFGLayout(FunctionGraph graph) {
        super((Graph)graph);
        this.function = graph.getFunction();
        this.options = graph.getOptions();
    }

    protected abstract AbstractVisualGraphLayout<FGVertex, FGEdge> createClonedFGLayout(FunctionGraph var1);

    @Override
    public FunctionGraph getVisualGraph() {
        return (FunctionGraph)this.getGraph();
    }

    public AbstractVisualGraphLayout<FGVertex, FGEdge> createClonedLayout(VisualGraph<FGVertex, FGEdge> newGraph) {
        return this.createClonedFGLayout((FunctionGraph)newGraph);
    }

    @Override
    public FGLayout cloneLayout(VisualGraph<FGVertex, FGEdge> newGraph) {
        VisualGraphLayout clone = super.cloneLayout(newGraph);
        return (FGLayout)clone;
    }

    protected boolean isCondensedLayout() {
        return this.options.useCondensedLayout();
    }

    public BasicEdgeRenderer<FGVertex, FGEdge> getEdgeRenderer() {
        return new FGEdgeRenderer();
    }
}

