/*
 * Decompiled with CFR 0.152.
 */
package utilities.util;

import ghidra.util.SystemUtilities;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtilities {
    public static byte[] reverse(byte[] array) {
        byte[] reversed = new byte[array.length];
        for (int i = 0; i < reversed.length; ++i) {
            reversed[i] = array[array.length - 1 - i];
        }
        return reversed;
    }

    public static boolean isArrayPrimativeEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Class<?> class1 = o1.getClass();
        if (!class1.isArray()) {
            throw new IllegalArgumentException("Object parameters must be an array! Instead found class: " + class1);
        }
        Class<?> class2 = o2.getClass();
        if (!class2.isArray()) {
            throw new IllegalArgumentException("Object parameters must be an array! Instead found class: " + class2);
        }
        if (Array.getLength(o1) != Array.getLength(o2)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(o1); ++i) {
            if (SystemUtilities.isEqual(Array.get(o1, i), Array.get(o2, i))) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayRangesEquals(byte[] b1, int start_b1, byte[] b2, int start_b2, int len) {
        if (start_b1 + len > b1.length || start_b2 + len > b2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (b1[start_b1 + i] == b2[start_b2 + i]) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] copyAndAppend(T[] array, T element) {
        T[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = element;
        return newArray;
    }

    public static int compare(byte[] a, byte[] b) {
        int result = a.length - b.length;
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < a.length; ++i) {
            result = a[i] - b[i];
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

