/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

public class ApplicationVersion
implements Comparable<ApplicationVersion> {
    private int major;
    private int minor;
    private int patch;

    public ApplicationVersion(String version) throws IllegalArgumentException {
        this.parse(version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        if (this.patch == 0) {
            return String.format("%d.%d", this.major, this.minor);
        }
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(ApplicationVersion other) {
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationVersion other = (ApplicationVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    private void parse(String version) throws IllegalArgumentException {
        String[] versionParts;
        if (version == null) {
            throw new IllegalArgumentException("Version is null");
        }
        int dashIndex = version.indexOf(45);
        if (dashIndex != -1) {
            version = version.substring(0, dashIndex);
        }
        if ((versionParts = version.split("\\.")).length == 2) {
            this.major = this.parse(versionParts[0], "major");
            this.minor = this.parse(versionParts[1], "minor");
            this.patch = 0;
        } else if (versionParts.length == 3) {
            this.major = this.parse(versionParts[0], "major");
            this.minor = this.parse(versionParts[1], "minor");
            this.patch = this.parse(versionParts[2], "patch");
        } else {
            throw new IllegalArgumentException("Version has " + versionParts.length + " parts but 2 or 3 are required");
        }
    }

    private int parse(String versionPart, String versionPartName) throws IllegalArgumentException {
        try {
            int i = Integer.parseInt(versionPart);
            if (i < 0) {
                throw new IllegalArgumentException(versionPartName + " cannot be negative");
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to convert " + versionPartName + " version to integer");
        }
    }
}

