/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.widgets.table.AbstractGTableModel;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.gui.wizard.CorrelatorPanel;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import resources.ResourceManager;

public class VTProgramTableCorrelatorModel
extends AbstractGTableModel<VTProgramCorrelatorFactory> {
    static final String NAME_COLUMN_NAME = "Name";
    static final String DESCRIPTION_COLUMN_NAME = "Description";
    static final String PREVIOUS_NAME = "Previous";
    static final String SELECT_NAME = "Select";
    private static final Comparator<VTProgramCorrelatorFactory> comparator = new Comparator<VTProgramCorrelatorFactory>(){

        @Override
        public int compare(VTProgramCorrelatorFactory o1, VTProgramCorrelatorFactory o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };
    private static final Icon ALREADY_RUN_ICON = ResourceManager.loadImage((String)"images/flag-green.png");
    private List<VTProgramCorrelatorFactory> list;
    private Set<String> previouslyRunCorrelators;
    private Set<VTProgramCorrelatorFactory> selectedFactories = new HashSet<VTProgramCorrelatorFactory>();
    private CorrelatorPanel panel;

    public VTProgramTableCorrelatorModel(CorrelatorPanel panel, Set<String> previouslyRunCorrelators) {
        this.panel = panel;
        this.previouslyRunCorrelators = previouslyRunCorrelators;
        this.list = VTProgramTableCorrelatorModel.generateList();
    }

    public List<VTProgramCorrelatorFactory> getSelectedFactories() {
        return new ArrayList<VTProgramCorrelatorFactory>(this.selectedFactories);
    }

    private static List<VTProgramCorrelatorFactory> generateList() {
        Set instances = ClassSearcher.getInstances(VTAbstractProgramCorrelatorFactory.class);
        ArrayList<VTProgramCorrelatorFactory> list = new ArrayList<VTProgramCorrelatorFactory>(instances);
        Collections.sort(list, comparator);
        return list;
    }

    public String getName() {
        return "Correlators";
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return SELECT_NAME;
            }
            case 1: {
                return NAME_COLUMN_NAME;
            }
            case 2: {
                return PREVIOUS_NAME;
            }
            case 3: {
                return DESCRIPTION_COLUMN_NAME;
            }
        }
        throw new AssertException("Update the column name for the newly added column");
    }

    public Object getColumnValueForRow(VTProgramCorrelatorFactory t, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.selectedFactories.contains(t);
            }
            case 1: {
                return t.getName();
            }
            case 2: {
                if (this.previouslyRunCorrelators.contains(t.getName())) {
                    return ALREADY_RUN_ICON;
                }
                return null;
            }
            case 3: {
                return t.getDescription();
            }
        }
        return t;
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 2: {
                return Icon.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        VTProgramCorrelatorFactory factory = this.list.get(rowIndex);
        if (((Boolean)aValue).booleanValue()) {
            this.selectedFactories.add(factory);
        } else {
            this.selectedFactories.remove(factory);
        }
        this.panel.notifyListenersOfValidityChanged();
    }

    public List<VTProgramCorrelatorFactory> getModelData() {
        return this.list;
    }

    public int getColumnCount() {
        return 4;
    }

    public VTProgramCorrelatorFactory getRowObject(int row) {
        if (row < 0 || row >= this.list.size()) {
            return null;
        }
        return this.list.get(row);
    }
}

