/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.app.util.AddressInput;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.gui.editors.AddressEditorPanel;
import ghidra.feature.vt.gui.editors.AddressEditorPanelListener;
import ghidra.feature.vt.gui.editors.EditableAddress;
import ghidra.feature.vt.gui.provider.markuptable.DisplayableListingAddress;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

public class EditableListingAddress
extends DisplayableListingAddress
implements EditableAddress {
    private final VTMarkupItem markupItem;

    public EditableListingAddress(Program program, Address currentListingAddress, VTMarkupItem markupItem) {
        super(program, currentListingAddress);
        this.markupItem = markupItem;
    }

    @Override
    public AddressEditorPanel getEditorPanel() {
        return new ListingAddressEditorPanel();
    }

    @Override
    public String getEditorTitle() {
        return "Enter Address";
    }

    @Override
    public VTMarkupItem getMarkupItem() {
        return this.markupItem;
    }

    class ListingAddressEditorPanel
    extends AddressEditorPanel {
        private AddressInput addressField;
        private AddressEditorPanelListener addressPanelListener;

        ListingAddressEditorPanel() {
            this.buildPanel();
        }

        private void buildPanel() {
            this.setLayout((LayoutManager)new PairLayout(5, 5, 50));
            this.addressField = new AddressInput();
            this.addressField.setAddressFactory(EditableListingAddress.this.program.getAddressFactory());
            if (EditableListingAddress.this.address != null) {
                this.addressField.setAddress(EditableListingAddress.this.address);
            }
            this.addressField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ListingAddressEditorPanel.this.addressPanelListener != null) {
                        ListingAddressEditorPanel.this.addressPanelListener.addressEdited();
                    }
                }
            });
            JLabel label = new JLabel("Address: ");
            this.add(label);
            this.add((Component)this.addressField);
        }

        @Override
        public Address getAddress() throws InvalidInputException {
            Address selectedAddress = this.addressField.getAddress();
            if (selectedAddress == null) {
                throw new InvalidInputException("\"" + this.addressField.getValue() + "\" is not a valid address.");
            }
            if (!EditableListingAddress.this.program.getMemory().contains(selectedAddress)) {
                throw new InvalidInputException("\"" + selectedAddress.toString() + "\" is not an address in the program.");
            }
            EditableListingAddress.this.address = selectedAddress;
            return EditableListingAddress.this.address;
        }

        @Override
        public void setAddressPanelListener(AddressEditorPanelListener addressPanelListener) {
            this.addressPanelListener = addressPanelListener;
        }
    }
}

