/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.duallisting;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.codebrowser.ListingHighlightProvider;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.EolCommentFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FunctionRepeatableCommentFieldFactory;
import ghidra.app.util.viewer.field.FunctionSignatureFieldFactory;
import ghidra.app.util.viewer.field.LabelFieldFactory;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.PlateFieldFactory;
import ghidra.app.util.viewer.field.PostCommentFieldFactory;
import ghidra.app.util.viewer.field.PreCommentFieldFactory;
import ghidra.app.util.viewer.field.VariableCommentFieldFactory;
import ghidra.app.util.viewer.field.VariableLocFieldFactory;
import ghidra.app.util.viewer.field.VariableNameFieldFactory;
import ghidra.app.util.viewer.field.VariableTypeFieldFactory;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.DataTypeMarkupType;
import ghidra.feature.vt.api.markuptype.EolCommentMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionNameMarkupType;
import ghidra.feature.vt.api.markuptype.FunctionSignatureMarkupType;
import ghidra.feature.vt.api.markuptype.LabelMarkupType;
import ghidra.feature.vt.api.markuptype.PlateCommentMarkupType;
import ghidra.feature.vt.api.markuptype.PostCommentMarkupType;
import ghidra.feature.vt.api.markuptype.PreCommentMarkupType;
import ghidra.feature.vt.api.markuptype.RepeatableCommentMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.DataTypeStringable;
import ghidra.feature.vt.api.stringable.FunctionNameStringable;
import ghidra.feature.vt.api.stringable.MultipleSymbolStringable;
import ghidra.feature.vt.api.stringable.StringStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class VTDualListingHighlightProvider
implements HighlightProvider {
    private static Color APPLIED_MARKUP_COLOR = new Color(150, 220, 150);
    private static Color UNAPPLIED_MARKUP_COLOR = new Color(255, 170, 85);
    private static Color IGNORED_MARKUP_COLOR = new Color(220, 220, 220);
    private static Color REJECTED_MARKUP_COLOR = new Color(250, 200, 200);
    private static Color FAILED_MARKUP_COLOR = new Color(255, 80, 80);
    private static Color NO_ADDRESS_MARKUP_COLOR = new Color(205, 185, 220);
    private static Color SAME_MARKUP_COLOR = new Color(175, 225, 255);
    private static Color CONFLICT_MARKUP_COLOR = new Color(255, 225, 105);
    private HashMap<Address, HashMap<VTMarkupType, VTMarkupItem>> map = new HashMap();
    private final VTController controller;
    private ListingPanel listingPanel;
    private ListingHighlightProvider listingHighlighter;
    private VTMarkupItem currentMarkupItem;
    private boolean isSource;

    public VTDualListingHighlightProvider(VTController controller, boolean isSource) {
        this.controller = controller;
        this.isSource = isSource;
        this.updateMarkup();
    }

    public void setListingPanel(ListingPanel listingPanel) {
        if (this.listingPanel != null) {
            this.listingPanel.removeButtonPressedListener((ButtonPressedListener)this.listingHighlighter);
        }
        this.listingPanel = listingPanel;
        if (listingPanel != null) {
            this.listingHighlighter = new ListingHighlightProvider(this.controller.getTool(), (Component)listingPanel);
            listingPanel.removeButtonPressedListener((ButtonPressedListener)this.listingHighlighter);
            listingPanel.addButtonPressedListener((ButtonPressedListener)this.listingHighlighter);
        }
    }

    public void updateMarkup() {
        this.map.clear();
        VTSession session = this.controller.getSession();
        if (session == null) {
            return;
        }
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo != null) {
            Collection<VTMarkupItem> markupItems = matchInfo.getAppliableMarkupItems(null);
            for (VTMarkupItem markupItem : markupItems) {
                this.updateMap(markupItem);
            }
        }
    }

    private void updateMap(VTMarkupItem markupItem) {
        VTMarkupType markupType = markupItem.getMarkupType();
        Address address = this.isSource ? markupItem.getSourceAddress() : markupItem.getDestinationAddress();
        if (address == null || address == Address.NO_ADDRESS) {
            return;
        }
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(address);
        if (typeMap == null) {
            typeMap = new HashMap();
            this.map.put(address, typeMap);
        }
        typeMap.put(markupType, markupItem);
    }

    public Highlight[] getHighlights(String text, Object obj, Class<? extends FieldFactory> fieldFactoryClass, int cursorTextOffset) {
        VTSession session = this.controller.getSession();
        if (session == null) {
            throw new AssertException("Oh No! Session is null!");
        }
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return new Highlight[0];
        }
        Highlight[] highlights = new Highlight[]{};
        if (fieldFactoryClass == FunctionSignatureFieldFactory.class) {
            highlights = this.getFunctionSignatureHighlights(text, obj, cursorTextOffset);
        }
        if (fieldFactoryClass == FunctionRepeatableCommentFieldFactory.class || fieldFactoryClass == EolCommentFieldFactory.class) {
            highlights = this.getRepeatableCommentHighlights(text, obj, cursorTextOffset, highlights);
        }
        if ((fieldFactoryClass == VariableTypeFieldFactory.class || fieldFactoryClass == VariableLocFieldFactory.class || fieldFactoryClass == VariableNameFieldFactory.class || fieldFactoryClass == VariableCommentFieldFactory.class) && obj instanceof Parameter) {
            highlights = this.getFunctionSignatureParameterHighlights(text, obj, cursorTextOffset);
        }
        if (fieldFactoryClass == LabelFieldFactory.class) {
            highlights = this.getMultipleLabelsHighlights(text, obj, cursorTextOffset, highlights);
        }
        if (fieldFactoryClass == EolCommentFieldFactory.class) {
            highlights = this.getEntireCommentHighlights(EolCommentMarkupType.INSTANCE, text, obj, cursorTextOffset, highlights);
        }
        if (fieldFactoryClass == PlateFieldFactory.class) {
            highlights = this.getEntireCommentHighlights(PlateCommentMarkupType.INSTANCE, text, obj, cursorTextOffset, highlights);
        }
        if (fieldFactoryClass == PreCommentFieldFactory.class) {
            highlights = this.getEntireCommentHighlights(PreCommentMarkupType.INSTANCE, text, obj, cursorTextOffset, highlights);
        }
        if (fieldFactoryClass == PostCommentFieldFactory.class) {
            highlights = this.getEntireCommentHighlights(PostCommentMarkupType.INSTANCE, text, obj, cursorTextOffset, highlights);
        }
        if (fieldFactoryClass == MnemonicFieldFactory.class) {
            highlights = this.getListingDataTypeHighlights(DataTypeMarkupType.INSTANCE, text, obj, cursorTextOffset, highlights);
        }
        ArrayList<Object> highlightList = new ArrayList<Object>();
        for (Highlight highlight : highlights) {
            highlightList.add(highlight);
        }
        highlightList.addAll(this.getListingHighlights(text, obj, fieldFactoryClass, cursorTextOffset));
        return highlightList.toArray(new Highlight[highlightList.size()]);
    }

    private Collection<? extends Highlight> getListingHighlights(String text, Object obj, Class<? extends FieldFactory> fieldFactoryClass, int cursorTextOffset) {
        if (this.listingHighlighter == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.listingHighlighter.getHighlights(text, obj, fieldFactoryClass, cursorTextOffset));
    }

    private Color getMarkupBackgroundColor(int cursorTextOffset, VTMarkupItem vtMarkupItem, int startIndex, int endIndex) {
        Color highlightColor = null;
        Address sourceAddress = vtMarkupItem.getSourceAddress();
        Address destinationAddress = vtMarkupItem.getDestinationAddress();
        VTMarkupItemStatus status = vtMarkupItem.getStatus();
        if (status == VTMarkupItemStatus.DONT_CARE) {
            highlightColor = IGNORED_MARKUP_COLOR;
        } else if (status == VTMarkupItemStatus.DONT_KNOW) {
            highlightColor = IGNORED_MARKUP_COLOR;
        } else if (status == VTMarkupItemStatus.REJECTED) {
            highlightColor = REJECTED_MARKUP_COLOR;
        } else if (status == VTMarkupItemStatus.CONFLICT) {
            highlightColor = CONFLICT_MARKUP_COLOR;
        } else if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            highlightColor = NO_ADDRESS_MARKUP_COLOR;
        } else if (status == VTMarkupItemStatus.UNAPPLIED) {
            highlightColor = UNAPPLIED_MARKUP_COLOR;
        } else if (status.isUnappliable()) {
            highlightColor = APPLIED_MARKUP_COLOR;
        } else if (status == VTMarkupItemStatus.FAILED_APPLY) {
            highlightColor = FAILED_MARKUP_COLOR;
        } else if (status == VTMarkupItemStatus.SAME) {
            highlightColor = SAME_MARKUP_COLOR;
        } else {
            return null;
        }
        if (this.currentMarkupItem != null) {
            boolean inCurrentMarkup;
            VTMarkupType currentMarkupType = this.currentMarkupItem.getMarkupType();
            VTMarkupType markupType = vtMarkupItem.getMarkupType();
            Address currentSourceAddress = this.currentMarkupItem.getSourceAddress();
            boolean bl = inCurrentMarkup = currentMarkupType == markupType && currentSourceAddress.equals((Object)sourceAddress);
            if (inCurrentMarkup) {
                highlightColor = VTDualListingHighlightProvider.shade(highlightColor, 0.85);
            }
        }
        return highlightColor;
    }

    private static Color shade(Color color, double amount) {
        if (color != null) {
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            double newR = (double)r * amount;
            double newG = (double)g * amount;
            double newB = (double)b * amount;
            return new Color((int)newR, (int)newG, (int)newB);
        }
        return null;
    }

    private Highlight[] getSpecificCommentHighlights(VTMarkupType commentType, String text, Object obj, int cursorTextOffset, Highlight[] highlights) {
        VTMarkupItem markupItem;
        CodeUnit cu = (CodeUnit)obj;
        Address minAddress = cu.getMinAddress();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(minAddress);
        if (typeMap != null && (markupItem = typeMap.get(commentType)) != null) {
            int startIndex;
            VTMarkupItemStatus status = markupItem.getStatus();
            StringStringable value = (StringStringable)(this.isSource || markupItem.canUnapply() ? markupItem.getSourceValue() : markupItem.getOriginalDestinationValue());
            String comment = value.getString();
            if (comment != null && (startIndex = text.indexOf(comment)) >= 0) {
                int endIndex = startIndex + comment.length() - 1;
                Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
                Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                highlights = new Highlight[]{highlight};
            }
        }
        return highlights;
    }

    private void getBothStringHighlights(String text, int cursorTextOffset, ArrayList<Highlight> highlightList, VTMarkupItem markupItem) {
        Highlight destinationHighlight;
        Highlight sourceHighlight;
        String destinationComment;
        StringStringable sourceValue = (StringStringable)markupItem.getSourceValue();
        StringStringable destinationValue = (StringStringable)markupItem.getCurrentDestinationValue();
        String sourceComment = sourceValue != null ? sourceValue.getString() : null;
        String string = destinationComment = destinationValue != null ? destinationValue.getString() : null;
        if (sourceComment != null && sourceComment.length() > 0 && (sourceHighlight = this.getHighlight(text, cursorTextOffset, markupItem, sourceComment)) != null) {
            highlightList.add(sourceHighlight);
        }
        if (destinationComment != null && destinationComment.length() > 0 && (destinationHighlight = this.getHighlight(text, cursorTextOffset, markupItem, destinationComment)) != null) {
            highlightList.add(destinationHighlight);
        }
    }

    private Highlight getHighlight(String text, int cursorTextOffset, VTMarkupItem markupItem, String highlightString) {
        int startIndex = text.indexOf(highlightString);
        if (startIndex >= 0) {
            int endIndex = startIndex + highlightString.length() - 1;
            Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
            return new Highlight(startIndex, endIndex, highlightColor);
        }
        return null;
    }

    private Highlight[] getEntireCommentHighlights(VTMarkupType commentType, String text, Object obj, int cursorTextOffset, Highlight[] highlights) {
        VTMarkupItem markupItem;
        CodeUnit cu = (CodeUnit)obj;
        Address minAddress = cu.getMinAddress();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(minAddress);
        if (typeMap != null && (markupItem = typeMap.get(commentType)) != null) {
            int startIndex = 0;
            int endIndex = text.length() - 1;
            Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
            Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
            highlights = new Highlight[]{highlight};
        }
        return highlights;
    }

    private Highlight[] getRepeatableCommentHighlights(String text, Object obj, int cursorTextOffset, Highlight[] highlights) {
        VTMarkupItem markupItem;
        Address address = null;
        if (obj instanceof Function) {
            Function function = (Function)obj;
            address = function.getEntryPoint();
        } else if (obj instanceof CodeUnit) {
            CodeUnit codeUnit = (CodeUnit)obj;
            address = codeUnit.getMinAddress();
        }
        ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(address);
        if (typeMap != null && (markupItem = typeMap.get(RepeatableCommentMarkupType.INSTANCE)) != null) {
            this.getBothStringHighlights(text, cursorTextOffset, highlightList, markupItem);
        }
        return highlightList.toArray(new Highlight[highlightList.size()]);
    }

    private Highlight[] getFunctionSignatureHighlights(String text, Object obj, int cursorTextOffset) {
        Function function = null;
        if (obj instanceof Function) {
            function = (Function)obj;
        } else if (obj instanceof Variable) {
            Variable variable = (Variable)obj;
            function = variable.getFunction();
        } else {
            Msg.error((Object)this, (Object)("Can't get highlights for a " + obj.getClass().getName()));
            return new Highlight[0];
        }
        Address address = function.getEntryPoint();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(address);
        if (typeMap != null) {
            ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
            this.addFunctionNameHighlight(text, cursorTextOffset, typeMap, highlightList);
            this.addFunctionSignatureHighlight(text, cursorTextOffset, typeMap, highlightList);
            return highlightList.toArray(new Highlight[highlightList.size()]);
        }
        return new Highlight[0];
    }

    private Highlight[] getFunctionSignatureParameterHighlights(String text, Object obj, int cursorTextOffset) {
        if (!(obj instanceof Parameter)) {
            Msg.error((Object)this, (Object)("Can't get highlights for a " + obj.getClass().getName()));
            return new Highlight[0];
        }
        Parameter parameter = (Parameter)obj;
        Function function = parameter.getFunction();
        Address address = function.getEntryPoint();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(address);
        if (typeMap != null) {
            ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
            VTMarkupItem markupItem = typeMap.get(FunctionSignatureMarkupType.INSTANCE);
            if (markupItem == null) {
                return new Highlight[0];
            }
            Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, 0, text.length() - 1);
            Highlight highlight = new Highlight(0, text.length() - 1, highlightColor);
            highlightList.add(highlight);
            return highlightList.toArray(new Highlight[highlightList.size()]);
        }
        return new Highlight[0];
    }

    private void addFunctionHighlight(VTMarkupType markupType, String text, int cursorTextOffset, HashMap<VTMarkupType, VTMarkupItem> typeMap, ArrayList<Highlight> highlightList) {
        VTMarkupItem markupItem = typeMap.get(markupType);
        if (markupItem != null) {
            String displayString;
            int startIndex;
            Stringable value;
            Stringable stringable = value = this.isSource || markupItem.canUnapply() ? markupItem.getSourceValue() : markupItem.getOriginalDestinationValue();
            if (value != null && (startIndex = text.indexOf(displayString = value.getDisplayString())) >= 0) {
                int endIndex = startIndex + displayString.length() - 1;
                Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
                Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                highlightList.add(highlight);
            }
        }
    }

    private void addFunctionNameHighlight(String text, int cursorTextOffset, HashMap<VTMarkupType, VTMarkupItem> typeMap, ArrayList<Highlight> highlightList) {
        VTMarkupItem markupItem = typeMap.get(FunctionNameMarkupType.INSTANCE);
        if (markupItem != null) {
            FunctionNameStringable value;
            FunctionNameStringable functionNameStringable = value = this.isSource || markupItem.canUnapply() ? (FunctionNameStringable)markupItem.getSourceValue() : (FunctionNameStringable)markupItem.getOriginalDestinationValue();
            if (value != null) {
                String name;
                int startIndex;
                int parameterStart = text.indexOf("(");
                if (parameterStart < 0) {
                    parameterStart = text.length();
                }
                if ((startIndex = text.lastIndexOf(name = value.getSymbolName(), parameterStart - 1)) >= 0) {
                    int endIndex = startIndex + name.length() - 1;
                    Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
                    Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                    highlightList.add(highlight);
                }
            }
        }
    }

    private void addFunctionSignatureHighlight(String text, int cursorTextOffset, HashMap<VTMarkupType, VTMarkupItem> typeMap, ArrayList<Highlight> highlightList) {
        VTMarkupItem markupItem = typeMap.get(FunctionSignatureMarkupType.INSTANCE);
        if (markupItem != null) {
            int beforeNameIndex;
            int textLength = text.length();
            int leftParenIndex = text.indexOf("(");
            int rightParenIndex = text.indexOf(")");
            int startReturnIndex = 0;
            int endCallingConventionIndex = textLength - 1;
            if (leftParenIndex >= 0 && (beforeNameIndex = this.getLastIndexOf(text, leftParenIndex - 1, ' ')) >= 0) {
                endCallingConventionIndex = beforeNameIndex - 1;
            }
            if (startReturnIndex >= 0 && endCallingConventionIndex >= 0) {
                Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startReturnIndex, endCallingConventionIndex);
                Highlight highlight = new Highlight(startReturnIndex, endCallingConventionIndex, highlightColor);
                highlightList.add(highlight);
            }
            if (leftParenIndex == -1) {
                return;
            }
            int startParamsIndex = leftParenIndex + 1;
            if (startParamsIndex >= textLength) {
                return;
            }
            int endParamsIndex = textLength;
            if (rightParenIndex >= 0) {
                endParamsIndex = rightParenIndex - 1;
            }
            if (endParamsIndex <= startParamsIndex) {
                return;
            }
            Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startParamsIndex, endParamsIndex);
            Highlight highlight = new Highlight(startParamsIndex, endParamsIndex, highlightColor);
            highlightList.add(highlight);
        }
    }

    private int getLastIndexOf(String text, int backwardsIndex, char c) {
        for (int i = backwardsIndex; i >= 0; --i) {
            if (c != text.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    private Highlight[] getVariableHighlights(String text, Object obj, int cursorTextOffset, VTMarkupType markupType) {
        VTMarkupItem markupItem;
        Variable variable = (Variable)obj;
        Address storageAddress = variable.getMinAddress();
        if (storageAddress == null) {
            return new Highlight[0];
        }
        ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(storageAddress);
        if (typeMap != null && (markupItem = typeMap.get(markupType)) != null && this.isCorrectFunction(variable, markupItem)) {
            if (variable instanceof Parameter) {
                this.addParametersHighlight(text, cursorTextOffset, markupItem, highlightList);
            } else {
                this.addLocalVariablesHighlight(text, cursorTextOffset, markupItem, highlightList);
            }
        }
        return highlightList.toArray(new Highlight[highlightList.size()]);
    }

    private boolean isCorrectFunction(Variable variable, VTMarkupItem markupItem) {
        Function function = variable.getFunction();
        Address variableFunctionAddress = function.getEntryPoint();
        Program program = function.getProgram();
        VTAssociation association = markupItem.getAssociation();
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Program destinationProgram = session.getDestinationProgram();
        if (program == sourceProgram) {
            Address markupFunctionAddress = association.getSourceAddress();
            if (!variableFunctionAddress.equals((Object)markupFunctionAddress)) {
                return false;
            }
        } else if (program == destinationProgram) {
            Address markupFunctionAddress = association.getDestinationAddress();
            if (!variableFunctionAddress.equals((Object)markupFunctionAddress)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void addParametersHighlight(String text, int cursorTextOffset, VTMarkupItem parameterMarkupItem, ArrayList<Highlight> highlightList) {
        if (parameterMarkupItem != null) {
            int startIndex = 0;
            int endIndex = text.length() - 1;
            if (endIndex >= 0) {
                Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, parameterMarkupItem, startIndex, endIndex);
                Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                highlightList.add(highlight);
            }
        }
    }

    private void addLocalVariablesHighlight(String text, int cursorTextOffset, VTMarkupItem localVariableMarkupItem, ArrayList<Highlight> highlightList) {
        if (localVariableMarkupItem != null) {
            int startIndex = 0;
            int endIndex = text.length() - 1;
            if (endIndex >= 0) {
                Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, localVariableMarkupItem, startIndex, endIndex);
                Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                highlightList.add(highlight);
            }
        }
    }

    private Highlight[] getMultipleLabelsHighlights(String text, Object obj, int cursorTextOffset, Highlight[] highlights) {
        VTMarkupItem markupItem;
        CodeUnit cu = (CodeUnit)obj;
        Address minAddress = cu.getMinAddress();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(minAddress);
        if (typeMap != null && (markupItem = typeMap.get(LabelMarkupType.INSTANCE)) != null) {
            ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
            MultipleSymbolStringable value = (MultipleSymbolStringable)(this.isSource || markupItem.canUnapply() ? markupItem.getSourceValue() : markupItem.getOriginalDestinationValue());
            if (value != null) {
                int startIndex = 0;
                int endIndex = text.length() - 1;
                Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
                Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                highlightList.add(highlight);
                return highlightList.toArray(new Highlight[highlightList.size()]);
            }
        }
        return new Highlight[0];
    }

    private Highlight[] getListingDataTypeHighlights(VTMarkupType markupType, String text, Object obj, int cursorTextOffset, Highlight[] highlights) {
        VTMarkupItem markupItem;
        CodeUnit cu = (CodeUnit)obj;
        Address minAddress = cu.getMinAddress();
        HashMap<VTMarkupType, VTMarkupItem> typeMap = this.map.get(minAddress);
        if (typeMap != null && (markupItem = typeMap.get(DataTypeMarkupType.INSTANCE)) != null) {
            ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
            DataTypeStringable value = (DataTypeStringable)(this.isSource || markupItem.canUnapply() ? markupItem.getSourceValue() : markupItem.getOriginalDestinationValue());
            if (value != null) {
                Program sourceProgram = markupType.getSourceProgram(markupItem.getAssociation());
                DataTypeManager sourceDTM = sourceProgram.getDataTypeManager();
                Program destinationProgram = markupType.getDestinationProgram(markupItem.getAssociation());
                DataTypeManager destinationDTM = destinationProgram.getDataTypeManager();
                DataTypeManager dataTypeManager = this.isSource || markupItem.canUnapply() ? sourceDTM : destinationDTM;
                DataType dataType = value.getDataType(dataTypeManager);
                String mnemonic = dataType.getMnemonic(dataType.getDefaultSettings());
                if (text != null) {
                    int startIndex = text.indexOf(mnemonic);
                    int endIndex = startIndex + mnemonic.length() - 1;
                    Color highlightColor = this.getMarkupBackgroundColor(cursorTextOffset, markupItem, startIndex, endIndex);
                    Highlight highlight = new Highlight(startIndex, endIndex, highlightColor);
                    highlightList.add(highlight);
                }
            }
            return highlightList.toArray(new Highlight[highlightList.size()]);
        }
        return new Highlight[0];
    }

    public void setMarkupItem(VTMarkupItem markupItem) {
        if (markupItem == this.currentMarkupItem) {
            return;
        }
        this.currentMarkupItem = markupItem;
        this.updateMarkup();
    }

    public VTMarkupItem getMarkupItem() {
        return this.currentMarkupItem;
    }

    public boolean isSource() {
        return this.isSource;
    }
}

