/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.gui.actions.AbstractCreateManualMatchAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.functionassociation.FunctionAssociationContext;
import ghidra.feature.vt.gui.task.CreateAndAcceptApplyManualMatchTask;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import javax.swing.Icon;
import resources.ResourceManager;

public class CreateManualMatchAndAcceptAction
extends AbstractCreateManualMatchAction {
    public static final Icon ICON = ResourceManager.loadImage((String)"images/flag.png");

    public CreateManualMatchAndAcceptAction(VTController controller) {
        super("Create And Accept Manual Match", VTPlugin.OWNER, controller);
        this.setToolBarData(new ToolBarData(ICON, "Create"));
        this.setPopupMenuData(new MenuData(new String[]{"Create And Accept Manual Match"}, ICON));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Create_And_Accept_Manual_Match"));
    }

    public void actionPerformed(ActionContext context) {
        FunctionAssociationContext providerContext = (FunctionAssociationContext)context;
        Function sourceFunction = providerContext.getSelectedSourceFunction();
        Function destinationFunction = providerContext.getSelectionDestinationFunction();
        final CreateAndAcceptApplyManualMatchTask createTask = new CreateAndAcceptApplyManualMatchTask(this.controller, sourceFunction, destinationFunction, false);
        createTask.addTaskListener(new TaskListener(){

            public void taskCompleted(Task task) {
                CreateManualMatchAndAcceptAction.this.controller.setSelectedMatch(createTask.getNewMatch());
            }

            public void taskCancelled(Task task) {
            }
        });
        this.controller.runVTTask(createTask);
    }
}

