/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.tools.java_version_checker.JavaVersion;
import org.elasticsearch.tools.launchers.JvmErgonomics;
import org.elasticsearch.tools.launchers.Launchers;
import org.elasticsearch.tools.launchers.SystemJvmOptions;

final class JvmOptionsParser {
    private static final Pattern PATTERN = Pattern.compile("((?<start>\\d+)(?<range>-)?(?<end>\\d+)?:)?(?<option>-.*)$");

    JvmOptionsParser() {
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length != 1) {
            throw new IllegalArgumentException("expected one argument specifying path to jvm.options but was " + Arrays.toString(args));
        }
        final ArrayList<String> jvmOptions = new ArrayList<String>();
        final TreeMap invalidLines = new TreeMap();
        try (InputStream is = Files.newInputStream(Paths.get(args[0], new String[0]), new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            JvmOptionsParser.parse(JavaVersion.majorVersion((List)JavaVersion.CURRENT), br, new JvmOptionConsumer(){

                @Override
                public void accept(String jvmOption) {
                    jvmOptions.add(jvmOption);
                }
            }, new InvalidLineConsumer(){

                @Override
                public void accept(int lineNumber, String line) {
                    invalidLines.put(lineNumber, line);
                }
            });
        }
        if (invalidLines.isEmpty()) {
            String environmentJvmOptions = System.getenv("ES_JAVA_OPTS");
            if (environmentJvmOptions != null) {
                jvmOptions.addAll(Arrays.stream(environmentJvmOptions.split("\\s+")).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList()));
            }
            HashMap<String, String> substitutions = new HashMap<String, String>();
            substitutions.put("ES_TMPDIR", System.getenv("ES_TMPDIR"));
            if (null != System.getenv("ES_PATH_CONF")) {
                substitutions.put("ES_PATH_CONF", System.getenv("ES_PATH_CONF"));
            }
            List<String> substitutedJvmOptions = JvmOptionsParser.substitutePlaceholders(jvmOptions, Collections.unmodifiableMap(substitutions));
            List<String> ergonomicJvmOptions = JvmErgonomics.choose(substitutedJvmOptions);
            List<String> systemJvmOptions = SystemJvmOptions.systemJvmOptions();
            ArrayList<String> finalJvmOptions = new ArrayList<String>(systemJvmOptions.size() + substitutedJvmOptions.size() + ergonomicJvmOptions.size());
            finalJvmOptions.addAll(systemJvmOptions);
            finalJvmOptions.addAll(substitutedJvmOptions);
            finalJvmOptions.addAll(ergonomicJvmOptions);
            String spaceDelimitedJvmOptions = JvmOptionsParser.spaceDelimitJvmOptions(finalJvmOptions);
            Launchers.outPrintln(spaceDelimitedJvmOptions);
            Launchers.exit(0);
        } else {
            String errorMessage = String.format(Locale.ROOT, "encountered [%d] error%s parsing [%s]", invalidLines.size(), invalidLines.size() == 1 ? "" : "s", args[0]);
            Launchers.errPrintln(errorMessage);
            int count = 0;
            for (Map.Entry entry : invalidLines.entrySet()) {
                String message = String.format(Locale.ROOT, "[%d]: encountered improperly formatted JVM option line [%s] on line number [%d]", ++count, entry.getValue(), entry.getKey());
                Launchers.errPrintln(message);
            }
            Launchers.exit(1);
        }
    }

    static List<String> substitutePlaceholders(List<String> jvmOptions, Map<String, String> substitutions) {
        Map<String, String> placeholderSubstitutions = substitutions.entrySet().stream().collect(Collectors.toMap(e -> "${" + (String)e.getKey() + "}", Map.Entry::getValue));
        return jvmOptions.stream().map(jvmOption -> {
            String actualJvmOption = jvmOption;
            int start = jvmOption.indexOf("${");
            if (start >= 0 && jvmOption.indexOf(125, start) > 0) {
                for (Map.Entry placeholderSubstitution : placeholderSubstitutions.entrySet()) {
                    actualJvmOption = actualJvmOption.replace((CharSequence)placeholderSubstitution.getKey(), (CharSequence)placeholderSubstitution.getValue());
                }
            }
            return actualJvmOption;
        }).collect(Collectors.toList());
    }

    static void parse(int javaMajorVersion, BufferedReader br, JvmOptionConsumer jvmOptionConsumer, InvalidLineConsumer invalidLineConsumer) throws IOException {
        int lineNumber = 0;
        while (true) {
            String line = br.readLine();
            ++lineNumber;
            if (line == null) break;
            if (line.startsWith("#") || line.matches("\\s*")) continue;
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                int upper;
                int lower;
                String start = matcher.group("start");
                String end = matcher.group("end");
                if (start == null) {
                    jvmOptionConsumer.accept(line);
                    continue;
                }
                try {
                    lower = Integer.parseInt(start);
                }
                catch (NumberFormatException e) {
                    invalidLineConsumer.accept(lineNumber, line);
                    continue;
                }
                if (matcher.group("range") == null) {
                    upper = lower;
                } else if (end == null) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(end);
                    }
                    catch (NumberFormatException e) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                    if (upper < lower) {
                        invalidLineConsumer.accept(lineNumber, line);
                        continue;
                    }
                }
                if (lower > javaMajorVersion || javaMajorVersion > upper) continue;
                jvmOptionConsumer.accept(matcher.group("option"));
                continue;
            }
            invalidLineConsumer.accept(lineNumber, line);
        }
    }

    static String spaceDelimitJvmOptions(List<String> jvmOptions) {
        StringBuilder spaceDelimitedJvmOptionsBuilder = new StringBuilder();
        Iterator<String> it = jvmOptions.iterator();
        while (it.hasNext()) {
            spaceDelimitedJvmOptionsBuilder.append(it.next());
            if (!it.hasNext()) continue;
            spaceDelimitedJvmOptionsBuilder.append(" ");
        }
        return spaceDelimitedJvmOptionsBuilder.toString();
    }

    static interface JvmOptionConsumer {
        public void accept(String var1);
    }

    static interface InvalidLineConsumer {
        public void accept(int var1, String var2);
    }
}

