/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.io.FileInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;

public class ResolverLocalFilesystem
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)ResolverLocalFilesystem.class.getName());
    private static int FILE_URI_LENGTH = "file:/".length();

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        try {
            URI uRI = ResolverLocalFilesystem.getNewURI(attr.getNodeValue(), string);
            URI uRI2 = new URI(uRI);
            uRI2.setFragment(null);
            String string2 = ResolverLocalFilesystem.translateUriToFilename(uRI2.toString());
            FileInputStream fileInputStream = new FileInputStream(string2);
            XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(fileInputStream);
            xMLSignatureInput.setSourceURI(uRI.toString());
            return xMLSignatureInput;
        }
        catch (Exception exception) {
            throw new ResourceResolverException("generic.EmptyMessage", exception, attr, string);
        }
    }

    private static String translateUriToFilename(String string) {
        String string2 = string.substring(FILE_URI_LENGTH);
        if (string2.indexOf("%20") > -1) {
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            do {
                if ((n2 = string2.indexOf("%20", n)) == -1) {
                    stringBuffer.append(string2.substring(n));
                    continue;
                }
                stringBuffer.append(string2.substring(n, n2));
                stringBuffer.append(' ');
                n = n2 + 3;
            } while (n2 != -1);
            string2 = stringBuffer.toString();
        }
        if (string2.charAt(1) == ':') {
            return string2;
        }
        return "/" + string2;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            return false;
        }
        String string2 = attr.getNodeValue();
        if (string2.equals("") || string2.charAt(0) == '#' || string2.startsWith("http:")) {
            return false;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I was asked whether I can resolve " + string2));
            }
            if (string2.startsWith("file:") || string.startsWith("file:")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("I state that I can resolve " + string2));
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug((Object)"But I can't");
        return false;
    }

    private static URI getNewURI(String string, String string2) throws URI.MalformedURIException {
        if (string2 == null || "".equals(string2)) {
            return new URI(string);
        }
        return new URI(new URI(string2), string);
    }
}

