/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.EbsVolumeDescription;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstanceBlockDeviceMappingDescription {
    private static final Pattern BLOCK_DEVICE_MAPPING_PATTERN = Pattern.compile("^(.*?)=(.*?)(?:\\:(.*?))?");
    private final String deviceName;
    private final BlockDeviceMappingDescription.Type type;
    private final String virtualName;
    private final EbsVolumeDescription volume;

    public static InstanceBlockDeviceMappingDescription valueOf(String blockDeviceMapping) throws Exception {
        Matcher matcher = BLOCK_DEVICE_MAPPING_PATTERN.matcher(blockDeviceMapping);
        if (!matcher.matches()) {
            throw new Exception("Invalid format; no match found.");
        }
        String deviceName = matcher.group(1).trim();
        String virtualName = matcher.group(2).trim();
        if (virtualName.equalsIgnoreCase("none")) {
            return new InstanceBlockDeviceMappingDescription(deviceName, BlockDeviceMappingDescription.Type.NO_DEVICE);
        }
        if (virtualName.length() == 0 || virtualName.toLowerCase().startsWith("vol")) {
            String volumeId = null;
            if (matcher.group(2) != null && matcher.group(2).length() > 0) {
                volumeId = matcher.group(2);
            }
            Boolean deleteOnTermination = null;
            if (matcher.group(3) != null && matcher.group(3).length() > 0) {
                deleteOnTermination = Boolean.valueOf(matcher.group(3));
            }
            return new InstanceBlockDeviceMappingDescription(deviceName, BlockDeviceMappingDescription.Type.EBS, virtualName, new EbsVolumeDescription(volumeId, deleteOnTermination, null, null, null, null));
        }
        return new InstanceBlockDeviceMappingDescription(deviceName, BlockDeviceMappingDescription.Type.EPHEMERAL, virtualName);
    }

    public InstanceBlockDeviceMappingDescription(String deviceName, BlockDeviceMappingDescription.Type type) {
        this(deviceName, type, null, null);
    }

    public InstanceBlockDeviceMappingDescription(String deviceName, BlockDeviceMappingDescription.Type type, String virtualName) {
        this(deviceName, type, virtualName, null);
    }

    public InstanceBlockDeviceMappingDescription(String deviceName, BlockDeviceMappingDescription.Type type, EbsVolumeDescription volume) {
        this(deviceName, type, null, volume);
    }

    public InstanceBlockDeviceMappingDescription(String deviceName, BlockDeviceMappingDescription.Type type, String virtualName, EbsVolumeDescription volume) {
        this.deviceName = deviceName;
        this.type = type;
        this.virtualName = virtualName;
        this.volume = volume;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public BlockDeviceMappingDescription.Type getType() {
        return this.type;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    public EbsVolumeDescription getVolume() {
        return this.volume;
    }
}

