/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.StringUtils;

public class MergeMessageFormatter {
    public String format(List<Ref> refsToMerge, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Merge ");
        ArrayList<String> branches = new ArrayList<String>();
        ArrayList<String> remoteBranches = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> commits = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        for (Ref ref2 : refsToMerge) {
            if (ref2.getName().startsWith("refs/heads/")) {
                branches.add("'" + Repository.shortenRefName(ref2.getName()) + "'");
                continue;
            }
            if (ref2.getName().startsWith("refs/remotes/")) {
                remoteBranches.add("'" + Repository.shortenRefName(ref2.getName()) + "'");
                continue;
            }
            if (ref2.getName().startsWith("refs/tags/")) {
                tags.add("'" + Repository.shortenRefName(ref2.getName()) + "'");
                continue;
            }
            ObjectId objectId = ref2.getObjectId();
            if (objectId != null && ref2.getName().equals(objectId.getName())) {
                commits.add("'" + ref2.getName() + "'");
                continue;
            }
            others.add(ref2.getName());
        }
        ArrayList<String> listings = new ArrayList<String>();
        if (!branches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(branches, "branch", "branches"));
        }
        if (!remoteBranches.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(remoteBranches, "remote-tracking branch", "remote-tracking branches"));
        }
        if (!tags.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(tags, "tag", "tags"));
        }
        if (!commits.isEmpty()) {
            listings.add(MergeMessageFormatter.joinNames(commits, "commit", "commits"));
        }
        if (!others.isEmpty()) {
            listings.add(StringUtils.join(others, ", ", " and "));
        }
        sb.append(StringUtils.join(listings, ", "));
        String targetName = target.getLeaf().getName();
        if (!targetName.equals("refs/heads/master")) {
            String targetShortName = Repository.shortenRefName(targetName);
            sb.append(" into " + targetShortName);
        }
        return sb.toString();
    }

    public String formatWithConflicts(String message, List<String> conflictingPaths) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] lines = message.split("\n");
        int firstFooterLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        for (i = 0; i < firstFooterLine; ++i) {
            sb.append(lines[i]).append('\n');
        }
        if (firstFooterLine == lines.length && message.length() != 0) {
            sb.append('\n');
        }
        MergeMessageFormatter.addConflictsMessage(conflictingPaths, sb);
        if (firstFooterLine < lines.length) {
            sb.append('\n');
        }
        for (i = firstFooterLine; i < lines.length; ++i) {
            sb.append(lines[i]).append('\n');
        }
        return sb.toString();
    }

    private static void addConflictsMessage(List<String> conflictingPaths, StringBuilder sb) {
        sb.append("Conflicts:\n");
        for (String conflictingPath : conflictingPaths) {
            sb.append('\t').append(conflictingPath).append('\n');
        }
    }

    private static String joinNames(List<String> names, String singular, String plural) {
        if (names.size() == 1) {
            return singular + " " + names.get(0);
        }
        return plural + " " + StringUtils.join(names, ", ", " and ");
    }
}

