/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactRepositoryLayout.class, hint="default")
public class DefaultRepositoryLayout
implements ArtifactRepositoryLayout {
    private static final char PATH_SEPARATOR = '/';
    private static final char GROUP_SEPARATOR = '.';
    private static final char ARTIFACT_SEPARATOR = '-';

    @Override
    public String getId() {
        return "default";
    }

    @Override
    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder path2 = new StringBuilder(128);
        path2.append(this.formatAsDirectory(artifact.getGroupId())).append('/');
        path2.append(artifact.getArtifactId()).append('/');
        path2.append(artifact.getBaseVersion()).append('/');
        path2.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path2.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path2.append('.').append(artifactHandler.getExtension());
        }
        return path2.toString();
    }

    @Override
    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata, metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(ArtifactMetadata metadata, String filename) {
        StringBuilder path2 = new StringBuilder(128);
        path2.append(this.formatAsDirectory(metadata.getGroupId())).append('/');
        if (!metadata.storedInGroupDirectory()) {
            path2.append(metadata.getArtifactId()).append('/');
            if (metadata.storedInArtifactVersionDirectory()) {
                path2.append(metadata.getBaseVersion()).append('/');
            }
        }
        path2.append(filename);
        return path2.toString();
    }

    @Override
    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata, metadata.getRemoteFilename());
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }

    public String toString() {
        return this.getId();
    }
}

