/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.session;

import ca.sqlpower.dao.session.BidirectionalConverter;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.apache.commons.beanutils.ConversionException;

public class FormatConverter
implements BidirectionalConverter<String, Format> {
    @Override
    public Format convertToComplexType(String convertFrom) throws ConversionException {
        int firstSeparator = convertFrom.indexOf(",");
        if (firstSeparator == -1) {
            throw new IllegalArgumentException("Cannot find the class type for the string " + convertFrom);
        }
        String className = convertFrom.substring(0, firstSeparator);
        String pattern = convertFrom.substring(firstSeparator + 1);
        if (className.equals(DecimalFormat.class.getSimpleName())) {
            return new DecimalFormat(pattern);
        }
        if (className.equals(SimpleDateFormat.class.getSimpleName())) {
            return new SimpleDateFormat(pattern);
        }
        throw new IllegalStateException("Unknown class " + className + " to create a format on based on the pattern " + pattern);
    }

    @Override
    public String convertToSimpleType(Format convertFrom, Object ... additionalInfo) {
        if (convertFrom instanceof DecimalFormat) {
            DecimalFormat decimal = (DecimalFormat)convertFrom;
            return DecimalFormat.class.getSimpleName() + "," + decimal.toPattern();
        }
        if (convertFrom instanceof SimpleDateFormat) {
            SimpleDateFormat date = (SimpleDateFormat)convertFrom;
            return SimpleDateFormat.class.getSimpleName() + "," + date.toPattern();
        }
        throw new IllegalStateException("Unknown format to convert from " + convertFrom.getClass());
    }
}

