/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddExportServlet
extends HttpServlet {
    public static final String PARAMETER_LOAD = "load";
    public static final String PARAMETER_TYPE = "type";
    public static final String TYPE_JOB = "job";
    public static final String TYPE_TRANS = "trans";
    private static final long serialVersionUID = -6850701762586992604L;
    private static LogWriter log = LogWriter.getInstance();
    public static final String CONTEXT_PATH = "/kettle/addExport";
    private JobMap jobMap;
    private TransformationMap transformationMap;

    public AddExportServlet(JobMap jobMap, TransformationMap transformationMap) {
        this.jobMap = jobMap;
        this.transformationMap = transformationMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getRequestURI().equals("/kettle/addExport/")) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), "Addition of export requested", new Object[0]);
        }
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "Encoding: " + request.getCharacterEncoding(), new Object[0]);
        }
        boolean isJob = TYPE_JOB.equalsIgnoreCase(request.getParameter(PARAMETER_TYPE));
        String load = request.getParameter(PARAMETER_LOAD);
        response.setContentType("text/xml");
        out.print(XMLHandler.getXMLHeader());
        response.setStatus(200);
        OutputStream outputStream = null;
        try {
            try {
                int c;
                FileObject tempFile = KettleVFS.createTempFile((String)"export", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
                outputStream = KettleVFS.getOutputStream((FileObject)tempFile, (boolean)false);
                int size = 0;
                while ((c = in.read()) != -1) {
                    outputStream.write(c);
                    ++size;
                }
                outputStream.flush();
                outputStream.close();
                outputStream = null;
                String archiveUrl = tempFile.getName().toString();
                String fileUrl = null;
                if (!Const.isEmpty((String)load)) {
                    fileUrl = "zip:" + archiveUrl + "!" + load;
                    if (isJob) {
                        KettleVFS.getFileObject((String)fileUrl);
                        JobMeta jobMeta = new JobMeta(log, fileUrl, null);
                        Job job = new Job(log, null, jobMeta);
                        String configUrl = "zip:" + archiveUrl + "!" + "__job_execution_configuration__.xml";
                        Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
                        JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration(XMLHandler.getSubNode((Node)configDoc, (String)"job_execution_configuration"));
                        this.jobMap.addJob(job.getJobname(), job, new JobConfiguration(jobMeta, jobExecutionConfiguration));
                        log.setLogLevel(jobExecutionConfiguration.getLogLevel());
                        jobMeta.setArguments(jobExecutionConfiguration.getArgumentStrings());
                        jobMeta.injectVariables(jobExecutionConfiguration.getVariables());
                        Map<String, String> params = jobExecutionConfiguration.getParams();
                        for (String param : params.keySet()) {
                            String value = params.get(param);
                            jobMeta.setParameterValue(param, value);
                        }
                    } else {
                        TransMeta transMeta = new TransMeta(fileUrl);
                        Trans trans = new Trans(transMeta);
                        String configUrl = "zip:" + archiveUrl + "!" + "__job_execution_configuration__.xml";
                        Document configDoc = XMLHandler.loadXMLFile((String)configUrl);
                        TransExecutionConfiguration executionConfiguration = new TransExecutionConfiguration(XMLHandler.getSubNode((Node)configDoc, (String)"transformation_execution_configuration"));
                        this.transformationMap.addTransformation(trans.getName(), trans, new TransConfiguration(transMeta, executionConfiguration));
                    }
                } else {
                    fileUrl = archiveUrl;
                }
                out.println(new WebResult("OK", fileUrl));
            }
            catch (Exception ex) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
                Object var23_29 = null;
                if (outputStream == null) return;
                outputStream.close();
                return;
            }
            Object var23_28 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var23_30 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public String toString() {
        return "Add export";
    }
}

