/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

class CodeTemplate
implements Comparable {
    private char[] id;
    private String beforeCaret;
    private String afterCaret;
    private boolean containsNewline;
    private Matcher matcher;

    CodeTemplate(CodeTemplate codeTemplate) {
        int n = codeTemplate.id.length;
        this.id = new char[n];
        System.arraycopy(codeTemplate.id, 0, this.id, 0, n);
        this.setBeforeCaretText(codeTemplate.getBeforeCaretText());
        this.setAfterCaretText(codeTemplate.getAfterCaretText());
    }

    public CodeTemplate(String string, String string2, String string3) {
        this.id = string.toCharArray();
        this.setBeforeCaretText(string2);
        this.setAfterCaretText(string3);
    }

    public int compareTo(Object object) {
        int n = this.id.length;
        CodeTemplate codeTemplate = (CodeTemplate)object;
        char[] cArray = codeTemplate.getID();
        int n2 = cArray.length;
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = this.id[n4];
            if (c2 == (c = cArray[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public boolean containsNewline() {
        return this.containsNewline;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public String getAfterCaretText() {
        return this.afterCaret;
    }

    public String getBeforeCaretText() {
        return this.beforeCaret;
    }

    public String getContentToInsert(String string) {
        if (this.containsNewline()) {
            return this.matcher.replaceAll("\n" + string);
        }
        return this.beforeCaret + this.afterCaret;
    }

    public char[] getID() {
        return this.id;
    }

    public static final boolean isValidChar(char c) {
        return RSyntaxUtilities.isLetterOrDigit(c) || c == '_';
    }

    public void setAfterCaretText(String string) {
        this.afterCaret = string;
        this.updateContainsNewline();
        this.updateCachedRegex();
    }

    public void setBeforeCaretText(String string) {
        this.beforeCaret = string;
        this.updateContainsNewline();
        this.updateCachedRegex();
    }

    public String toString() {
        return "[CodeTemplate: id=" + new String(this.id) + ", text=" + this.beforeCaret + "|" + this.afterCaret + "]";
    }

    private final void updateCachedRegex() {
        this.matcher = Pattern.compile("\n").matcher(this.getBeforeCaretText() + this.getAfterCaretText());
    }

    private final void updateContainsNewline() {
        this.containsNewline = false;
        if (this.beforeCaret != null && this.beforeCaret.indexOf(10) > -1) {
            this.containsNewline = true;
        }
        if (!this.containsNewline && this.afterCaret != null && this.afterCaret.indexOf(10) > -1) {
            this.containsNewline = true;
        }
    }
}

