/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.SQLObjectComboBoxModel;
import ca.sqlpower.architect.swingui.olap.OLAPObjectNameValidator;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.table.EditableJTable;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.validation.Status;
import ca.sqlpower.validation.ValidateResult;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.NotNullValidator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class LevelEditPanel
implements ValidatableDataEntryPanel {
    private final MondrianModel.Level level;
    private final JPanel panel;
    private JTextField name;
    private JTextField captionField;
    private JComboBox columnChooser;
    private JCheckBox uniqueMembers;
    private JComboBox levelType;
    private PropertiesEditPanel propertiesPanel;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public LevelEditPanel(MondrianModel.Level level) throws SQLObjectException {
        SQLTable dimensionTable;
        this.level = level;
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.name = new JTextField(level.getName());
        builder.append("Name", (Component)this.name);
        this.captionField = new JTextField(level.getCaption());
        builder.append("Caption", (Component)this.captionField);
        this.columnChooser = new JComboBox();
        builder.append("Column", this.columnChooser);
        if (level.getUniqueMembers() != null) {
            this.uniqueMembers = new JCheckBox("", (boolean)level.getUniqueMembers());
            builder.append("Unique Members", (Component)this.uniqueMembers);
        } else {
            this.uniqueMembers = new JCheckBox("");
            builder.append("Unique Members", (Component)this.uniqueMembers);
        }
        MondrianModel.Hierarchy hierarchy = (MondrianModel.Hierarchy)level.getParent();
        MondrianModel.Dimension dimension = (MondrianModel.Dimension)hierarchy.getParent();
        if (dimension.getType() != null && dimension.getType().equals("TimeDimension")) {
            this.levelType = new JComboBox<LevelType>(LevelType.values());
            builder.append("Level Type", this.levelType);
            if (level.getLevelType() != null) {
                this.levelType.setSelectedItem((Object)LevelType.valueOf(level.getLevelType()));
            } else {
                this.levelType.setSelectedItem((Object)LevelType.values()[0]);
            }
        }
        if ((dimensionTable = OLAPUtil.tableForHierarchy(hierarchy)) == null) {
            OLAPSession oSession = OLAPUtil.getSession(level);
            MondrianModel.Schema sch = oSession.getSchema();
            String parentDimName = hierarchy.getParent().getName();
            boolean valid = true;
            MondrianModel.Table fact = null;
            String foreignKey = null;
            block0: for (int i = 0; i < sch.getCubes().size() && valid; ++i) {
                MondrianModel.Cube c = sch.getCubes().get(i);
                if (c.getFact() == null) continue;
                for (MondrianModel.CubeDimension cd : c.getDimensions()) {
                    MondrianModel.DimensionUsage du;
                    if (!(cd instanceof MondrianModel.DimensionUsage) || !(du = (MondrianModel.DimensionUsage)cd).getSource().equalsIgnoreCase(parentDimName)) continue;
                    MondrianModel.Table rel = (MondrianModel.Table)c.getFact();
                    String fk = du.getForeignKey();
                    if (fk == null) continue block0;
                    if (fact == null && foreignKey == null) {
                        fact = rel;
                        foreignKey = fk;
                        continue block0;
                    }
                    if (fact.getSchema().equalsIgnoreCase(rel.getSchema()) && fact.getName().equalsIgnoreCase(rel.getName()) && foreignKey.equalsIgnoreCase(fk)) continue block0;
                    valid = false;
                    continue block0;
                }
            }
            if (valid && fact != null && foreignKey != null) {
                dimensionTable = OLAPUtil.getSQLTableFromOLAPTable(oSession.getDatabase(), fact);
                MondrianModel.Table tab = new MondrianModel.Table();
                tab.setSchema(fact.getSchema());
                tab.setName(fact.getName());
                hierarchy.setRelation(tab);
                hierarchy.setPrimaryKey(foreignKey);
            }
        }
        if (dimensionTable == null) {
            this.columnChooser.addItem("Parent hierarchy has no table");
            this.columnChooser.setEnabled(false);
        } else if (dimensionTable.getColumns().isEmpty()) {
            this.columnChooser.addItem("Parent hierarchy table has no columns");
            this.columnChooser.setEnabled(false);
        } else {
            this.columnChooser.setModel(new SQLObjectComboBoxModel((SQLObject)dimensionTable, SQLColumn.class));
            for (SQLColumn col : dimensionTable.getColumns()) {
                if (!col.getName().equalsIgnoreCase(level.getColumn())) continue;
                this.columnChooser.setSelectedItem(col);
            }
        }
        this.handler = new FormValidationHandler(this.status, true);
        OLAPObjectNameValidator validator = new OLAPObjectNameValidator((OLAPObject)level.getParent(), level, false);
        this.handler.addValidateObject((JComponent)this.name, (Validator)validator);
        this.handler.addValidateObject((JComponent)this.columnChooser, (Validator)new NotNullValidator("Column"));
        builder.appendSeparator("Properties");
        this.propertiesPanel = new PropertiesEditPanel(dimensionTable, (ValidationHandler)this.handler);
        builder.append((Component)this.propertiesPanel, 3);
        this.panel = builder.getPanel();
    }

    public boolean applyChanges() {
        this.level.begin("Modify Level Properties");
        this.level.setName(this.name.getText());
        if (this.columnChooser.isEnabled()) {
            SQLColumn col = (SQLColumn)this.columnChooser.getSelectedItem();
            this.level.setColumn(col == null ? null : col.getName());
        }
        if (!this.captionField.getText().equals("")) {
            this.level.setCaption(this.captionField.getText());
        } else {
            this.level.setCaption(null);
        }
        if (this.uniqueMembers.isSelected()) {
            this.level.setUniqueMembers(true);
        } else {
            this.level.setUniqueMembers(false);
        }
        if (this.levelType != null) {
            LevelType newType = (LevelType)((Object)this.levelType.getSelectedItem());
            if (newType != null) {
                this.level.setLevelType(newType.toString());
            } else {
                this.level.setLevelType(LevelType.values()[0].toString());
            }
        } else {
            this.level.setLevelType(null);
        }
        this.level.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }

    private class PropertiesEditPanel
    extends JPanel {
        private final JTable propertiesTab;
        private final String defaultPropName = "New Property";
        private final Action newPropertyAction = new AbstractAction("New..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                MondrianModel.Property prop = new MondrianModel.Property();
                prop.setName("New Property");
                LevelEditPanel.this.level.addProperty(prop);
            }
        };
        private final Action removePropertyAction = new AbstractAction("Remove..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = PropertiesEditPanel.this.propertiesTab.getSelectedRow();
                if (selectedRow > -1) {
                    LevelEditPanel.this.level.removeProperty(selectedRow);
                    this.setEnabled(false);
                }
            }
        };

        public PropertiesEditPanel(SQLTable table, ValidationHandler handler) throws SQLObjectException {
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.setLayout(new BorderLayout(10, 10));
            this.propertiesTab = new PropertiesTable(table);
            handler.addValidateObject((JComponent)this.propertiesTab, (Validator)new PropertiesTableNameValidator());
            JScrollPane sp = new JScrollPane(this.propertiesTab);
            sp.setPreferredSize(new Dimension(200, 200));
            this.add((Component)sp, "Center");
            ButtonStackBuilder bsb = new ButtonStackBuilder();
            bsb.addGridded((JComponent)new JButton(this.newPropertyAction));
            bsb.addRelatedGap();
            bsb.addGridded((JComponent)new JButton(this.removePropertyAction));
            bsb.addRelatedGap();
            this.removePropertyAction.setEnabled(false);
            this.add((Component)bsb.getPanel(), "East");
        }

        private class PropertiesTableModel
        extends AbstractTableModel
        implements SPListener {
            private final boolean disableColumns;

            public PropertiesTableModel(boolean disableColumns) {
                this.disableColumns = disableColumns;
                LevelEditPanel.this.level.addSPListener(this);
            }

            @Override
            public int getRowCount() {
                return LevelEditPanel.this.level.getProperties().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Name";
                }
                if (columnIndex == 1) {
                    return "Column";
                }
                throw new IllegalArgumentException("getColumnName: Unknow column index: " + columnIndex);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0 || columnIndex == 1) {
                    return String.class;
                }
                throw new IllegalArgumentException("getColumnClass: Unknow column index: " + columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return true;
                }
                if (columnIndex == 1) {
                    return !this.disableColumns;
                }
                throw new IllegalArgumentException("isCellEditable: Unknow column index: " + columnIndex);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return LevelEditPanel.this.level.getProperties().get(rowIndex).getName();
                }
                if (columnIndex == 1) {
                    if (this.disableColumns) {
                        return "Not Applicable";
                    }
                    return LevelEditPanel.this.level.getProperties().get(rowIndex).getColumn();
                }
                throw new IllegalArgumentException("getValueAt: Unexcepted column index: " + columnIndex);
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                MondrianModel.Property prop = LevelEditPanel.this.level.getProperties().get(rowIndex);
                if (columnIndex == 0) {
                    prop.setName((String)aValue);
                } else if (columnIndex == 1) {
                    if (aValue == null) {
                        prop.setColumn(null);
                    } else {
                        String colName = ((SQLColumn)aValue).getName();
                        if ("New Property".equals(prop.getName())) {
                            prop.setName(this.underscoreToCamelCaps(colName));
                        }
                        prop.setColumn(colName);
                    }
                } else {
                    throw new IllegalArgumentException("setValueAt: Unexcepted column index:" + columnIndex);
                }
                this.fireTableChanged(new TableModelEvent(this, rowIndex));
            }

            private String underscoreToCamelCaps(String text) {
                StringBuffer result = new StringBuffer(text.length() * 2);
                char[] chars = text.toLowerCase().toCharArray();
                for (int i = 0; i < text.length(); ++i) {
                    if ('_' == chars[i]) {
                        result.append(" ");
                        if (++i >= chars.length) break;
                        result.append(Character.toUpperCase(chars[i]));
                        continue;
                    }
                    result.append(chars[i]);
                }
                if (chars.length > 0) {
                    result.setCharAt(0, Character.toUpperCase(chars[0]));
                }
                return result.toString();
            }

            public void childAdded(SPChildEvent e) {
                this.fireTableDataChanged();
            }

            public void childRemoved(SPChildEvent e) {
                this.fireTableDataChanged();
            }

            public void propertyChanged(PropertyChangeEvent evt) {
            }

            public void transactionEnded(TransactionEvent e) {
            }

            public void transactionRollback(TransactionEvent e) {
            }

            public void transactionStarted(TransactionEvent e) {
            }
        }

        private class PropertiesTable
        extends EditableJTable {
            private final List<SQLColumn> columns;

            public PropertiesTable(SQLTable table) throws SQLObjectException {
                this.columns = table == null ? null : table.getColumns();
                boolean disableColumns = this.columns == null || this.columns.isEmpty();
                this.setModel(new PropertiesTableModel(disableColumns));
                this.setSelectionMode(0);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        boolean enableAction = PropertiesEditPanel.this.propertiesTab.getSelectedRow() > -1;
                        PropertiesEditPanel.this.removePropertyAction.setEnabled(enableAction);
                    }
                });
            }

            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 1) {
                    return new DefaultCellEditor(new JComboBox<Object>(this.columns.toArray()));
                }
                return super.getCellEditor(row, column);
            }
        }
    }

    private class PropertiesTableNameValidator
    implements Validator {
        private PropertiesTableNameValidator() {
        }

        public ValidateResult validate(Object contents) {
            TableModel model = (TableModel)contents;
            ArrayList<String> propNames = new ArrayList<String>();
            for (int i = 0; i < model.getRowCount(); ++i) {
                String propName = (String)model.getValueAt(i, 0);
                if (propNames.contains(propName)) {
                    return ValidateResult.createValidateResult((Status)Status.FAIL, (String)"Duplicate Property names.");
                }
                propNames.add(propName);
            }
            return ValidateResult.createValidateResult((Status)Status.OK, (String)"");
        }
    }

    public static enum LevelType {
        TimeYears,
        TimeQuarters,
        TimeMonths,
        TimeWeeks,
        TimeDays;

    }
}

