/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Date;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.util.StopWatch;

public class DefaultMessageHistory
implements MessageHistory {
    private final String routeId;
    private final NamedNode node;
    private final String nodeId;
    private final Date timestamp;
    private final StopWatch stopWatch;

    public DefaultMessageHistory(String routeId, NamedNode node, Date timestamp) {
        this.routeId = routeId;
        this.node = node;
        this.nodeId = node.getId();
        this.timestamp = timestamp;
        this.stopWatch = new StopWatch();
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public NamedNode getNode() {
        return this.node;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getElapsed() {
        return this.stopWatch.taken();
    }

    @Override
    public void nodeProcessingDone() {
        this.stopWatch.stop();
    }

    public String toString() {
        return "DefaultMessageHistory[routeId=" + this.routeId + ", node=" + this.nodeId + ']';
    }
}

