/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.iq80.leveldb.impl.SeekingIterator;
import org.iq80.leveldb.table.BlockEntry;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.VariableLengthQuantity;

public class BlockIterator
implements SeekingIterator<Slice, Slice> {
    private final SliceInput data;
    private final Slice restartPositions;
    private final int restartCount;
    private final Comparator<Slice> comparator;
    private BlockEntry nextEntry;

    public BlockIterator(Slice data, Slice restartPositions, Comparator<Slice> comparator) {
        Preconditions.checkNotNull((Object)data, (Object)"data is null");
        Preconditions.checkNotNull((Object)restartPositions, (Object)"restartPositions is null");
        Preconditions.checkArgument((restartPositions.length() % 4 == 0 ? 1 : 0) != 0, (String)"restartPositions.readableBytes() must be a multiple of %s", (Object[])new Object[]{(byte)4});
        Preconditions.checkNotNull(comparator, (Object)"comparator is null");
        this.data = data.input();
        this.restartPositions = restartPositions.slice();
        this.restartCount = this.restartPositions.length() / 4;
        this.comparator = comparator;
        this.seekToFirst();
    }

    public boolean hasNext() {
        return this.nextEntry != null;
    }

    public BlockEntry peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextEntry;
    }

    public BlockEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BlockEntry entry = this.nextEntry;
        this.nextEntry = !this.data.isReadable() ? null : BlockIterator.readEntry(this.data, this.nextEntry);
        return entry;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekToFirst() {
        if (this.restartCount > 0) {
            this.seekToRestartPosition(0);
        }
    }

    @Override
    public void seek(Slice targetKey) {
        if (this.restartCount == 0) {
            return;
        }
        int left = 0;
        int right = this.restartCount - 1;
        while (left < right) {
            int mid = (left + right + 1) / 2;
            this.seekToRestartPosition(mid);
            if (this.comparator.compare(this.nextEntry.getKey(), targetKey) < 0) {
                left = mid;
                continue;
            }
            right = mid - 1;
        }
        this.seekToRestartPosition(left);
        while (this.nextEntry != null && this.comparator.compare(this.peek().getKey(), targetKey) < 0) {
            this.next();
        }
    }

    private void seekToRestartPosition(int restartPosition) {
        Preconditions.checkPositionIndex((int)restartPosition, (int)this.restartCount, (String)"restartPosition");
        int offset = this.restartPositions.getInt(restartPosition * 4);
        this.data.setPosition(offset);
        this.nextEntry = null;
        this.nextEntry = BlockIterator.readEntry(this.data, null);
    }

    private static BlockEntry readEntry(SliceInput data, BlockEntry previousEntry) {
        Preconditions.checkNotNull((Object)data, (Object)"data is null");
        int sharedKeyLength = VariableLengthQuantity.readVariableLengthInt(data);
        int nonSharedKeyLength = VariableLengthQuantity.readVariableLengthInt(data);
        int valueLength = VariableLengthQuantity.readVariableLengthInt(data);
        Slice key = Slices.allocate(sharedKeyLength + nonSharedKeyLength);
        SliceOutput sliceOutput = key.output();
        if (sharedKeyLength > 0) {
            Preconditions.checkState((previousEntry != null ? 1 : 0) != 0, (Object)"Entry has a shared key but no previous entry was provided");
            sliceOutput.writeBytes(previousEntry.getKey(), 0, sharedKeyLength);
        }
        sliceOutput.writeBytes(data, nonSharedKeyLength);
        Slice value = data.readSlice(valueLength);
        return new BlockEntry(key, value);
    }
}

