/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsAPI;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsParam;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;
import org.zaproxy.zap.extension.httpsessions.OptionsHttpSessionsPanel;
import org.zaproxy.zap.extension.httpsessions.PopupMenuFactoryAddUserFromSession;
import org.zaproxy.zap.extension.httpsessions.PopupMenuItemCopySessionToken;
import org.zaproxy.zap.extension.httpsessions.PopupMenuRemoveSession;
import org.zaproxy.zap.extension.httpsessions.PopupMenuSessionSearch;
import org.zaproxy.zap.extension.httpsessions.PopupMenuSetActiveSession;
import org.zaproxy.zap.extension.httpsessions.PopupMenuUnsetActiveSession;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class ExtensionHttpSessions
extends ExtensionAdaptor
implements SessionChangedListener,
SiteMapListener,
HttpSenderListener {
    public static final String NAME = "ExtensionHttpSessions";
    private static final Logger log = Logger.getLogger(ExtensionHttpSessions.class);
    private HttpSessionsPanel httpSessionsPanel;
    private OptionsHttpSessionsPanel optionsHttpSessionsPanel;
    private Map<String, HttpSessionsSite> sessions;
    private Object sessionLock = new Object();
    private Map<String, HttpSessionTokensSet> sessionTokens;
    private Map<String, HashSet<String>> removedDefaultTokens;
    private HttpSessionsParam param;
    private PopupMenuSetActiveSession popupMenuSetActiveSession;
    private PopupMenuUnsetActiveSession popupMenuUnsetActiveSession;
    private PopupMenuRemoveSession popupMenuRemoveSession;
    private PopupMenuFactoryAddUserFromSession popupMenuAddUserFromSession;
    private PopupMenuItemCopySessionToken popupMenuItemCopySessionToken;
    private PopupMenuSessionSearch popupMenuItemFindRelatedMessages;

    public ExtensionHttpSessions() {
        super(NAME);
        this.initialize();
    }

    private void initialize() {
        this.setOrder(68);
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("httpsessions.name");
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("httpsessions.desc");
    }

    @Override
    public void init() {
        super.init();
        this.sessionTokens = new HashMap<String, HttpSessionTokensSet>();
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getParam());
        extensionHook.addSessionListener(this);
        extensionHook.addSiteMapListener(this);
        extensionHook.addHttpSenderListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addStatusPanel(this.getHttpSessionsPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsHttpSessionsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuSetActiveSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuUnsetActiveSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuRemoveSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAddUserFromSession());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuItemCopySessionToken());
            if (Control.getSingleton().getExtensionLoader().getExtension(ExtensionSearch.class) != null) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuItemFindRelatedMessages());
            }
        }
        extensionHook.addApiImplementor(new HttpSessionsAPI(this));
    }

    private OptionsHttpSessionsPanel getOptionsHttpSessionsPanel() {
        if (this.optionsHttpSessionsPanel == null) {
            this.optionsHttpSessionsPanel = new OptionsHttpSessionsPanel();
        }
        return this.optionsHttpSessionsPanel;
    }

    private PopupMenuSetActiveSession getPopupMenuSetActiveSession() {
        if (this.popupMenuSetActiveSession == null) {
            this.popupMenuSetActiveSession = new PopupMenuSetActiveSession();
            this.popupMenuSetActiveSession.setExtension(this);
        }
        return this.popupMenuSetActiveSession;
    }

    private PopupMenuRemoveSession getPopupMenuRemoveSession() {
        if (this.popupMenuRemoveSession == null) {
            this.popupMenuRemoveSession = new PopupMenuRemoveSession();
            this.popupMenuRemoveSession.setExtension(this);
        }
        return this.popupMenuRemoveSession;
    }

    private PopupMenuUnsetActiveSession getPopupMenuUnsetActiveSession() {
        if (this.popupMenuUnsetActiveSession == null) {
            this.popupMenuUnsetActiveSession = new PopupMenuUnsetActiveSession();
            this.popupMenuUnsetActiveSession.setExtension(this);
        }
        return this.popupMenuUnsetActiveSession;
    }

    private PopupMenuFactoryAddUserFromSession getPopupMenuAddUserFromSession() {
        if (this.popupMenuAddUserFromSession == null) {
            this.popupMenuAddUserFromSession = new PopupMenuFactoryAddUserFromSession(this);
        }
        return this.popupMenuAddUserFromSession;
    }

    private PopupMenuItemCopySessionToken getPopupMenuItemCopySessionToken() {
        if (this.popupMenuItemCopySessionToken == null) {
            this.popupMenuItemCopySessionToken = new PopupMenuItemCopySessionToken(this.getHttpSessionsPanel());
        }
        return this.popupMenuItemCopySessionToken;
    }

    private PopupMenuSessionSearch getPopupMenuItemFindRelatedMessages() {
        if (this.popupMenuItemFindRelatedMessages == null) {
            this.popupMenuItemFindRelatedMessages = new PopupMenuSessionSearch(this.httpSessionsPanel);
        }
        return this.popupMenuItemFindRelatedMessages;
    }

    public HttpSessionsParam getParam() {
        if (this.param == null) {
            this.param = new HttpSessionsParam();
        }
        return this.param;
    }

    public boolean isDefaultSessionToken(String token) {
        return this.getParam().getDefaultTokensEnabled().contains(token.toLowerCase(Locale.ENGLISH));
    }

    private boolean isRemovedDefaultSessionToken(String site, String token) {
        if (this.removedDefaultTokens == null) {
            return false;
        }
        HashSet<String> removed = this.removedDefaultTokens.get(site);
        return removed != null && removed.contains(token);
    }

    private void markRemovedDefaultSessionToken(String site, String token) {
        HashSet<String> removedSet;
        if (this.removedDefaultTokens == null) {
            this.removedDefaultTokens = new HashMap<String, HashSet<String>>(1);
        }
        if ((removedSet = this.removedDefaultTokens.get(site)) == null) {
            removedSet = new HashSet(1);
            this.removedDefaultTokens.put(site, removedSet);
        }
        removedSet.add(token);
    }

    private void unmarkRemovedDefaultSessionToken(String site, String token) {
        if (this.removedDefaultTokens == null) {
            return;
        }
        HashSet<String> removed = this.removedDefaultTokens.get(site);
        if (removed == null) {
            return;
        }
        removed.remove(token);
    }

    public boolean isSessionToken(String site, String token) {
        HttpSessionTokensSet siteTokens;
        if (!site.contains(":")) {
            site = site + ":80";
        }
        if ((siteTokens = this.sessionTokens.get(site)) == null) {
            return false;
        }
        return siteTokens.isSessionToken(token);
    }

    public void addHttpSessionToken(String site, String token) {
        HttpSessionTokensSet siteTokens;
        if (!site.contains(":")) {
            site = site + ":80";
        }
        if ((siteTokens = this.sessionTokens.get(site)) == null) {
            siteTokens = new HttpSessionTokensSet();
            this.sessionTokens.put(site, siteTokens);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added new session token for site '" + site + "': " + token));
        }
        siteTokens.addToken(token);
        this.unmarkRemovedDefaultSessionToken(site, token);
    }

    public void removeHttpSessionToken(String site, String token) {
        HttpSessionTokensSet siteTokens;
        if (!site.contains(":")) {
            site = site + ":80";
        }
        if ((siteTokens = this.sessionTokens.get(site)) != null) {
            siteTokens.removeToken(token);
            if (siteTokens.isEmpty()) {
                this.sessionTokens.remove(site);
            }
            this.getHttpSessionsSite(site).cleanupSessionToken(token);
        }
        if (this.isDefaultSessionToken(token)) {
            this.markRemovedDefaultSessionToken(site, token);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed session token for site '" + site + "': " + token));
        }
    }

    public final HttpSessionTokensSet getHttpSessionTokensSet(String site) {
        if (!site.contains(":")) {
            site = site + ":80";
        }
        return this.sessionTokens.get(site);
    }

    protected HttpSessionsPanel getHttpSessionsPanel() {
        if (this.httpSessionsPanel == null) {
            this.httpSessionsPanel = new HttpSessionsPanel(this);
        }
        return this.httpSessionsPanel;
    }

    public HttpSessionsSite getHttpSessionsSite(String site) {
        return this.getHttpSessionsSite(site, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSessionsSite getHttpSessionsSite(String site, boolean createIfNeeded) {
        if (!site.contains(":")) {
            site = site + ":80";
        }
        Object object = this.sessionLock;
        synchronized (object) {
            HttpSessionsSite hss;
            if (this.sessions == null) {
                if (!createIfNeeded) {
                    return null;
                }
                this.sessions = new HashMap<String, HttpSessionsSite>();
            }
            if ((hss = this.sessions.get(site)) == null) {
                if (!createIfNeeded) {
                    return null;
                }
                hss = new HttpSessionsSite(this, site);
                this.sessions.put(site, hss);
            }
            return hss;
        }
    }

    @Override
    public void nodeSelected(SiteNode node) {
        this.getHttpSessionsPanel().nodeSelected(node);
    }

    @Override
    public void onReturnNodeRendererComponent(SiteMapTreeCellRenderer component, boolean leaf, SiteNode value) {
    }

    @Override
    public void sessionChanged(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionAboutToChange(Session session) {
        this.sessionTokens = new HashMap<String, HttpSessionTokensSet>();
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessions = null;
        }
        this.removedDefaultTokens = null;
        if (this.getView() != null) {
            this.getHttpSessionsPanel().reset();
        }
        HttpSessionsSite.resetLastGeneratedSessionId();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpSession> getHttpSessionsForContext(Context context) {
        LinkedList<HttpSession> sessions = new LinkedList<HttpSession>();
        if (this.sessions == null) {
            return sessions;
        }
        Object object = this.sessionLock;
        synchronized (object) {
            for (Map.Entry<String, HttpSessionsSite> e : this.sessions.entrySet()) {
                String siteName = e.getKey();
                siteName = "http://" + siteName;
                if (!context.isInContext(siteName)) continue;
                sessions.addAll(e.getValue().getHttpSessions());
            }
        }
        return sessions;
    }

    public HttpSessionTokensSet getHttpSessionTokensSetForContext(Context context) {
        for (Map.Entry<String, HttpSessionTokensSet> e : this.sessionTokens.entrySet()) {
            String siteName = e.getKey();
            siteName = "http://" + siteName;
            if (!context.isInContext(siteName)) continue;
            return e.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSites() {
        ArrayList<String> sites = new ArrayList<String>();
        if (this.sessions == null) {
            return sites;
        }
        Object object = this.sessionLock;
        synchronized (object) {
            sites.addAll(this.sessions.keySet());
        }
        return sites;
    }

    @Override
    public int getListenerOrder() {
        return 1;
    }

    @Override
    public void onHttpRequestSend(HttpMessage msg, int initiator, HttpSender sender) {
        List<HttpCookie> requestCookies;
        if (initiator == 7 || initiator == 5) {
            return;
        }
        String site = msg.getRequestHeader().getHostName() + ":" + msg.getRequestHeader().getHostPort();
        site = ScanPanel.cleanSiteName(site, true);
        if (this.getView() != null) {
            this.getHttpSessionsPanel().addSiteAsynchronously(site);
        }
        if (this.getParam().isEnabledProxyOnly() && initiator != 1) {
            return;
        }
        try {
            requestCookies = msg.getRequestHeader().getHttpCookies();
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Failed to obtain the cookies: " + e.getMessage()), (Throwable)e);
            return;
        }
        for (HttpCookie cookie : requestCookies) {
            if (!this.isDefaultSessionToken(cookie.getName()) || this.isSessionToken(site, cookie.getName()) || this.isRemovedDefaultSessionToken(site, cookie.getName())) continue;
            this.addHttpSessionToken(site, cookie.getName());
        }
        HttpSessionsSite session = this.getHttpSessionsSite(site);
        session.processHttpRequestMessage(msg);
    }

    @Override
    public void onHttpResponseReceive(HttpMessage msg, int initiator, HttpSender sender) {
        if (initiator != 1 && initiator != 6) {
            return;
        }
        String site = msg.getRequestHeader().getHostName() + ":" + msg.getRequestHeader().getHostPort();
        site = ScanPanel.cleanSiteName(site, true);
        if (this.getView() != null) {
            this.getHttpSessionsPanel().addSiteAsynchronously(site);
        }
        if (this.getParam().isEnabledProxyOnly() && initiator != 1) {
            return;
        }
        List<HttpCookie> responseCookies = msg.getResponseHeader().getHttpCookies(msg.getRequestHeader().getHostName());
        for (HttpCookie cookie : responseCookies) {
            if (!this.isDefaultSessionToken(cookie.getName()) || this.isSessionToken(site, cookie.getName()) || this.isRemovedDefaultSessionToken(site, cookie.getName())) continue;
            this.addHttpSessionToken(site, cookie.getName());
        }
        HttpSessionsSite sessionsSite = this.getHttpSessionsSite(site);
        sessionsSite.processHttpResponseMessage(msg);
    }
}

