/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public class XPathResolver {
    private static final String EXPR = "ex:addFunc(2, 3) + $xyz";

    public static void main(String[] args) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new MyNamespaceContext());
        xpath.setXPathFunctionResolver(new MyFunctionResolver());
        xpath.setXPathVariableResolver(new MyVariableResolver());
        Object result = null;
        try {
            result = xpath.evaluate(EXPR, (Object)null, XPathConstants.NUMBER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("The evaluation result: " + result);
    }

    public static class MyVariableResolver
    implements XPathVariableResolver {
        public Object resolveVariable(QName varName) {
            if (varName == null) {
                throw new NullPointerException("The variable name cannot be null.");
            }
            if (varName.equals(new QName("", "xyz"))) {
                return new Double(4.0);
            }
            return null;
        }
    }

    public static class MyFunctionResolver
    implements XPathFunctionResolver {
        public XPathFunction resolveFunction(QName fname, int arity) {
            if (fname == null) {
                throw new NullPointerException("The function name cannot be null.");
            }
            if (fname.equals(new QName("http://ex.com", "addFunc", "ex"))) {
                return new XPathFunction(){

                    public Object evaluate(List args) {
                        if (args.size() == 2) {
                            Double arg1 = (Double)args.get(0);
                            Double arg2 = (Double)args.get(1);
                            return new Double(arg1 + arg2);
                        }
                        return null;
                    }
                };
            }
            return null;
        }
    }

    public static class MyNamespaceContext
    implements NamespaceContext {
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("The prefix cannot be null.");
            }
            if (prefix.equals("ex")) {
                return "http://ex.com";
            }
            return null;
        }

        public String getPrefix(String namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("The namespace uri cannot be null.");
            }
            if (namespace.equals("http://ex.com")) {
                return "ex";
            }
            return null;
        }

        public Iterator getPrefixes(String namespace) {
            return null;
        }
    }
}

