/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class RstProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("RST;").expression("([AL]);").expression("([^,]+);").expression("(.{5});").number("(d{9});").number("(d+);").number("(d+);").number("(dd)-(dd)-(dddd) ").number("(dd):(dd):(dd);").number("(dd)-(dd)-(dddd) ").number("(dd):(dd):(dd);").number("(-?d+.d+);").number("(-?d+.d+);").number("(d+);").number("(d+);").number("(-?d+);").number("([01]);").number("(d+);").number("(d+);").number("(xx);").number("(xx);").number("(xx);").number("(xx);").number("(xx);").number("(d+.d+);").number("(d+.d+);").number("(d+);").number("(d+);").number("(xx);").number("x{4};").number("(xx);").number("(xx);").any().compile();

    public RstProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        String archive = parser.next();
        String model = parser.next();
        String firmware = parser.next();
        String serial = parser.next();
        int index = parser.nextInt();
        parser.nextInt();
        if (channel != null && archive.equals("A")) {
            String response = "RST;A;" + model + ";" + firmware + ";" + serial + ";" + index + ";6;FIM;";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, serial)) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setDeviceTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setFixTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.setValid(parser.nextInt() > 0);
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextInt());
        position.set("in1", parser.nextHexInt());
        position.set("in2", parser.nextHexInt());
        position.set("in3", parser.nextHexInt());
        position.set("out1", parser.nextHexInt());
        position.set("out2", parser.nextHexInt());
        position.set("power", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        position.set("odometer", parser.nextInt());
        position.set("rssi", parser.nextInt());
        position.set("temp1", Integer.valueOf(parser.nextHexInt().byteValue()));
        int status = (parser.nextHexInt() << 8) + parser.nextHexInt();
        position.set("ignition", BitUtil.check(status, 7));
        position.set("status", status);
        return position;
    }
}

