/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class GalileoProtocolEncoder
extends BaseProtocolEncoder {
    public GalileoProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeText(String uniqueId, String text) {
        ByteBuf buf = Unpooled.buffer((int)256);
        buf.writeByte(1);
        buf.writeShortLE(uniqueId.length() + text.length() + 11);
        buf.writeByte(3);
        buf.writeBytes(uniqueId.getBytes(StandardCharsets.US_ASCII));
        buf.writeByte(4);
        buf.writeShortLE(0);
        buf.writeByte(224);
        buf.writeIntLE(0);
        buf.writeByte(225);
        buf.writeByte(text.length());
        buf.writeBytes(text.getBytes(StandardCharsets.US_ASCII));
        buf.writeShortLE(Checksum.crc16(Checksum.CRC16_MODBUS, buf.nioBuffer(0, buf.writerIndex())));
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "custom": {
                return this.encodeText(this.getUniqueId(command.getDeviceId()), command.getString("data"));
            }
            case "outputControl": {
                return this.encodeText(this.getUniqueId(command.getDeviceId()), "Out " + command.getInteger("index") + "," + command.getString("data"));
            }
        }
        return null;
    }
}

