/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import java.text.DecimalFormat;
import java.util.Map;

public final class MiscFormatter {
    private static final String XML_ROOT_NODE = "info";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    private MiscFormatter() {
    }

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return DECIMAL_FORMAT.format(value);
        }
        return value.toString();
    }

    public static String toXmlString(Map<String, Object> attributes) {
        StringBuilder result = new StringBuilder();
        result.append("<").append(XML_ROOT_NODE).append(">");
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            result.append("<").append(entry.getKey()).append(">");
            result.append(MiscFormatter.format(entry.getValue()));
            result.append("</").append(entry.getKey()).append(">");
        }
        result.append("</").append(XML_ROOT_NODE).append(">");
        return result.toString();
    }
}

