/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class MapmyIndiaGeocoder
extends JsonGeocoder {
    public MapmyIndiaGeocoder(String url, String key, int cacheSize, AddressFormat addressFormat) {
        super(url + "/" + key + "/rev_geocode?lat=%f&lng=%f", cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray results = json.getJsonArray("results");
        if (!results.isEmpty()) {
            Address address = new Address();
            JsonObject result = (JsonObject)results.get(0);
            if (result.containsKey((Object)"formatted_address")) {
                address.setFormattedAddress(result.getString("formatted_address"));
            }
            if (result.containsKey((Object)"house_number") && !result.getString("house_number").isEmpty()) {
                address.setHouse(result.getString("house_number"));
            } else if (result.containsKey((Object)"house_name") && !result.getString("house_name").isEmpty()) {
                address.setHouse(result.getString("house_name"));
            }
            if (result.containsKey((Object)"street")) {
                address.setStreet(result.getString("street"));
            }
            if (result.containsKey((Object)"locality") && !result.getString("locality").isEmpty()) {
                address.setSuburb(result.getString("locality"));
            } else if (result.containsKey((Object)"sublocality") && !result.getString("sublocality").isEmpty()) {
                address.setSuburb(result.getString("sublocality"));
            } else if (result.containsKey((Object)"subsublocality") && !result.getString("subsublocality").isEmpty()) {
                address.setSuburb(result.getString("subsublocality"));
            }
            if (result.containsKey((Object)"city") && !result.getString("city").isEmpty()) {
                address.setSettlement(result.getString("city"));
            } else if (result.containsKey((Object)"village") && !result.getString("village").isEmpty()) {
                address.setSettlement(result.getString("village"));
            }
            if (result.containsKey((Object)"district")) {
                address.setDistrict(result.getString("district"));
            } else if (result.containsKey((Object)"subDistrict")) {
                address.setDistrict(result.getString("subDistrict"));
            }
            if (result.containsKey((Object)"state")) {
                address.setState(result.getString("state"));
            }
            if (result.containsKey((Object)"pincode")) {
                address.setPostcode(result.getString("pincode"));
            }
            return address;
        }
        return null;
    }
}

