/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr353;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jsr353.JsonValueDeserializer;
import com.fasterxml.jackson.datatype.jsr353.JsonValueSerializer;
import com.fasterxml.jackson.datatype.jsr353.PackageVersion;
import java.util.Collections;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;

public class JSR353Module
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    protected final JsonBuilderFactory _builderFactory;

    public JSR353Module() {
        super(PackageVersion.VERSION);
        JsonProvider jp = JsonProvider.provider();
        this._builderFactory = jp.createBuilderFactory(Collections.emptyMap());
        final JsonValueDeserializer jsonValueDeser = new JsonValueDeserializer(this._builderFactory);
        this.addSerializer(JsonValue.class, (JsonSerializer)new JsonValueSerializer());
        this.setDeserializers(new SimpleDeserializers(){

            public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                if (JsonValue.class.isAssignableFrom(type.getRawClass())) {
                    return jsonValueDeser;
                }
                return null;
            }

            public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
                if (JsonArray.class.isAssignableFrom(type.getRawClass())) {
                    return jsonValueDeser;
                }
                return null;
            }

            public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
                if (JsonObject.class.isAssignableFrom(type.getRawClass())) {
                    return jsonValueDeser;
                }
                return null;
            }
        });
    }
}

