/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularIndex {
    private static Logger logger = LoggerFactory.getLogger(CircularIndex.class);
    private boolean resetOnZero;
    private long capacity;
    private long size;
    private long first;
    private long next;

    public CircularIndex(long capacity) {
        this(capacity, 0L, 0L);
    }

    public CircularIndex(long capacity, boolean resetOnZero) {
        this(capacity, 0L, 0L, resetOnZero);
    }

    public CircularIndex(long capacity, long first, long size) {
        this(capacity, first, size, false);
    }

    public CircularIndex(long capacity, long first, long size, boolean resetOnZero) {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Index capacity must be > 0");
        }
        this.capacity = capacity;
        if (first < 0L) {
            throw new IllegalArgumentException("Index first element must be >= 0 [first=" + first + "]");
        }
        if (first >= capacity) {
            throw new IllegalArgumentException("Index first element must be < capacity [first=" + first + ", capacity=" + capacity + "]");
        }
        this.first = first;
        if (size < 0L) {
            throw new IllegalArgumentException("Index size element must be >= 0 [size=" + size + "]");
        }
        if (size > this.getMaxSize()) {
            throw new IllegalArgumentException("Index size element must be < getMaxSize [size=" + size + ", getMaxSize=" + this.getMaxSize() + "]");
        }
        this.size = size;
        this.next = this.calculateNewIndex(first, size);
        this.resetOnZero = resetOnZero;
        this.checkReset();
    }

    public void reset() {
        this.size = 0L;
        this.first = 0L;
        this.next = 0L;
    }

    private void checkReset() {
        if (this.resetOnZero && this.size == 0L) {
            this.reset();
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getMaxSize() {
        return this.capacity - 1L;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.first == this.next;
    }

    public boolean isFull() {
        return (this.next + 1L) % this.capacity == this.first;
    }

    protected long calculateNewIndex(long index, long offset) {
        return (index + this.capacity + offset) % this.capacity;
    }

    public boolean addLast() {
        if (this.isFull()) {
            return false;
        }
        this.next = this.calculateNewIndex(this.next, 1L);
        ++this.size;
        return true;
    }

    public boolean addFirst() {
        if (this.isFull()) {
            return false;
        }
        this.first = this.calculateNewIndex(this.first, -1L);
        ++this.size;
        return true;
    }

    public boolean removeLast() {
        if (this.isEmpty()) {
            return false;
        }
        this.next = this.calculateNewIndex(this.next, -1L);
        --this.size;
        this.checkReset();
        return true;
    }

    public boolean removeFirst() {
        if (this.isEmpty()) {
            return false;
        }
        this.first = this.calculateNewIndex(this.first, 1L);
        --this.size;
        this.checkReset();
        return true;
    }

    public long getFirst() {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.first;
    }

    public long getLast() {
        if (this.isEmpty()) {
            return -1L;
        }
        return this.calculateNewIndex(this.next, -1L);
    }

    public long getNextLast() {
        if (this.isFull()) {
            return -1L;
        }
        if (this.isEmpty()) {
            return this.first;
        }
        return this.next;
    }

    public long getNextFirst() {
        if (this.isFull()) {
            return -1L;
        }
        if (this.isEmpty()) {
            return this.first;
        }
        return this.calculateNewIndex(this.first, -1L);
    }

    protected long getInternalFirst() {
        return this.first;
    }

    protected long getInternalNext() {
        return this.next;
    }

    public String toString() {
        return new StringBuilder(50).append("[size=").append(this.size).append(", first=").append(this.first).append(", next=").append(this.next).append("]").toString();
    }
}

