/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.TreeTableCellEditor;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import ca.odell.glazedlists.swing.TreeTableCellRenderer;
import ca.odell.glazedlists.swing.TreeTableUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class TreeTableSupport {
    private static final ListSelectionModel NOOP_SELECTION_MODEL = new NoopColumnSelectionModel();
    private static final ListEventListener SWING_THREAD_CHECKER = new EventDispathThreadChecker();
    private final JTable table;
    private final TreeList treeList;
    private final int hierarchyColumnModelIndex;
    private final KeyListener expandAndCollapseKeyListener = new ExpandAndCollapseKeyListener();
    private final KeyListener arrowKeyListener = new ArrowKeyListener();
    private boolean arrowKeyExpansionEnabled;
    private ListSelectionModel originalColumnSelectionModel;
    private boolean showExpanderForEmptyParent;
    private TreeTableCellRenderer treeTableCellRenderer;
    private TreeTableCellEditor treeTableCellEditor;
    private final TableCellRenderer originalRenderer;
    private final TableCellEditor originalEditor;

    private TreeTableSupport(JTable table, TreeList treeList, int modelColumnIndex) {
        this.table = table;
        this.treeList = treeList;
        this.hierarchyColumnModelIndex = modelColumnIndex;
        int viewColumnIndex = table.convertColumnIndexToView(modelColumnIndex);
        if (viewColumnIndex == -1) {
            throw new IllegalArgumentException("Unable to locate a view index for the given model index: " + modelColumnIndex);
        }
        TableColumn viewColumn = table.getColumnModel().getColumn(viewColumnIndex);
        this.originalRenderer = viewColumn.getCellRenderer();
        this.treeTableCellRenderer = new TreeTableCellRenderer(this.originalRenderer, treeList);
        viewColumn.setCellRenderer(this.treeTableCellRenderer);
        this.originalEditor = viewColumn.getCellEditor();
        this.treeTableCellEditor = new TreeTableCellEditor(this.originalEditor, treeList);
        viewColumn.setCellEditor(this.treeTableCellEditor);
        this.table.addKeyListener(this.arrowKeyListener);
        this.table.addKeyListener(this.expandAndCollapseKeyListener);
        this.decorateUIDelegateMouseListener(this.table);
        this.treeList.addListEventListener(SWING_THREAD_CHECKER);
    }

    private void decorateUIDelegateMouseListener(Component component) {
        MouseListener[] mouseListeners = component.getMouseListeners();
        for (int i = mouseListeners.length - 1; i >= 0; --i) {
            if (mouseListeners[i].getClass().getName().indexOf("TableUI") == -1) continue;
            component.removeMouseListener(mouseListeners[i]);
            component.addMouseListener(new ExpandAndCollapseMouseListener(mouseListeners[i]));
            break;
        }
    }

    private void undecorateUIDelegateMouseListener(Component component) {
        MouseListener[] mouseListeners = component.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            if (!(mouseListeners[i] instanceof ExpandAndCollapseMouseListener)) continue;
            component.removeMouseListener(mouseListeners[i]);
            component.addMouseListener(((ExpandAndCollapseMouseListener)mouseListeners[i]).getDelegate());
        }
    }

    public static TreeTableSupport install(JTable table, TreeList treeList, int modelColumnIndex) {
        TreeTableSupport.checkAccessThread();
        return new TreeTableSupport(table, treeList, modelColumnIndex);
    }

    public void uninstall() {
        TreeTableSupport.checkAccessThread();
        this.treeList.removeListEventListener(SWING_THREAD_CHECKER);
        this.setArrowKeyExpansionEnabled(false);
        this.table.removeKeyListener(this.arrowKeyListener);
        this.table.removeKeyListener(this.expandAndCollapseKeyListener);
        this.undecorateUIDelegateMouseListener(this.table);
        int viewColumnIndex = this.table.convertColumnIndexToView(this.hierarchyColumnModelIndex);
        TableColumn viewColumn = this.table.getColumnModel().getColumn(viewColumnIndex);
        TableCellRenderer renderer = viewColumn.getCellRenderer();
        TableCellEditor editor = viewColumn.getCellEditor();
        if (renderer == this.treeTableCellRenderer) {
            viewColumn.setCellRenderer(this.originalRenderer);
        }
        if (editor == this.treeTableCellEditor) {
            viewColumn.setCellEditor(this.originalEditor);
        }
        this.treeTableCellRenderer.dispose();
        this.treeTableCellEditor.dispose();
    }

    public void setShowExpanderForEmptyParent(boolean showExpanderForEmptyParent) {
        TreeTableSupport.checkAccessThread();
        if (this.showExpanderForEmptyParent == showExpanderForEmptyParent) {
            return;
        }
        this.showExpanderForEmptyParent = showExpanderForEmptyParent;
        this.treeTableCellRenderer.setShowExpanderForEmptyParent(showExpanderForEmptyParent);
        this.treeTableCellEditor.setShowExpanderForEmptyParent(showExpanderForEmptyParent);
        this.table.repaint();
    }

    public boolean getShowExpanderForEmptyParent() {
        return this.showExpanderForEmptyParent;
    }

    public void setArrowKeyExpansionEnabled(boolean arrowKeyExpansionEnabled) {
        TreeTableSupport.checkAccessThread();
        if (this.arrowKeyExpansionEnabled == arrowKeyExpansionEnabled) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (arrowKeyExpansionEnabled) {
            this.originalColumnSelectionModel = tableColumnModel.getSelectionModel();
            tableColumnModel.setSelectionModel(NOOP_SELECTION_MODEL);
        } else {
            if (tableColumnModel.getSelectionModel() == NOOP_SELECTION_MODEL) {
                tableColumnModel.setSelectionModel(this.originalColumnSelectionModel);
            }
            this.originalColumnSelectionModel = null;
        }
        this.arrowKeyExpansionEnabled = arrowKeyExpansionEnabled;
    }

    public boolean getArrowKeyExpansionEnabled() {
        return this.arrowKeyExpansionEnabled;
    }

    public void setRenderer(TreeTableCellRenderer treeTableCellRenderer) {
        TreeTableSupport.checkAccessThread();
        int viewColumnIndex = this.table.convertColumnIndexToView(this.hierarchyColumnModelIndex);
        if (viewColumnIndex == -1) {
            throw new IllegalArgumentException("Unable to locate a view index for the given model index: " + this.hierarchyColumnModelIndex);
        }
        TableColumn viewColumn = this.table.getColumnModel().getColumn(viewColumnIndex);
        this.treeTableCellRenderer.dispose();
        this.treeTableCellRenderer = treeTableCellRenderer;
        treeTableCellRenderer.setShowExpanderForEmptyParent(this.showExpanderForEmptyParent);
        viewColumn.setCellRenderer(treeTableCellRenderer);
    }

    public TreeTableCellRenderer getRenderer() {
        return this.treeTableCellRenderer;
    }

    public void setDelegateRenderer(TableCellRenderer renderer) {
        TreeTableSupport.checkAccessThread();
        this.treeTableCellRenderer.setDelegate(renderer);
    }

    public TableCellRenderer getDelegateRenderer() {
        return this.treeTableCellRenderer.getDelegate();
    }

    public void setEditor(TreeTableCellEditor treeTableCellEditor) {
        TreeTableSupport.checkAccessThread();
        int viewColumnIndex = this.table.convertColumnIndexToView(this.hierarchyColumnModelIndex);
        if (viewColumnIndex == -1) {
            throw new IllegalArgumentException("Unable to locate a view index for the given model index: " + this.hierarchyColumnModelIndex);
        }
        TableColumn viewColumn = this.table.getColumnModel().getColumn(viewColumnIndex);
        this.treeTableCellEditor.dispose();
        this.treeTableCellEditor = treeTableCellEditor;
        treeTableCellEditor.setShowExpanderForEmptyParent(this.showExpanderForEmptyParent);
        viewColumn.setCellEditor(treeTableCellEditor);
    }

    public TreeTableCellEditor getEditor() {
        return this.treeTableCellEditor;
    }

    public void setDelegateEditor(TableCellEditor editor) {
        TreeTableSupport.checkAccessThread();
        this.treeTableCellEditor.setDelegate(editor);
    }

    public TableCellEditor getDelegateEditor() {
        return this.treeTableCellEditor.getDelegate();
    }

    private static void checkAccessThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("TreeTableSupport must be accessed from the Swing Event Dispatch Thread, but was called on Thread \"" + Thread.currentThread().getName() + "\"");
        }
    }

    private static class NoopColumnSelectionModel
    implements ListSelectionModel {
        private NoopColumnSelectionModel() {
        }

        public void setSelectionInterval(int index0, int index1) {
        }

        public void addSelectionInterval(int index0, int index1) {
        }

        public void removeSelectionInterval(int index0, int index1) {
        }

        public int getMinSelectionIndex() {
            return -1;
        }

        public int getMaxSelectionIndex() {
            return -1;
        }

        public boolean isSelectedIndex(int index) {
            return false;
        }

        public int getAnchorSelectionIndex() {
            return -1;
        }

        public void setAnchorSelectionIndex(int index) {
        }

        public int getLeadSelectionIndex() {
            return -1;
        }

        public void setLeadSelectionIndex(int index) {
        }

        public void clearSelection() {
        }

        public boolean isSelectionEmpty() {
            return true;
        }

        public void insertIndexInterval(int index, int length, boolean before) {
        }

        public void removeIndexInterval(int index0, int index1) {
        }

        public void setValueIsAdjusting(boolean valueIsAdjusting) {
        }

        public boolean getValueIsAdjusting() {
            return false;
        }

        public void setSelectionMode(int selectionMode) {
        }

        public int getSelectionMode() {
            return 0;
        }

        public void addListSelectionListener(ListSelectionListener x) {
        }

        public void removeListSelectionListener(ListSelectionListener x) {
        }
    }

    private static class EventDispathThreadChecker
    implements ListEventListener {
        private EventDispathThreadChecker() {
        }

        public void listChanged(ListEvent listChanges) {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("TreeTableSupport has detected that its underlying TreeList was changed on a Thread that is NOT the Swing Event Dispatch Thread. This can cause unreliable results including sporadic exceptions since the TreeList is read from the EDT. Two solutions exist for this problem:\n\na) ensure each and every write to the EventList pipeline occurs on the Swing EDT\nb) wrap the source EventList of TreeList in a Swing Thread Proxy List using GlazedListsSwing.swingThreadProxyList(...) before passing it to the TreeList constructor");
            }
        }
    }

    private class ArrowKeyListener
    extends KeyAdapter {
        private ArrowKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            boolean isRightArrowKey;
            if (!TreeTableSupport.this.arrowKeyExpansionEnabled) {
                return;
            }
            if (!TreeTableSupport.this.table.isEnabled()) {
                return;
            }
            if (TreeTableSupport.this.table.getColumnSelectionAllowed()) {
                return;
            }
            int c = e.getKeyCode();
            boolean isLeftArrowKey = c == 37;
            boolean bl = isRightArrowKey = c == 39;
            if (!isLeftArrowKey && !isRightArrowKey || e.getModifiers() != 0) {
                return;
            }
            int row = TreeTableSupport.this.table.getSelectionModel().getLeadSelectionIndex();
            if (row == -1) {
                return;
            }
            TreeTableSupport.this.treeList.getReadWriteLock().writeLock().lock();
            try {
                boolean expanded;
                if (TreeTableSupport.this.treeList.getAllowsChildren(row) && ((expanded = TreeTableSupport.this.treeList.isExpanded(row)) && isLeftArrowKey || !expanded && isRightArrowKey)) {
                    TreeTableUtilities.toggleExpansion(TreeTableSupport.this.table, TreeTableSupport.this.treeList, row).run();
                }
            }
            finally {
                TreeTableSupport.this.treeList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private class ExpandAndCollapseKeyListener
    extends KeyAdapter {
        private Runnable restoreStateRunnable;

        private ExpandAndCollapseKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            if (!TreeTableSupport.this.table.isEnabled()) {
                return;
            }
            if (!TreeTableSupport.this.table.isFocusOwner()) {
                return;
            }
            if (e.getKeyCode() != 32 || e.getModifiers() != 0) {
                return;
            }
            int row = TreeTableSupport.this.table.getSelectionModel().getLeadSelectionIndex();
            int column = TreeTableSupport.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (row == -1) {
                return;
            }
            if (column != -1 && TreeTableSupport.this.table.convertColumnIndexToModel(column) != TreeTableSupport.this.hierarchyColumnModelIndex) {
                return;
            }
            TreeTableSupport.this.treeList.getReadWriteLock().writeLock().lock();
            try {
                if (TreeTableSupport.this.treeList.getAllowsChildren(row)) {
                    Runnable r = TreeTableUtilities.toggleExpansion(TreeTableSupport.this.table, TreeTableSupport.this.treeList, row);
                    if (this.restoreStateRunnable == null) {
                        this.restoreStateRunnable = r;
                    }
                }
            }
            finally {
                TreeTableSupport.this.treeList.getReadWriteLock().writeLock().unlock();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (this.restoreStateRunnable != null) {
                this.restoreStateRunnable.run();
                this.restoreStateRunnable = null;
            }
        }
    }

    private class ExpandAndCollapseMouseListener
    implements MouseListener {
        private final MouseListener delegate;

        public ExpandAndCollapseMouseListener(MouseListener delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate may not be null");
            }
            this.delegate = delegate;
        }

        public MouseListener getDelegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent me) {
            if (!TreeTableSupport.this.table.isEnabled()) {
                return;
            }
            JTable table = (JTable)me.getSource();
            Point clickPoint = me.getPoint();
            int row = table.rowAtPoint(clickPoint);
            int column = table.columnAtPoint(clickPoint);
            if (row == -1 || column == -1) {
                return;
            }
            Rectangle cellRect = table.getCellRect(row, column, true);
            clickPoint.translate(-cellRect.x, -cellRect.y);
            TreeTableCellPanel renderedPanel = TreeTableUtilities.prepareRenderer(me);
            if (SwingUtilities.isLeftMouseButton(me) && renderedPanel != null && renderedPanel.isPointOverExpanderButton(clickPoint)) {
                TreeTableSupport.this.treeList.getReadWriteLock().writeLock().lock();
                try {
                    if (TreeTableSupport.this.treeList.getAllowsChildren(row)) {
                        TreeTableUtilities.toggleExpansion(table, TreeTableSupport.this.treeList, row).run();
                    }
                }
                finally {
                    TreeTableSupport.this.treeList.getReadWriteLock().writeLock().unlock();
                }
                return;
            }
            this.delegate.mousePressed(me);
        }

        public void mouseClicked(MouseEvent me) {
            this.delegate.mouseClicked(me);
        }

        public void mouseReleased(MouseEvent me) {
            this.delegate.mouseReleased(me);
        }

        public void mouseEntered(MouseEvent me) {
            this.delegate.mouseEntered(me);
        }

        public void mouseExited(MouseEvent me) {
            this.delegate.mouseExited(me);
        }
    }
}

