/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import ca.odell.glazedlists.swing.EventTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;

public class EventListJXTableSorting {
    private final SortedList sortedList;
    private final JXTable table;
    private final SortController sortController;
    private final EventListFilterPipeline filterPipeline;
    private final FilterPipeline originalFilterPipeline;

    private EventListJXTableSorting(JXTable table, SortedList sortedList) {
        this.table = table;
        this.sortedList = sortedList;
        this.originalFilterPipeline = table.getFilters();
        this.sortController = new EventListSortController();
        this.filterPipeline = new EventListFilterPipeline();
        table.setFilters((FilterPipeline)this.filterPipeline);
    }

    public static EventListJXTableSorting install(JXTable table, SortedList sortedList) {
        return new EventListJXTableSorting(table, sortedList);
    }

    public void uninstall() {
        this.table.setFilters(this.originalFilterPipeline);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventListSortController
    implements SortController {
        private final List<SortKey> sortKeys = new ArrayList<SortKey>(1);
        private final List<SortKey> sortKeysReadOnly = Collections.unmodifiableList(this.sortKeys);

        private EventListSortController() {
        }

        public void toggleSortOrder(int columnIndex) {
            this.toggleSortOrder(columnIndex, GlazedLists.comparableComparator());
        }

        public void toggleSortOrder(int columnIndex, Comparator comparator) {
            List<? extends SortKey> sortKeys = this.getSortKeys();
            SortKey columnSortKey = null;
            for (SortKey sortKey : sortKeys) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED || sortKey.getColumn() != columnIndex) continue;
                columnSortKey = sortKey;
                break;
            }
            if (columnSortKey == null) {
                columnSortKey = new SortKey(SortOrder.ASCENDING, columnIndex);
            } else {
                SortOrder sortOrder = columnSortKey.getSortOrder() == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                columnSortKey = new SortKey(sortOrder, columnIndex);
            }
            this.setSortKeys(Collections.singletonList(columnSortKey));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSortKeys(List<? extends SortKey> sortKeys) {
            if (sortKeys == this.sortKeysReadOnly) {
                return;
            }
            if (sortKeys == null) {
                sortKeys = Collections.emptyList();
            }
            this.sortKeys.clear();
            this.sortKeys.addAll(sortKeys);
            ArrayList comparators = new ArrayList(this.sortKeys.size());
            for (int k = 0; k < this.sortKeys.size(); ++k) {
                SortKey sortKey = this.sortKeys.get(k);
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                Comparator comparator = this.getComparator(sortKey.getColumn());
                if (sortKey.getSortOrder() == SortOrder.DESCENDING) {
                    comparator = GlazedLists.reverseComparator(comparator);
                }
                comparators.add(comparator);
            }
            Comparator comparator = comparators.isEmpty() ? null : (comparators.size() == 1 ? (Comparator)comparators.get(0) : GlazedLists.chainComparators(comparators));
            EventListJXTableSorting.this.sortedList.getReadWriteLock().writeLock().lock();
            try {
                EventListJXTableSorting.this.sortedList.setComparator(comparator);
            }
            finally {
                EventListJXTableSorting.this.sortedList.getReadWriteLock().writeLock().unlock();
            }
        }

        private Comparator getComparator(int modelIndex) {
            EventTableModel tableModel = (EventTableModel)EventListJXTableSorting.this.table.getModel();
            TableFormat tableFormat = tableModel.getTableFormat();
            return new TableColumnComparator(tableFormat, modelIndex);
        }

        public List<? extends SortKey> getSortKeys() {
            return this.sortKeysReadOnly;
        }

        public SortOrder getSortOrder(int columnIndex) {
            for (SortKey s : this.sortKeys) {
                if (s.getColumn() != columnIndex) continue;
                return s.getSortOrder();
            }
            return SortOrder.UNSORTED;
        }
    }

    private class EventListFilterPipeline
    extends FilterPipeline {
        private EventListFilterPipeline() {
        }

        public SortController getSortController() {
            return EventListJXTableSorting.this.sortController;
        }
    }
}

