/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTreeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortedList<E>
extends TransformedList<E, E> {
    private static final byte ALL_COLORS = 1;
    private static final Element EMPTY_ELEMENT = null;
    public static final int STRICT_SORT_ORDER = 0;
    public static final int AVOID_MOVING_ELEMENTS = 1;
    private SimpleTree<Element> unsorted = null;
    private SimpleTree<Element> sorted = null;
    private Comparator<? super E> comparator = null;
    private int mode = 0;

    public SortedList(EventList<E> source) {
        this(source, GlazedLists.comparableComparator());
    }

    public SortedList(EventList<E> source, Comparator<? super E> comparator) {
        super(source);
        this.setComparator(comparator);
        source.addListEventListener(this);
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Mode must be either SortedList.STRICT_SORT_ORDER or SortedList.AVOID_MOVING_ELEMENTS");
        }
        if (mode == this.mode) {
            return;
        }
        this.mode = mode;
        if (this.mode == 0) {
            this.setComparator(this.getComparator());
        }
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        if (listChanges.isReordering()) {
            int[] sourceReorder = listChanges.getReorderMap();
            int[] previousIndexToSortedIndex = new int[this.sorted.size()];
            int index = 0;
            SimpleTreeIterator<Element> simpleTreeIterator = new SimpleTreeIterator<Element>(this.sorted);
            while (simpleTreeIterator.hasNext()) {
                simpleTreeIterator.next();
                Element unsortedNode = simpleTreeIterator.value();
                int unsortedIndex = this.unsorted.indexOfNode(unsortedNode, (byte)1);
                previousIndexToSortedIndex[unsortedIndex] = index++;
            }
            int[] nArray = new int[this.sorted.size()];
            for (int i2 = 0; i2 < previousIndexToSortedIndex.length; ++i2) {
                nArray[i2] = previousIndexToSortedIndex[sourceReorder[i2]];
            }
            Element[] unsortedNodes = new Element[this.unsorted.size()];
            index = 0;
            SimpleTreeIterator<Element> i3 = new SimpleTreeIterator<Element>(this.unsorted);
            while (i3.hasNext()) {
                Element<Element> unsortedNode;
                i3.next();
                unsortedNodes[index] = unsortedNode = i3.node();
                ++index;
            }
            Arrays.sort(unsortedNodes, this.sorted.getComparator());
            int[] reorderMap = new int[this.sorted.size()];
            boolean indexChanged = false;
            index = 0;
            SimpleTreeIterator<Element> i4 = new SimpleTreeIterator<Element>(this.sorted);
            while (i4.hasNext()) {
                i4.next();
                Element<Element> sortedNode = i4.node();
                Element unsortedNode = unsortedNodes[index];
                sortedNode.set(unsortedNode);
                unsortedNode.set(sortedNode);
                int unsortedIndex = this.unsorted.indexOfNode(unsortedNode, (byte)1);
                reorderMap[index] = nArray[unsortedIndex];
                indexChanged = indexChanged || index != reorderMap[index];
                ++index;
            }
            if (indexChanged) {
                this.updates.beginEvent();
                this.updates.reorder(reorderMap);
                this.updates.commitEvent();
            }
            return;
        }
        this.updates.beginEvent();
        LinkedList<Element<Element>> insertNodes = new LinkedList<Element<Element>>();
        ArrayList<Element> updateNodes = new ArrayList<Element>();
        while (listChanges.next()) {
            Element<Element> unsortedNode;
            int unsortedIndex = listChanges.getIndex();
            int n = listChanges.getType();
            if (n == 2) {
                unsortedNode = this.unsorted.add(unsortedIndex, EMPTY_ELEMENT, 1);
                insertNodes.addLast(unsortedNode);
                continue;
            }
            if (n == 1) {
                unsortedNode = this.unsorted.get(unsortedIndex);
                Element sortedNode = unsortedNode.get();
                sortedNode.setSorted(2);
                updateNodes.add(sortedNode);
                continue;
            }
            if (n != 0) continue;
            unsortedNode = this.unsorted.get(unsortedIndex);
            this.unsorted.remove(unsortedNode);
            int deleteSortedIndex = this.deleteByUnsortedNode(unsortedNode);
            this.updates.addDelete(deleteSortedIndex);
        }
        for (Element element : updateNodes) {
            if (element.getSorted() != 2) continue;
            Element lowerBound = null;
            Element upperBound = null;
            Element firstUnsortedNode = element;
            for (Element leftNeighbour = element.previous(); leftNeighbour != null; leftNeighbour = leftNeighbour.previous()) {
                if (leftNeighbour.getSorted() == 0) {
                    lowerBound = leftNeighbour;
                    break;
                }
                firstUnsortedNode = leftNeighbour;
            }
            for (Element rightNeighbour = element.next(); rightNeighbour != null; rightNeighbour = rightNeighbour.next()) {
                if (rightNeighbour.getSorted() != 0) continue;
                upperBound = rightNeighbour;
                break;
            }
            Comparator<Element> nodeComparator = this.sorted.getComparator();
            for (Element current = firstUnsortedNode; current != upperBound; current = current.next()) {
                if (upperBound != null && nodeComparator.compare((Element)current.get(), (Element)upperBound.get()) > 0) {
                    current.setSorted(1);
                    continue;
                }
                if (lowerBound != null && nodeComparator.compare((Element)current.get(), (Element)lowerBound.get()) < 0) {
                    current.setSorted(1);
                    continue;
                }
                current.setSorted(0);
                lowerBound = current;
            }
        }
        for (Element element : updateNodes) {
            assert (element.getSorted() != 2);
            int originalIndex = this.sorted.indexOfNode(element, (byte)1);
            if (element.getSorted() == 0) {
                this.updates.addUpdate(originalIndex);
                continue;
            }
            if (this.mode == 1) {
                this.updates.addUpdate(originalIndex);
                continue;
            }
            this.sorted.remove(element);
            this.updates.addDelete(originalIndex);
            int insertedIndex = this.insertByUnsortedNode((Element)element.get());
            this.updates.addInsert(insertedIndex);
        }
        while (!insertNodes.isEmpty()) {
            Element insertNode = (Element)insertNodes.removeFirst();
            int n = this.insertByUnsortedNode(insertNode);
            this.updates.addInsert(n);
        }
        this.updates.commitEvent();
    }

    private int insertByUnsortedNode(Element unsortedNode) {
        Element<Element> sortedNode = this.sorted.addInSortedOrder((byte)1, unsortedNode, 1);
        unsortedNode.set(sortedNode);
        return this.sorted.indexOfNode(sortedNode, (byte)1);
    }

    private int deleteByUnsortedNode(Element unsortedNode) {
        Element sortedNode = (Element)unsortedNode.get();
        int sortedIndex = this.sorted.indexOfNode(sortedNode, (byte)1);
        this.sorted.remove(sortedIndex, 1);
        return sortedIndex;
    }

    @Override
    protected int getSourceIndex(int mutationIndex) {
        Element<Element> sortedNode = this.sorted.get(mutationIndex);
        Element unsortedNode = sortedNode.get();
        return this.unsorted.indexOfNode(unsortedNode, (byte)1);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
        SimpleTree<Element> previousSorted = this.sorted;
        Comparator treeComparator = null;
        treeComparator = comparator != null ? new ElementComparator(comparator) : new ElementRawOrderComparator();
        this.sorted = new SimpleTree(treeComparator);
        if (previousSorted == null && this.unsorted == null) {
            this.unsorted = new SimpleTree();
            int n = this.source.size();
            for (int i = 0; i < n; ++i) {
                Element<Element> unsortedNode = this.unsorted.add(i, EMPTY_ELEMENT, 1);
                this.insertByUnsortedNode(unsortedNode);
            }
            return;
        }
        if (this.source.size() == 0) {
            return;
        }
        SimpleTreeIterator<Element> i = new SimpleTreeIterator<Element>(this.unsorted);
        while (i.hasNext()) {
            i.next();
            Element<Element> unsortedNode = i.node();
            this.insertByUnsortedNode(unsortedNode);
        }
        int[] reorderMap = new int[this.size()];
        int oldSortedIndex = 0;
        SimpleTreeIterator<Element> i2 = new SimpleTreeIterator<Element>(previousSorted);
        while (i2.hasNext()) {
            i2.next();
            Element<Element> oldSortedNode = i2.node();
            Element unsortedNode = oldSortedNode.get();
            Element newSortedNode = (Element)unsortedNode.get();
            int newSortedIndex = this.sorted.indexOfNode(newSortedNode, (byte)1);
            reorderMap[newSortedIndex] = oldSortedIndex++;
        }
        this.updates.beginEvent();
        this.updates.reorder(reorderMap);
        this.updates.commitEvent();
    }

    @Override
    public int indexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return this.source.indexOf(object);
        }
        int index = this.sorted.indexOfValue((Element)object, true, false, (byte)1);
        if (index == -1) {
            return -1;
        }
        while (index < this.size()) {
            Object objectAtIndex = this.get(index);
            if (this.comparator.compare(object, objectAtIndex) != 0) {
                return -1;
            }
            if (GlazedListsImpl.equal(object, objectAtIndex)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return this.source.lastIndexOf(object);
        }
        int index = this.sorted.indexOfValue((Element)object, false, false, (byte)1);
        if (index == -1) {
            return -1;
        }
        while (index > -1) {
            Object objectAtIndex = this.get(index);
            if (this.comparator.compare(object, objectAtIndex) != 0) {
                return -1;
            }
            if (GlazedListsImpl.equal(object, objectAtIndex)) {
                return index;
            }
            --index;
        }
        return -1;
    }

    public int sortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        return this.sorted.indexOfValue((Element)object, true, true, (byte)1);
    }

    public int lastSortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        return this.sorted.indexOfValue((Element)object, false, true, (byte)1);
    }

    public int indexOfSimulated(Object object) {
        return this.comparator != null ? this.sorted.indexOfValue((Element)object, true, true, (byte)1) : this.size();
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new SortedListIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedListIterator
    implements Iterator<E> {
        private SimpleTreeIterator<Element> treeIterator;

        private SortedListIterator() {
            this.treeIterator = new SimpleTreeIterator(SortedList.this.sorted);
        }

        @Override
        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        @Override
        public E next() {
            this.treeIterator.next();
            Element unsortedNode = this.treeIterator.value();
            return SortedList.this.source.get(SortedList.this.unsorted.indexOfNode(unsortedNode, (byte)1));
        }

        @Override
        public void remove() {
            int indexToRemove = this.treeIterator.index();
            SortedList.this.source.remove(SortedList.this.getSourceIndex(indexToRemove));
            this.treeIterator = new SimpleTreeIterator(SortedList.this.sorted, indexToRemove, 1);
        }
    }

    private class ElementRawOrderComparator
    implements Comparator {
        private ElementRawOrderComparator() {
        }

        public int compare(Object alpha, Object beta) {
            try {
                Element alphaTreeNode = (Element)alpha;
                Element betaTreeNode = (Element)beta;
                int alphaIndex = SortedList.this.unsorted.indexOfNode(alphaTreeNode, (byte)1);
                int betaIndex = SortedList.this.unsorted.indexOfNode(betaTreeNode, (byte)1);
                return alphaIndex - betaIndex;
            }
            catch (ClassCastException e) {
                System.out.println(alpha.getClass());
                System.out.println(beta.getClass());
                throw e;
            }
        }
    }

    private class ElementComparator
    implements Comparator {
        private Comparator comparator;

        public ElementComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object alpha, Object beta) {
            int result;
            Object alphaObject = alpha;
            Object betaObject = beta;
            int alphaIndex = -1;
            int betaIndex = -1;
            if (alpha instanceof Element) {
                Element alphaTreeNode = (Element)alpha;
                alphaIndex = SortedList.this.unsorted.indexOfNode(alphaTreeNode, (byte)1);
                alphaObject = SortedList.this.source.get(alphaIndex);
            }
            if (beta instanceof Element) {
                Element betaTreeNode = (Element)beta;
                betaIndex = SortedList.this.unsorted.indexOfNode(betaTreeNode, (byte)1);
                betaObject = SortedList.this.source.get(betaIndex);
            }
            if ((result = this.comparator.compare(alphaObject, betaObject)) != 0) {
                return result;
            }
            if (alphaIndex != -1 && betaIndex != -1) {
                return alphaIndex - betaIndex;
            }
            return 0;
        }
    }
}

