/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.windows.ExternalDropHandler;
import org.openide.windows.TopComponent;

final class QuietEditorPane
extends JEditorPane {
    private static final Logger LOG = Logger.getLogger(QuietEditorPane.class.getName());
    static final int FIRE = 1;
    static final int PAINT = 2;
    static final int ALL = 3;
    private int lastPosition = -1;
    int working = 0;
    private int fontHeight;
    private int charWidth;
    private static final Set<String> EXPENSIVE_PROPERTIES = new HashSet<String>(Arrays.asList("document", "editorKit", "keymap"));

    static DataFlavor constructActiveEditorDropFlavor() {
        try {
            return new DataFlavor("text/active_editor_flavor;class=org.openide.text.ActiveEditorDrop", "Active Editor Flavor", QuietEditorPane.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    public QuietEditorPane() {
        this.setFontHeightWidth(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFontHeightWidth(this.getFont());
    }

    private void setFontHeightWidth(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.fontHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('m');
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return this.fontHeight;
            }
            case 0: {
                return this.charWidth;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        if (document != null) {
            Serializable serializable;
            TransferHandler transferHandler = this.getTransferHandler();
            if (!(transferHandler instanceof DelegatingTransferHandler)) {
                serializable = new DelegatingTransferHandler(transferHandler);
                this.setTransferHandler((TransferHandler)serializable);
            }
            if (!((serializable = this.getDropTarget()) instanceof DelegatingDropTarget)) {
                DelegatingDropTarget delegatingDropTarget = new DelegatingDropTarget((DropTarget)serializable);
                this.setDropTarget(delegatingDropTarget);
            }
        }
    }

    public void setWorking(int n) {
        this.working = n;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("QEP@" + Integer.toHexString(System.identityHashCode(this)) + " firing is " + ((this.working & 1) == 0 ? "OFF" : "ON"));
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if ((this.working & 1) != 0 || string == null || !EXPENSIVE_PROPERTIES.contains(string)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("QEP@" + Integer.toHexString(System.identityHashCode(this)) + " firing '" + string + "' change event;" + " firing is " + ((this.working & 1) == 0 ? "OFF" : "ON"));
            }
            super.firePropertyChange(string, object, object2);
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("QEP@" + Integer.toHexString(System.identityHashCode(this)) + " suppressed '" + string + "' change event;" + " firing is OFF");
        }
    }

    public void setCaret(Caret caret) {
        Caret caret2;
        if (caret == null && (caret2 = this.getCaret()) != null) {
            this.lastPosition = caret2.getDot();
        }
        super.setCaret(caret);
    }

    int getLastPosition() {
        return this.lastPosition;
    }

    public void revalidate() {
        if ((this.working & 2) != 0) {
            super.revalidate();
        }
    }

    public void repaint() {
        if ((this.working & 2) != 0) {
            super.repaint();
        }
    }

    private class DelegatingDropTarget
    extends DropTarget
    implements UIResource {
        private DropTarget orig;
        private boolean isDragging = false;

        public DelegatingDropTarget(DropTarget dropTarget) {
            this.orig = dropTarget;
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            this.orig.removeDropTargetListener(dropTargetListener);
            this.orig.addDropTargetListener(dropTargetListener);
        }

        public void removeDropTargetListener(DropTargetListener dropTargetListener) {
            this.orig.removeDropTargetListener(dropTargetListener);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            ExternalDropHandler externalDropHandler = (ExternalDropHandler)Lookup.getDefault().lookup(ExternalDropHandler.class);
            if (null != externalDropHandler && externalDropHandler.canDrop(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(1);
                this.isDragging = false;
            } else {
                this.orig.dragEnter(dropTargetDragEvent);
                this.isDragging = true;
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.isDragging) {
                this.orig.dragExit(dropTargetEvent);
            }
            this.isDragging = false;
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            ExternalDropHandler externalDropHandler = (ExternalDropHandler)Lookup.getDefault().lookup(ExternalDropHandler.class);
            if (null != externalDropHandler && externalDropHandler.canDrop(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(1);
                this.isDragging = false;
            } else {
                this.orig.dragOver(dropTargetDragEvent);
                this.isDragging = true;
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            ExternalDropHandler externalDropHandler = (ExternalDropHandler)Lookup.getDefault().lookup(ExternalDropHandler.class);
            if (null != externalDropHandler && externalDropHandler.canDrop(dropTargetDropEvent)) {
                dropTargetDropEvent.acceptDrop(1);
                dropTargetDropEvent.dropComplete(externalDropHandler.handleDrop(dropTargetDropEvent));
            } else {
                this.orig.drop(dropTargetDropEvent);
            }
            this.isDragging = false;
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDragging) {
                this.orig.dropActionChanged(dropTargetDragEvent);
            }
        }
    }

    private class DelegatingTransferHandler
    extends TransferHandler {
        TransferHandler delegator;

        public DelegatingTransferHandler(TransferHandler transferHandler) {
            this.delegator = transferHandler;
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            this.delegator.exportAsDrag(jComponent, inputEvent, n);
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            this.delegator.exportToClipboard(jComponent, clipboard, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean importData(JComponent jComponent, Transferable transferable) {
            block5: {
                try {
                    Object object;
                    if (!transferable.isDataFlavorSupported(ActiveEditorDrop.FLAVOR) || !((object = transferable.getTransferData(ActiveEditorDrop.FLAVOR)) instanceof ActiveEditorDrop) || !(jComponent instanceof JTextComponent)) break block5;
                    boolean bl = false;
                    try {
                        bl = ((ActiveEditorDrop)object).handleTransfer((JTextComponent)jComponent);
                    }
                    finally {
                        this.requestFocus(jComponent);
                    }
                    return bl;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.delegator.importData(jComponent, transferable);
        }

        private void requestFocus(JComponent jComponent) {
            Container container = SwingUtilities.getAncestorOfClass(TopComponent.class, jComponent);
            if (container != null) {
                ((TopComponent)container).requestActive();
            } else {
                Container container2 = jComponent;
                while (!((container2 = container2.getParent()) instanceof Frame) && container2 != null) {
                }
                if (container2 != null) {
                    container2.requestFocus();
                }
                jComponent.requestFocus();
            }
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i] != ActiveEditorDrop.FLAVOR) continue;
                return true;
            }
            return this.delegator.canImport(jComponent, dataFlavorArray);
        }

        public int getSourceActions(JComponent jComponent) {
            return this.delegator.getSourceActions(jComponent);
        }

        public Icon getVisualRepresentation(Transferable transferable) {
            return this.delegator.getVisualRepresentation(transferable);
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            try {
                Method method = this.delegator.getClass().getDeclaredMethod("exportDone", JComponent.class, Transferable.class, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.delegator, jComponent, transferable, new Integer(n));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }

        protected Transferable createTransferable(JComponent jComponent) {
            try {
                Method method = this.delegator.getClass().getDeclaredMethod("createTransferable", JComponent.class);
                method.setAccessible(true);
                return (Transferable)method.invoke((Object)this.delegator, jComponent);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            return null;
        }
    }
}

