/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends SVGGElementBridge {
    public String getLocalName() {
        return "a";
    }

    public Bridge getInstance() {
        return new SVGAElementBridge();
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            EventListener eventListener = new AnchorListener(bridgeContext.getUserAgent());
            eventTarget.addEventListener("click", eventListener, false);
            bridgeContext.storeEventListener(eventTarget, "click", eventListener, false);
            eventListener = new CursorMouseOverListener(bridgeContext.getUserAgent());
            eventTarget.addEventListener("mouseover", eventListener, false);
            bridgeContext.storeEventListener(eventTarget, "mouseover", eventListener, false);
            eventListener = new CursorMouseOutListener(bridgeContext.getUserAgent());
            eventTarget.addEventListener("mouseout", eventListener, false);
            bridgeContext.storeEventListener(eventTarget, "mouseout", eventListener, false);
        }
    }

    public boolean isComposite() {
        return true;
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            if (AbstractEvent.getEventPreventDefault(event)) {
                return;
            }
            SVGAElement sVGAElement = (SVGAElement)event.getCurrentTarget();
            if (sVGAElement != null) {
                this.userAgent.displayMessage("");
            }
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement;
            if (AbstractEvent.getEventPreventDefault(event)) {
                return;
            }
            Element element = (Element)((Object)event.getTarget());
            if (CSSUtilities.isAutoCursor(element)) {
                this.userAgent.setSVGCursor(CursorManager.ANCHOR_CURSOR);
            }
            if ((sVGAElement = (SVGAElement)event.getCurrentTarget()) != null) {
                String string = XLinkSupport.getXLinkHref(sVGAElement);
                this.userAgent.displayMessage(string);
            }
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            if (AbstractEvent.getEventPreventDefault(event)) {
                return;
            }
            SVGAElement sVGAElement = (SVGAElement)event.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(sVGAElement);
            event.stopPropagation();
        }
    }
}

