/*
 * Decompiled with CFR 0.152.
 */
package tr.swing;

import java.text.DateFormat;
import java.util.Date;
import tr.swing.StyledString;

public class StyledDate
extends StyledString
implements Comparable {
    private Date date;
    private boolean showTime;
    private final DateFormat dateformat;
    private final DateFormat datetimeformat;

    public StyledDate(DateFormat dateformat, DateFormat datetimeformat) {
        this.dateformat = dateformat;
        this.datetimeformat = datetimeformat;
    }

    public synchronized void setDate(Date date) {
        this.date = date;
        if (date == null) {
            this.setString("");
            return;
        }
        try {
            this.setString(this.showTime ? this.datetimeformat.format(date) : this.dateformat.format(date));
        }
        catch (Exception ex) {
            this.setString("");
        }
    }

    public synchronized Date getDate() {
        return this.date;
    }

    public void setShowTime(boolean b) {
        this.showTime = b;
        this.setDate(this.date);
    }

    public int compareTo(Object object) {
        Date d2;
        if (!(object instanceof StyledDate)) {
            return -1;
        }
        Date d1 = this.getDate();
        if (d1 == (d2 = ((StyledDate)object).getDate())) {
            return 0;
        }
        if (d1 == null) {
            return 1;
        }
        if (d2 == null) {
            return -1;
        }
        return d1.compareTo(d2);
    }
}

