/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.annotation.JsonProperty;

public class JsonSchemaCreator {
    public static final Map<Class, String> natives = new HashMap<Class, String>();

    public static Map<String, Object> getSchema(Type t) {
        return JsonSchemaCreator.createSchemaFromType(t, new LinkedHashMap<String, Object>());
    }

    private static Map<String, Object> createSchemaFromType(Type t, Map<String, Object> map) {
        if (natives.containsKey(t)) {
            map.put("type", natives.get(t));
        } else if (t instanceof ParameterizedType && ((ParameterizedType)t).getRawType() == List.class) {
            Type typ = ((ParameterizedType)t).getActualTypeArguments()[0];
            map.put("type", "array");
            map.put("items", JsonSchemaCreator.getSchema(typ));
        } else {
            JsonSchemaCreator.createObjectSchema((Class)t, map);
        }
        return map;
    }

    private static void createObjectSchema(Class klas, Map<String, Object> map) {
        map.put("type", "object");
        HashMap<String, Map<String, Object>> props = new HashMap<String, Map<String, Object>>();
        map.put("properties", props);
        HashSet<String> required = new HashSet<String>();
        for (Field fld : klas.getDeclaredFields()) {
            JsonProperty p = fld.getAnnotation(JsonProperty.class);
            if (p == null) continue;
            String name = p.value().isEmpty() ? fld.getName() : p.value();
            props.put(name, JsonSchemaCreator.getSchema(fld.getGenericType()));
            if (!p.required()) continue;
            required.add(name);
        }
        if (!required.isEmpty()) {
            map.put("required", new ArrayList(required));
        }
    }

    static {
        natives.put(String.class, "string");
        natives.put(Integer.class, "integer");
        natives.put(Integer.TYPE, "integer");
        natives.put(Float.class, "number");
        natives.put(Float.TYPE, "number");
        natives.put(Double.class, "number");
        natives.put(Double.TYPE, "number");
        natives.put(Boolean.class, "boolean");
        natives.put(List.class, "array");
    }
}

