/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.carrot2.util.resource.FileResource;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.slf4j.LoggerFactory;

public final class DirLocator
implements IResourceLocator {
    private final Path dir;
    private final boolean canAccess;

    public DirLocator(Path dir) {
        this.dir = dir;
        boolean canAccess = true;
        try {
            canAccess = dir != null && Files.isDirectory(dir, new LinkOption[0]) && Files.isReadable(dir) && Files.isExecutable(dir);
        }
        catch (SecurityException e) {
            LoggerFactory.getLogger(DirLocator.class).warn("Security policy prevented access to folder: " + dir, (Throwable)e);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(DirLocator.class).warn("Could not access folder: " + dir, e);
        }
        this.canAccess = canAccess;
    }

    @Deprecated
    public DirLocator(File dir) {
        this(dir.toPath());
    }

    public DirLocator(String dirPath) {
        this(dirPath == null ? null : Paths.get(dirPath, new String[0]));
    }

    @Override
    public IResource[] getAll(String resource) {
        if (this.canAccess) {
            try {
                resource = resource.replace('/', File.separatorChar);
                while (resource.startsWith(File.separator)) {
                    resource = resource.substring(1);
                }
                Path resourcePath = this.dir.resolve(resource);
                if (Files.isRegularFile(resourcePath, new LinkOption[0]) && Files.isReadable(resourcePath)) {
                    return new IResource[]{new FileResource(resourcePath)};
                }
            }
            catch (SecurityException e) {
                LoggerFactory.getLogger(DirLocator.class).warn("Security policy prevented access to resource: " + resource + " in folder " + this.dir, (Throwable)e);
            }
        }
        return new IResource[0];
    }

    @Override
    public int hashCode() {
        return this.canAccess ? this.dir.hashCode() : 0;
    }

    @Override
    public boolean equals(Object target) {
        if (target == this) {
            return true;
        }
        if (target != null && target instanceof DirLocator) {
            DirLocator other = (DirLocator)target;
            try {
                return other.canAccess == this.canAccess && Files.isSameFile(other.dir, this.dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [dir: " + (this.canAccess ? this.dir.toAbsolutePath() : "<inaccessible>") + "]";
    }
}

